/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.FindRepliesParamsIF;
import com.hubspot.slack.client.methods.params.channels.ReplyQueryParams;
import com.hubspot.slack.client.models.ChannelType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class FindRepliesParams
implements FindRepliesParamsIF {
    private final String channelId;
    private final ChannelType channelType;
    private final String threadTs;

    private FindRepliesParams(String channelId, String threadTs) {
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.channelType = Objects.requireNonNull(FindRepliesParamsIF.super.getChannelType(), "channelType");
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public ChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    @JsonProperty(value="thread_ts")
    public String getThreadTs() {
        return this.threadTs;
    }

    public final FindRepliesParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new FindRepliesParams(newValue, this.threadTs);
    }

    public final FindRepliesParams withThreadTs(String threadTs) {
        if (this.threadTs.equals(threadTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(threadTs, "threadTs");
        return new FindRepliesParams(this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FindRepliesParams && this.equalTo((FindRepliesParams)another);
    }

    private boolean equalTo(FindRepliesParams another) {
        return this.channelId.equals(another.channelId) && this.channelType.equals((Object)another.channelType) && this.threadTs.equals(another.threadTs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + this.channelType.hashCode();
        h = h * 17 + this.threadTs.hashCode();
        return h;
    }

    public String toString() {
        return "FindRepliesParams{channelId=" + this.channelId + ", channelType=" + (Object)((Object)this.channelType) + ", threadTs=" + this.threadTs + "}";
    }

    @Deprecated
    @JsonCreator
    static FindRepliesParams fromJson(Json json) {
        Builder builder = FindRepliesParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        return builder.build();
    }

    public static FindRepliesParams copyOf(FindRepliesParamsIF instance) {
        if (instance instanceof FindRepliesParams) {
            return (FindRepliesParams)instance;
        }
        return FindRepliesParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_THREAD_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FindRepliesParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ReplyQueryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof FindRepliesParamsIF) {
                instance = (FindRepliesParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof ReplyQueryParams) {
                instance = (ReplyQueryParams)object;
                this.setThreadTs(instance.getThreadTs());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public FindRepliesParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new FindRepliesParams(this.channelId, this.threadTs);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            return "Cannot build FindRepliesParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FindRepliesParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String threadTs;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="thread_ts")
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }
    }
}

