package com.hubspot.slack.client.models.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ModalViewPayloadIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ModalViewPayload.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ModalViewPayload.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ModalViewPayloadIF"})
@Immutable
public final class ModalViewPayload implements ModalViewPayloadIF {
  private final Text title;
  private final List<Block> blocks;
  private final String type;
  private final @Nullable Text closeButtonText;
  private final @Nullable Text submitButtonText;
  private final @Nullable Boolean clearOnClose;
  private final @Nullable Boolean notifyOnClose;
  private final @Nullable String privateMetadata;
  private final @Nullable String callbackId;
  private final @Nullable String externalId;

  private ModalViewPayload(
      Text title,
      Iterable<? extends Block> blocks) {
    this.title = Objects.requireNonNull(title, "title");
    this.blocks = createUnmodifiableList(false, createSafeList(blocks, true, false));
    this.closeButtonText = null;
    this.submitButtonText = null;
    this.clearOnClose = null;
    this.notifyOnClose = null;
    this.privateMetadata = null;
    this.callbackId = null;
    this.externalId = null;
    this.type = Objects.requireNonNull(ModalViewPayloadIF.super.getType(), "type");
  }

  private ModalViewPayload(
      Text title,
      List<Block> blocks,
      @Nullable Text closeButtonText,
      @Nullable Text submitButtonText,
      @Nullable Boolean clearOnClose,
      @Nullable Boolean notifyOnClose,
      @Nullable String privateMetadata,
      @Nullable String callbackId,
      @Nullable String externalId) {
    this.title = title;
    this.blocks = blocks;
    this.closeButtonText = closeButtonText;
    this.submitButtonText = submitButtonText;
    this.clearOnClose = clearOnClose;
    this.notifyOnClose = notifyOnClose;
    this.privateMetadata = privateMetadata;
    this.callbackId = callbackId;
    this.externalId = externalId;
    this.type = Objects.requireNonNull(ModalViewPayloadIF.super.getType(), "type");
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Text getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    return blocks;
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code closeButtonText} attribute
   */
  @JsonProperty("close")
  @Override
  public Optional<Text> getCloseButtonText() {
    return Optional.ofNullable(closeButtonText);
  }

  /**
   * @return The value of the {@code submitButtonText} attribute
   */
  @JsonProperty("submit")
  @Override
  public Optional<Text> getSubmitButtonText() {
    return Optional.ofNullable(submitButtonText);
  }

  /**
   * @return The value of the {@code clearOnClose} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getClearOnClose() {
    return Optional.ofNullable(clearOnClose);
  }

  /**
   * @return The value of the {@code notifyOnClose} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getNotifyOnClose() {
    return Optional.ofNullable(notifyOnClose);
  }

  /**
   * @return The value of the {@code privateMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPrivateMetadata() {
    return Optional.ofNullable(privateMetadata);
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCallbackId() {
    return Optional.ofNullable(callbackId);
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewPayloadIF#getTitle() title} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewPayload withTitle(Text title) {
    if (this.title == title) return this;
    Text newValue = Objects.requireNonNull(title, "title");
    return new ModalViewPayload(
        newValue,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModalViewPayloadIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ModalViewPayload(
        this.title,
        newValue,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModalViewPayloadIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ModalViewPayload(
        this.title,
        newValue,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getCloseButtonText() closeButtonText} attribute.
   * @param value The value for closeButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withCloseButtonText(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.closeButtonText == newValue) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        newValue,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getCloseButtonText() closeButtonText} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closeButtonText
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withCloseButtonText(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.closeButtonText == value) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        value,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getSubmitButtonText() submitButtonText} attribute.
   * @param value The value for submitButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withSubmitButtonText(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.submitButtonText == newValue) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        newValue,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getSubmitButtonText() submitButtonText} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for submitButtonText
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withSubmitButtonText(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.submitButtonText == value) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        value,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getClearOnClose() clearOnClose} attribute.
   * @param value The value for clearOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withClearOnClose(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.clearOnClose, newValue)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        newValue,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getClearOnClose() clearOnClose} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for clearOnClose
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withClearOnClose(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.clearOnClose, value)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        value,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getNotifyOnClose() notifyOnClose} attribute.
   * @param value The value for notifyOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withNotifyOnClose(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.notifyOnClose, newValue)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        newValue,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getNotifyOnClose() notifyOnClose} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notifyOnClose
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withNotifyOnClose(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.notifyOnClose, value)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        value,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * @param value The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withPrivateMetadata(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.privateMetadata, newValue)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        newValue,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateMetadata
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withPrivateMetadata(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privateMetadata, value)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        value,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getCallbackId() callbackId} attribute.
   * @param value The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withCallbackId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.callbackId, newValue)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        newValue,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getCallbackId() callbackId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for callbackId
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withCallbackId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.callbackId, value)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        value,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewPayloadIF#getExternalId() externalId} attribute.
   * @param value The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withExternalId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewPayloadIF#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ModalViewPayload withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ModalViewPayload(
        this.title,
        this.blocks,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.privateMetadata,
        this.callbackId,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ModalViewPayload} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ModalViewPayload
        && equalTo((ModalViewPayload) another);
  }

  private boolean equalTo(ModalViewPayload another) {
    return title.equals(another.title)
        && blocks.equals(another.blocks)
        && type.equals(another.type)
        && Objects.equals(closeButtonText, another.closeButtonText)
        && Objects.equals(submitButtonText, another.submitButtonText)
        && Objects.equals(clearOnClose, another.clearOnClose)
        && Objects.equals(notifyOnClose, another.notifyOnClose)
        && Objects.equals(privateMetadata, another.privateMetadata)
        && Objects.equals(callbackId, another.callbackId)
        && Objects.equals(externalId, another.externalId);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code blocks}, {@code type}, {@code closeButtonText}, {@code submitButtonText}, {@code clearOnClose}, {@code notifyOnClose}, {@code privateMetadata}, {@code callbackId}, {@code externalId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + title.hashCode();
    h = h * 17 + blocks.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(closeButtonText);
    h = h * 17 + Objects.hashCode(submitButtonText);
    h = h * 17 + Objects.hashCode(clearOnClose);
    h = h * 17 + Objects.hashCode(notifyOnClose);
    h = h * 17 + Objects.hashCode(privateMetadata);
    h = h * 17 + Objects.hashCode(callbackId);
    h = h * 17 + Objects.hashCode(externalId);
    return h;
  }

  /**
   * Prints the immutable value {@code ModalViewPayload} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ModalViewPayload{");
    builder.append("title=").append(title);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    builder.append(", ");
    builder.append("type=").append(type);
    if (closeButtonText != null) {
      builder.append(", ");
      builder.append("closeButtonText=").append(closeButtonText);
    }
    if (submitButtonText != null) {
      builder.append(", ");
      builder.append("submitButtonText=").append(submitButtonText);
    }
    if (clearOnClose != null) {
      builder.append(", ");
      builder.append("clearOnClose=").append(clearOnClose);
    }
    if (notifyOnClose != null) {
      builder.append(", ");
      builder.append("notifyOnClose=").append(notifyOnClose);
    }
    if (privateMetadata != null) {
      builder.append(", ");
      builder.append("privateMetadata=").append(privateMetadata);
    }
    if (callbackId != null) {
      builder.append(", ");
      builder.append("callbackId=").append(callbackId);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ModalViewPayloadIF {
    @Nullable Text title;
    List<Block> blocks = Collections.emptyList();
    Optional<Text> closeButtonText = Optional.empty();
    Optional<Text> submitButtonText = Optional.empty();
    Optional<Boolean> clearOnClose = Optional.empty();
    Optional<Boolean> notifyOnClose = Optional.empty();
    Optional<String> privateMetadata = Optional.empty();
    Optional<String> callbackId = Optional.empty();
    Optional<String> externalId = Optional.empty();
    @JsonProperty
    public void setTitle(Text title) {
      this.title = title;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
    }
    @JsonProperty("close")
    public void setCloseButtonText(Optional<Text> closeButtonText) {
      this.closeButtonText = closeButtonText;
    }
    @JsonProperty("submit")
    public void setSubmitButtonText(Optional<Text> submitButtonText) {
      this.submitButtonText = submitButtonText;
    }
    @JsonProperty
    public void setClearOnClose(Optional<Boolean> clearOnClose) {
      this.clearOnClose = clearOnClose;
    }
    @JsonProperty
    public void setNotifyOnClose(Optional<Boolean> notifyOnClose) {
      this.notifyOnClose = notifyOnClose;
    }
    @JsonProperty
    public void setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata;
    }
    @JsonProperty
    public void setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @Override
    public Text getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getCloseButtonText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getSubmitButtonText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getClearOnClose() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getNotifyOnClose() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPrivateMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExternalId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ModalViewPayload fromJson(Json json) {
    ModalViewPayload.Builder builder = ModalViewPayload.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.blocks != null) {
      builder.addAllBlocks(json.blocks);
    }
    if (json.closeButtonText != null) {
      builder.setCloseButtonText(json.closeButtonText);
    }
    if (json.submitButtonText != null) {
      builder.setSubmitButtonText(json.submitButtonText);
    }
    if (json.clearOnClose != null) {
      builder.setClearOnClose(json.clearOnClose);
    }
    if (json.notifyOnClose != null) {
      builder.setNotifyOnClose(json.notifyOnClose);
    }
    if (json.privateMetadata != null) {
      builder.setPrivateMetadata(json.privateMetadata);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.externalId != null) {
      builder.setExternalId(json.externalId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ModalViewPayload} instance.
   * @param title The value for the {@code title} attribute
   * @param blocks The value for the {@code blocks} attribute
   * @return An immutable ModalViewPayload instance
   */
  public static ModalViewPayload of(Text title, List<Block> blocks) {
    return of(title, (Iterable<? extends Block>) blocks);
  }

  /**
   * Construct a new immutable {@code ModalViewPayload} instance.
   * @param title The value for the {@code title} attribute
   * @param blocks The value for the {@code blocks} attribute
   * @return An immutable ModalViewPayload instance
   */
  public static ModalViewPayload of(Text title, Iterable<? extends Block> blocks) {
    return new ModalViewPayload(title, blocks);
  }

  /**
   * Creates an immutable copy of a {@link ModalViewPayloadIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ModalViewPayload instance
   */
  public static ModalViewPayload copyOf(ModalViewPayloadIF instance) {
    if (instance instanceof ModalViewPayload) {
      return (ModalViewPayload) instance;
    }
    return ModalViewPayload.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ModalViewPayload ModalViewPayload}.
   * @return A new ModalViewPayload builder
   */
  public static ModalViewPayload.Builder builder() {
    return new ModalViewPayload.Builder();
  }

  /**
   * Builds instances of type {@link ModalViewPayload ModalViewPayload}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Text title;
    private List<Block> blocks = new ArrayList<Block>();
    private @Nullable Text closeButtonText;
    private @Nullable Text submitButtonText;
    private @Nullable Boolean clearOnClose;
    private @Nullable Boolean notifyOnClose;
    private @Nullable String privateMetadata;
    private @Nullable String callbackId;
    private @Nullable String externalId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ModalViewPayloadIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModalViewPayloadIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ModalViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModalViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ModalViewPayloadIF) {
        ModalViewPayloadIF instance = (ModalViewPayloadIF) object;
        if ((bits & 0x2L) == 0) {
          setTitle(instance.getTitle());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          addAllBlocks(instance.getBlocks());
          bits |= 0x1L;
        }
      }
      if (object instanceof ModalViewPayloadBase) {
        ModalViewPayloadBase instance = (ModalViewPayloadBase) object;
        Optional<Text> submitButtonTextOptional = instance.getSubmitButtonText();
        if (submitButtonTextOptional.isPresent()) {
          setSubmitButtonText(submitButtonTextOptional);
        }
        Optional<Boolean> notifyOnCloseOptional = instance.getNotifyOnClose();
        if (notifyOnCloseOptional.isPresent()) {
          setNotifyOnClose(notifyOnCloseOptional);
        }
        Optional<Text> closeButtonTextOptional = instance.getCloseButtonText();
        if (closeButtonTextOptional.isPresent()) {
          setCloseButtonText(closeButtonTextOptional);
        }
        if ((bits & 0x2L) == 0) {
          setTitle(instance.getTitle());
          bits |= 0x2L;
        }
        Optional<Boolean> clearOnCloseOptional = instance.getClearOnClose();
        if (clearOnCloseOptional.isPresent()) {
          setClearOnClose(clearOnCloseOptional);
        }
      }
      if (object instanceof ViewPayloadBase) {
        ViewPayloadBase instance = (ViewPayloadBase) object;
        Optional<String> externalIdOptional = instance.getExternalId();
        if (externalIdOptional.isPresent()) {
          setExternalId(externalIdOptional);
        }
        Optional<String> privateMetadataOptional = instance.getPrivateMetadata();
        if (privateMetadataOptional.isPresent()) {
          setPrivateMetadata(privateMetadataOptional);
        }
        Optional<String> callbackIdOptional = instance.getCallbackId();
        if (callbackIdOptional.isPresent()) {
          setCallbackId(callbackIdOptional);
        }
        if ((bits & 0x1L) == 0) {
          addAllBlocks(instance.getBlocks());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ModalViewPayloadIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Text title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Adds one element to {@link ModalViewPayloadIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      return this;
    }

    /**
     * Adds elements to {@link ModalViewPayloadIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ModalViewPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link ModalViewPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getCloseButtonText() closeButtonText} to closeButtonText.
     * @param closeButtonText The value for closeButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCloseButtonText(@Nullable Text closeButtonText) {
      this.closeButtonText = closeButtonText;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getCloseButtonText() closeButtonText} to closeButtonText.
     * @param closeButtonText The value for closeButtonText
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCloseButtonText(Optional<Text> closeButtonText) {
      this.closeButtonText = closeButtonText.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getSubmitButtonText() submitButtonText} to submitButtonText.
     * @param submitButtonText The value for submitButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubmitButtonText(@Nullable Text submitButtonText) {
      this.submitButtonText = submitButtonText;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getSubmitButtonText() submitButtonText} to submitButtonText.
     * @param submitButtonText The value for submitButtonText
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubmitButtonText(Optional<Text> submitButtonText) {
      this.submitButtonText = submitButtonText.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getClearOnClose() clearOnClose} to clearOnClose.
     * @param clearOnClose The value for clearOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setClearOnClose(@Nullable Boolean clearOnClose) {
      this.clearOnClose = clearOnClose;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getClearOnClose() clearOnClose} to clearOnClose.
     * @param clearOnClose The value for clearOnClose
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setClearOnClose(Optional<Boolean> clearOnClose) {
      this.clearOnClose = clearOnClose.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getNotifyOnClose() notifyOnClose} to notifyOnClose.
     * @param notifyOnClose The value for notifyOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNotifyOnClose(@Nullable Boolean notifyOnClose) {
      this.notifyOnClose = notifyOnClose;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getNotifyOnClose() notifyOnClose} to notifyOnClose.
     * @param notifyOnClose The value for notifyOnClose
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNotifyOnClose(Optional<Boolean> notifyOnClose) {
      this.notifyOnClose = notifyOnClose.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
      this.privateMetadata = privateMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCallbackId(@Nullable String callbackId) {
      this.callbackId = callbackId;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ModalViewPayload ModalViewPayload}.
     * @return An immutable instance of ModalViewPayload
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ModalViewPayload build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ModalViewPayload(
          title,
          createUnmodifiableList(true, blocks),
          closeButtonText,
          submitButtonText,
          clearOnClose,
          notifyOnClose,
          privateMetadata,
          callbackId,
          externalId);
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!titleIsSet()) attributes.add("title");
      return "Cannot build ModalViewPayload, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
