package com.hubspot.slack.client.models.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HomeTabViewPayloadIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HomeTabViewPayload.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code HomeTabViewPayload.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HomeTabViewPayloadIF"})
@Immutable
public final class HomeTabViewPayload implements HomeTabViewPayloadIF {
  private final List<Block> blocks;
  private final String type;
  private final @Nullable String privateMetadata;
  private final @Nullable String callbackId;
  private final @Nullable String externalId;

  private HomeTabViewPayload(Iterable<? extends Block> blocks) {
    this.blocks = createUnmodifiableList(false, createSafeList(blocks, true, false));
    this.privateMetadata = null;
    this.callbackId = null;
    this.externalId = null;
    this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
  }

  private HomeTabViewPayload(
      List<Block> blocks,
      @Nullable String privateMetadata,
      @Nullable String callbackId,
      @Nullable String externalId) {
    this.blocks = blocks;
    this.privateMetadata = privateMetadata;
    this.callbackId = callbackId;
    this.externalId = externalId;
    this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    return blocks;
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code privateMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPrivateMetadata() {
    return Optional.ofNullable(privateMetadata);
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCallbackId() {
    return Optional.ofNullable(callbackId);
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HomeTabViewPayloadIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new HomeTabViewPayload(newValue, this.privateMetadata, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HomeTabViewPayloadIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new HomeTabViewPayload(newValue, this.privateMetadata, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HomeTabViewPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * @param value The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withPrivateMetadata(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.privateMetadata, newValue)) return this;
    return new HomeTabViewPayload(this.blocks, newValue, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HomeTabViewPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateMetadata
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withPrivateMetadata(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privateMetadata, value)) return this;
    return new HomeTabViewPayload(this.blocks, value, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HomeTabViewPayloadIF#getCallbackId() callbackId} attribute.
   * @param value The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withCallbackId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.callbackId, newValue)) return this;
    return new HomeTabViewPayload(this.blocks, this.privateMetadata, newValue, this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HomeTabViewPayloadIF#getCallbackId() callbackId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for callbackId
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withCallbackId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.callbackId, value)) return this;
    return new HomeTabViewPayload(this.blocks, this.privateMetadata, value, this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HomeTabViewPayloadIF#getExternalId() externalId} attribute.
   * @param value The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withExternalId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.externalId, newValue)) return this;
    return new HomeTabViewPayload(this.blocks, this.privateMetadata, this.callbackId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HomeTabViewPayloadIF#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final HomeTabViewPayload withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new HomeTabViewPayload(this.blocks, this.privateMetadata, this.callbackId, value);
  }

  /**
   * This instance is equal to all instances of {@code HomeTabViewPayload} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof HomeTabViewPayload
        && equalTo((HomeTabViewPayload) another);
  }

  private boolean equalTo(HomeTabViewPayload another) {
    return blocks.equals(another.blocks)
        && type.equals(another.type)
        && Objects.equals(privateMetadata, another.privateMetadata)
        && Objects.equals(callbackId, another.callbackId)
        && Objects.equals(externalId, another.externalId);
  }

  /**
   * Computes a hash code from attributes: {@code blocks}, {@code type}, {@code privateMetadata}, {@code callbackId}, {@code externalId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + blocks.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(privateMetadata);
    h = h * 17 + Objects.hashCode(callbackId);
    h = h * 17 + Objects.hashCode(externalId);
    return h;
  }

  /**
   * Prints the immutable value {@code HomeTabViewPayload} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("HomeTabViewPayload{");
    builder.append("blocks=").append(blocks);
    builder.append(", ");
    builder.append("type=").append(type);
    if (privateMetadata != null) {
      builder.append(", ");
      builder.append("privateMetadata=").append(privateMetadata);
    }
    if (callbackId != null) {
      builder.append(", ");
      builder.append("callbackId=").append(callbackId);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements HomeTabViewPayloadIF {
    List<Block> blocks = Collections.emptyList();
    Optional<String> privateMetadata = Optional.empty();
    Optional<String> callbackId = Optional.empty();
    Optional<String> externalId = Optional.empty();
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
    }
    @JsonProperty
    public void setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata;
    }
    @JsonProperty
    public void setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPrivateMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExternalId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static HomeTabViewPayload fromJson(Json json) {
    HomeTabViewPayload.Builder builder = HomeTabViewPayload.builder();
    if (json.blocks != null) {
      builder.addAllBlocks(json.blocks);
    }
    if (json.privateMetadata != null) {
      builder.setPrivateMetadata(json.privateMetadata);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.externalId != null) {
      builder.setExternalId(json.externalId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code HomeTabViewPayload} instance.
   * @param blocks The value for the {@code blocks} attribute
   * @return An immutable HomeTabViewPayload instance
   */
  public static HomeTabViewPayload of(List<Block> blocks) {
    return of((Iterable<? extends Block>) blocks);
  }

  /**
   * Construct a new immutable {@code HomeTabViewPayload} instance.
   * @param blocks The value for the {@code blocks} attribute
   * @return An immutable HomeTabViewPayload instance
   */
  public static HomeTabViewPayload of(Iterable<? extends Block> blocks) {
    return new HomeTabViewPayload(blocks);
  }

  /**
   * Creates an immutable copy of a {@link HomeTabViewPayloadIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HomeTabViewPayload instance
   */
  public static HomeTabViewPayload copyOf(HomeTabViewPayloadIF instance) {
    if (instance instanceof HomeTabViewPayload) {
      return (HomeTabViewPayload) instance;
    }
    return HomeTabViewPayload.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link HomeTabViewPayload HomeTabViewPayload}.
   * @return A new HomeTabViewPayload builder
   */
  public static HomeTabViewPayload.Builder builder() {
    return new HomeTabViewPayload.Builder();
  }

  /**
   * Builds instances of type {@link HomeTabViewPayload HomeTabViewPayload}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<Block> blocks = new ArrayList<Block>();
    private @Nullable String privateMetadata;
    private @Nullable String callbackId;
    private @Nullable String externalId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.HomeTabViewPayloadIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HomeTabViewPayloadIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ViewPayloadBase) {
        ViewPayloadBase instance = (ViewPayloadBase) object;
        Optional<String> externalIdOptional = instance.getExternalId();
        if (externalIdOptional.isPresent()) {
          setExternalId(externalIdOptional);
        }
        Optional<String> privateMetadataOptional = instance.getPrivateMetadata();
        if (privateMetadataOptional.isPresent()) {
          setPrivateMetadata(privateMetadataOptional);
        }
        Optional<String> callbackIdOptional = instance.getCallbackId();
        if (callbackIdOptional.isPresent()) {
          setCallbackId(callbackIdOptional);
        }
        if ((bits & 0x1L) == 0) {
          addAllBlocks(instance.getBlocks());
          bits |= 0x1L;
        }
      }
      if (object instanceof HomeTabViewPayloadIF) {
        HomeTabViewPayloadIF instance = (HomeTabViewPayloadIF) object;
        if ((bits & 0x1L) == 0) {
          addAllBlocks(instance.getBlocks());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Adds one element to {@link HomeTabViewPayloadIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      return this;
    }

    /**
     * Adds elements to {@link HomeTabViewPayloadIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link HomeTabViewPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link HomeTabViewPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
      this.privateMetadata = privateMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCallbackId(@Nullable String callbackId) {
      this.callbackId = callbackId;
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the optional value {@link HomeTabViewPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link HomeTabViewPayload HomeTabViewPayload}.
     * @return An immutable instance of HomeTabViewPayload
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public HomeTabViewPayload build() throws InvalidImmutableStateException {
      return new HomeTabViewPayload(createUnmodifiableList(true, blocks), privateMetadata, callbackId, externalId);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
