package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.json.UserProfileFieldsDeserializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UserProfileIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UserProfile.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UserProfileIF"})
@Immutable
public final class UserProfile implements UserProfileIF {
  private final @Nullable String username;
  private final @Nullable String usernameNormalized;
  private final @Nullable String realName;
  private final @Nullable String realNameNormalized;
  private final @Nullable String email;
  private final @Nullable String statusText;
  private final @Nullable String statusEmoji;
  private final @Nullable String title;
  private final @Nullable String phone;
  private final @Nullable String skype;
  private final @Nullable Map<String, ProfileField> fields;
  private final @Nullable String teamId;
  private final @Nullable String avatarHash;
  private final @Nullable String imageOriginal;
  private final @Nullable String image24;
  private final @Nullable String image32;
  private final @Nullable String image48;
  private final @Nullable String image72;
  private final @Nullable String image192;
  private final @Nullable String image512;
  private final @Nullable String image1024;

  private UserProfile(
      @Nullable String username,
      @Nullable String usernameNormalized,
      @Nullable String realName,
      @Nullable String realNameNormalized,
      @Nullable String email,
      @Nullable String statusText,
      @Nullable String statusEmoji,
      @Nullable String title,
      @Nullable String phone,
      @Nullable String skype,
      @Nullable Map<String, ProfileField> fields,
      @Nullable String teamId,
      @Nullable String avatarHash,
      @Nullable String imageOriginal,
      @Nullable String image24,
      @Nullable String image32,
      @Nullable String image48,
      @Nullable String image72,
      @Nullable String image192,
      @Nullable String image512,
      @Nullable String image1024) {
    this.username = username;
    this.usernameNormalized = usernameNormalized;
    this.realName = realName;
    this.realNameNormalized = realNameNormalized;
    this.email = email;
    this.statusText = statusText;
    this.statusEmoji = statusEmoji;
    this.title = title;
    this.phone = phone;
    this.skype = skype;
    this.fields = fields;
    this.teamId = teamId;
    this.avatarHash = avatarHash;
    this.imageOriginal = imageOriginal;
    this.image24 = image24;
    this.image32 = image32;
    this.image48 = image48;
    this.image72 = image72;
    this.image192 = image192;
    this.image512 = image512;
    this.image1024 = image1024;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty("display_name")
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * @return The value of the {@code usernameNormalized} attribute
   */
  @JsonProperty("display_name_normalized")
  @Override
  public Optional<String> getUsernameNormalized() {
    return Optional.ofNullable(usernameNormalized);
  }

  /**
   * @return The value of the {@code realName} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getRealName() {
    return Optional.ofNullable(realName);
  }

  /**
   * @return The value of the {@code realNameNormalized} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getRealNameNormalized() {
    return Optional.ofNullable(realNameNormalized);
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getEmail() {
    return Optional.ofNullable(email);
  }

  /**
   * @return The value of the {@code statusText} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getStatusText() {
    return Optional.ofNullable(statusText);
  }

  /**
   * @return The value of the {@code statusEmoji} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getStatusEmoji() {
    return Optional.ofNullable(statusEmoji);
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTitle() {
    return Optional.ofNullable(title);
  }

  /**
   * @return The value of the {@code phone} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPhone() {
    return Optional.ofNullable(phone);
  }

  /**
   * @return The value of the {@code skype} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getSkype() {
    return Optional.ofNullable(skype);
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty
  @JsonDeserialize(using = UserProfileFieldsDeserializer.class)
  @Override
  public Optional<Map<String, ProfileField>> getFields() {
    return Optional.ofNullable(fields);
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty("team")
  @Override
  public Optional<String> getTeamId() {
    return Optional.ofNullable(teamId);
  }

  /**
   * @return The value of the {@code avatarHash} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getAvatarHash() {
    return Optional.ofNullable(avatarHash);
  }

  /**
   * @return The value of the {@code imageOriginal} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getImageOriginal() {
    return Optional.ofNullable(imageOriginal);
  }

  /**
   * @return The value of the {@code image24} attribute
   */
  @JsonProperty("image_24")
  @Override
  public Optional<String> getImage24() {
    return Optional.ofNullable(image24);
  }

  /**
   * @return The value of the {@code image32} attribute
   */
  @JsonProperty("image_32")
  @Override
  public Optional<String> getImage32() {
    return Optional.ofNullable(image32);
  }

  /**
   * @return The value of the {@code image48} attribute
   */
  @JsonProperty("image_48")
  @Override
  public Optional<String> getImage48() {
    return Optional.ofNullable(image48);
  }

  /**
   * @return The value of the {@code image72} attribute
   */
  @JsonProperty("image_72")
  @Override
  public Optional<String> getImage72() {
    return Optional.ofNullable(image72);
  }

  /**
   * @return The value of the {@code image192} attribute
   */
  @JsonProperty("image_192")
  @Override
  public Optional<String> getImage192() {
    return Optional.ofNullable(image192);
  }

  /**
   * @return The value of the {@code image512} attribute
   */
  @JsonProperty("image_512")
  @Override
  public Optional<String> getImage512() {
    return Optional.ofNullable(image512);
  }

  /**
   * @return The value of the {@code image1024} attribute
   */
  @JsonProperty("image_1024")
  @Override
  public Optional<String> getImage1024() {
    return Optional.ofNullable(image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getUsername() username} attribute.
   * @param value The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withUsername(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.username, newValue)) return this;
    return new UserProfile(
        newValue,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getUsername() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return new UserProfile(
        value,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getUsernameNormalized() usernameNormalized} attribute.
   * @param value The value for usernameNormalized, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withUsernameNormalized(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.usernameNormalized, newValue)) return this;
    return new UserProfile(
        this.username,
        newValue,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getUsernameNormalized() usernameNormalized} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for usernameNormalized
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withUsernameNormalized(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.usernameNormalized, value)) return this;
    return new UserProfile(
        this.username,
        value,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getRealName() realName} attribute.
   * @param value The value for realName, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withRealName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.realName, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        newValue,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getRealName() realName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for realName
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withRealName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.realName, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        value,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getRealNameNormalized() realNameNormalized} attribute.
   * @param value The value for realNameNormalized, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withRealNameNormalized(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.realNameNormalized, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        newValue,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getRealNameNormalized() realNameNormalized} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for realNameNormalized
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withRealNameNormalized(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.realNameNormalized, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        value,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getEmail() email} attribute.
   * @param value The value for email, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withEmail(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.email, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        newValue,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getEmail() email} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for email
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withEmail(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.email, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        value,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getStatusText() statusText} attribute.
   * @param value The value for statusText, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withStatusText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.statusText, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        newValue,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getStatusText() statusText} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for statusText
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withStatusText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.statusText, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        value,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getStatusEmoji() statusEmoji} attribute.
   * @param value The value for statusEmoji, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withStatusEmoji(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.statusEmoji, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        newValue,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getStatusEmoji() statusEmoji} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for statusEmoji
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withStatusEmoji(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.statusEmoji, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        value,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getTitle() title} attribute.
   * @param value The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withTitle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.title, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        newValue,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getTitle() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        value,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getPhone() phone} attribute.
   * @param value The value for phone, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withPhone(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.phone, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        newValue,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getPhone() phone} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for phone
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withPhone(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.phone, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        value,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getSkype() skype} attribute.
   * @param value The value for skype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withSkype(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.skype, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        newValue,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getSkype() skype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for skype
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withSkype(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.skype, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        value,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getFields() fields} attribute.
   * @param value The value for fields, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withFields(@Nullable Map<String, ProfileField> value) {
    @Nullable Map<String, ProfileField> newValue = value;
    if (this.fields == newValue) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        newValue,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getFields() fields} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for fields
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withFields(Optional<Map<String, ProfileField>> optional) {
    @Nullable Map<String, ProfileField> value = optional.orElse(null);
    if (this.fields == value) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        value,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getTeamId() teamId} attribute.
   * @param value The value for teamId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withTeamId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.teamId, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        newValue,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getTeamId() teamId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for teamId
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withTeamId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.teamId, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        value,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getAvatarHash() avatarHash} attribute.
   * @param value The value for avatarHash, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withAvatarHash(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.avatarHash, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        newValue,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getAvatarHash() avatarHash} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for avatarHash
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withAvatarHash(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.avatarHash, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        value,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImageOriginal() imageOriginal} attribute.
   * @param value The value for imageOriginal, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImageOriginal(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.imageOriginal, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        newValue,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImageOriginal() imageOriginal} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageOriginal
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImageOriginal(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.imageOriginal, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        value,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage24() image24} attribute.
   * @param value The value for image24, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage24(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image24, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        newValue,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage24() image24} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image24
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage24(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image24, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        value,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage32() image32} attribute.
   * @param value The value for image32, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage32(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image32, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        newValue,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage32() image32} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image32
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage32(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image32, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        value,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage48() image48} attribute.
   * @param value The value for image48, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage48(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image48, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        newValue,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage48() image48} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image48
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage48(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image48, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        value,
        this.image72,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage72() image72} attribute.
   * @param value The value for image72, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage72(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image72, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        newValue,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage72() image72} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image72
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage72(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image72, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        value,
        this.image192,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage192() image192} attribute.
   * @param value The value for image192, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage192(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image192, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        newValue,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage192() image192} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image192
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage192(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image192, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        value,
        this.image512,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage512() image512} attribute.
   * @param value The value for image512, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage512(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image512, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        newValue,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage512() image512} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image512
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage512(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image512, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        value,
        this.image1024);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserProfileIF#getImage1024() image1024} attribute.
   * @param value The value for image1024, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage1024(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.image1024, newValue)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserProfileIF#getImage1024() image1024} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for image1024
   * @return A modified copy of {@code this} object
   */
  public final UserProfile withImage1024(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.image1024, value)) return this;
    return new UserProfile(
        this.username,
        this.usernameNormalized,
        this.realName,
        this.realNameNormalized,
        this.email,
        this.statusText,
        this.statusEmoji,
        this.title,
        this.phone,
        this.skype,
        this.fields,
        this.teamId,
        this.avatarHash,
        this.imageOriginal,
        this.image24,
        this.image32,
        this.image48,
        this.image72,
        this.image192,
        this.image512,
        value);
  }

  /**
   * This instance is equal to all instances of {@code UserProfile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UserProfile
        && equalTo((UserProfile) another);
  }

  private boolean equalTo(UserProfile another) {
    return Objects.equals(username, another.username)
        && Objects.equals(usernameNormalized, another.usernameNormalized)
        && Objects.equals(realName, another.realName)
        && Objects.equals(realNameNormalized, another.realNameNormalized)
        && Objects.equals(email, another.email)
        && Objects.equals(statusText, another.statusText)
        && Objects.equals(statusEmoji, another.statusEmoji)
        && Objects.equals(title, another.title)
        && Objects.equals(phone, another.phone)
        && Objects.equals(skype, another.skype)
        && Objects.equals(fields, another.fields)
        && Objects.equals(teamId, another.teamId)
        && Objects.equals(avatarHash, another.avatarHash)
        && Objects.equals(imageOriginal, another.imageOriginal)
        && Objects.equals(image24, another.image24)
        && Objects.equals(image32, another.image32)
        && Objects.equals(image48, another.image48)
        && Objects.equals(image72, another.image72)
        && Objects.equals(image192, another.image192)
        && Objects.equals(image512, another.image512)
        && Objects.equals(image1024, another.image1024);
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code usernameNormalized}, {@code realName}, {@code realNameNormalized}, {@code email}, {@code statusText}, {@code statusEmoji}, {@code title}, {@code phone}, {@code skype}, {@code fields}, {@code teamId}, {@code avatarHash}, {@code imageOriginal}, {@code image24}, {@code image32}, {@code image48}, {@code image72}, {@code image192}, {@code image512}, {@code image1024}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(username);
    h = h * 17 + Objects.hashCode(usernameNormalized);
    h = h * 17 + Objects.hashCode(realName);
    h = h * 17 + Objects.hashCode(realNameNormalized);
    h = h * 17 + Objects.hashCode(email);
    h = h * 17 + Objects.hashCode(statusText);
    h = h * 17 + Objects.hashCode(statusEmoji);
    h = h * 17 + Objects.hashCode(title);
    h = h * 17 + Objects.hashCode(phone);
    h = h * 17 + Objects.hashCode(skype);
    h = h * 17 + Objects.hashCode(fields);
    h = h * 17 + Objects.hashCode(teamId);
    h = h * 17 + Objects.hashCode(avatarHash);
    h = h * 17 + Objects.hashCode(imageOriginal);
    h = h * 17 + Objects.hashCode(image24);
    h = h * 17 + Objects.hashCode(image32);
    h = h * 17 + Objects.hashCode(image48);
    h = h * 17 + Objects.hashCode(image72);
    h = h * 17 + Objects.hashCode(image192);
    h = h * 17 + Objects.hashCode(image512);
    h = h * 17 + Objects.hashCode(image1024);
    return h;
  }

  /**
   * Prints the immutable value {@code UserProfile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UserProfile{");
    if (username != null) {
      builder.append("username=").append(username);
    }
    if (usernameNormalized != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("usernameNormalized=").append(usernameNormalized);
    }
    if (realName != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("realName=").append(realName);
    }
    if (realNameNormalized != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("realNameNormalized=").append(realNameNormalized);
    }
    if (email != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("email=").append(email);
    }
    if (statusText != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("statusText=").append(statusText);
    }
    if (statusEmoji != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("statusEmoji=").append(statusEmoji);
    }
    if (title != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("title=").append(title);
    }
    if (phone != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("phone=").append(phone);
    }
    if (skype != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("skype=").append(skype);
    }
    if (fields != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("fields=").append(fields);
    }
    if (teamId != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("teamId=").append(teamId);
    }
    if (avatarHash != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("avatarHash=").append(avatarHash);
    }
    if (imageOriginal != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("imageOriginal=").append(imageOriginal);
    }
    if (image24 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image24=").append(image24);
    }
    if (image32 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image32=").append(image32);
    }
    if (image48 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image48=").append(image48);
    }
    if (image72 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image72=").append(image72);
    }
    if (image192 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image192=").append(image192);
    }
    if (image512 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image512=").append(image512);
    }
    if (image1024 != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("image1024=").append(image1024);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UserProfileIF {
    Optional<String> username = Optional.empty();
    Optional<String> usernameNormalized = Optional.empty();
    Optional<String> realName = Optional.empty();
    Optional<String> realNameNormalized = Optional.empty();
    Optional<String> email = Optional.empty();
    Optional<String> statusText = Optional.empty();
    Optional<String> statusEmoji = Optional.empty();
    Optional<String> title = Optional.empty();
    Optional<String> phone = Optional.empty();
    Optional<String> skype = Optional.empty();
    Optional<Map<String, ProfileField>> fields = Optional.empty();
    Optional<String> teamId = Optional.empty();
    Optional<String> avatarHash = Optional.empty();
    Optional<String> imageOriginal = Optional.empty();
    Optional<String> image24 = Optional.empty();
    Optional<String> image32 = Optional.empty();
    Optional<String> image48 = Optional.empty();
    Optional<String> image72 = Optional.empty();
    Optional<String> image192 = Optional.empty();
    Optional<String> image512 = Optional.empty();
    Optional<String> image1024 = Optional.empty();
    @JsonProperty("display_name")
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @JsonProperty("display_name_normalized")
    public void setUsernameNormalized(Optional<String> usernameNormalized) {
      this.usernameNormalized = usernameNormalized;
    }
    @JsonProperty
    public void setRealName(Optional<String> realName) {
      this.realName = realName;
    }
    @JsonProperty
    public void setRealNameNormalized(Optional<String> realNameNormalized) {
      this.realNameNormalized = realNameNormalized;
    }
    @JsonProperty
    public void setEmail(Optional<String> email) {
      this.email = email;
    }
    @JsonProperty
    public void setStatusText(Optional<String> statusText) {
      this.statusText = statusText;
    }
    @JsonProperty
    public void setStatusEmoji(Optional<String> statusEmoji) {
      this.statusEmoji = statusEmoji;
    }
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setPhone(Optional<String> phone) {
      this.phone = phone;
    }
    @JsonProperty
    public void setSkype(Optional<String> skype) {
      this.skype = skype;
    }
    @JsonProperty
    @JsonDeserialize(using = UserProfileFieldsDeserializer.class)
    public void setFields(Optional<Map<String, ProfileField>> fields) {
      this.fields = fields;
    }
    @JsonProperty("team")
    public void setTeamId(Optional<String> teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setAvatarHash(Optional<String> avatarHash) {
      this.avatarHash = avatarHash;
    }
    @JsonProperty
    public void setImageOriginal(Optional<String> imageOriginal) {
      this.imageOriginal = imageOriginal;
    }
    @JsonProperty("image_24")
    public void setImage24(Optional<String> image24) {
      this.image24 = image24;
    }
    @JsonProperty("image_32")
    public void setImage32(Optional<String> image32) {
      this.image32 = image32;
    }
    @JsonProperty("image_48")
    public void setImage48(Optional<String> image48) {
      this.image48 = image48;
    }
    @JsonProperty("image_72")
    public void setImage72(Optional<String> image72) {
      this.image72 = image72;
    }
    @JsonProperty("image_192")
    public void setImage192(Optional<String> image192) {
      this.image192 = image192;
    }
    @JsonProperty("image_512")
    public void setImage512(Optional<String> image512) {
      this.image512 = image512;
    }
    @JsonProperty("image_1024")
    public void setImage1024(Optional<String> image1024) {
      this.image1024 = image1024;
    }
    @Override
    public Optional<String> getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUsernameNormalized() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRealName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRealNameNormalized() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getStatusText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getStatusEmoji() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPhone() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSkype() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Map<String, ProfileField>> getFields() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getAvatarHash() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImageOriginal() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage24() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage32() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage48() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage72() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage192() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage512() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getImage1024() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UserProfile fromJson(Json json) {
    UserProfile.Builder builder = UserProfile.builder();
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.usernameNormalized != null) {
      builder.setUsernameNormalized(json.usernameNormalized);
    }
    if (json.realName != null) {
      builder.setRealName(json.realName);
    }
    if (json.realNameNormalized != null) {
      builder.setRealNameNormalized(json.realNameNormalized);
    }
    if (json.email != null) {
      builder.setEmail(json.email);
    }
    if (json.statusText != null) {
      builder.setStatusText(json.statusText);
    }
    if (json.statusEmoji != null) {
      builder.setStatusEmoji(json.statusEmoji);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.phone != null) {
      builder.setPhone(json.phone);
    }
    if (json.skype != null) {
      builder.setSkype(json.skype);
    }
    if (json.fields != null) {
      builder.setFields(json.fields);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.avatarHash != null) {
      builder.setAvatarHash(json.avatarHash);
    }
    if (json.imageOriginal != null) {
      builder.setImageOriginal(json.imageOriginal);
    }
    if (json.image24 != null) {
      builder.setImage24(json.image24);
    }
    if (json.image32 != null) {
      builder.setImage32(json.image32);
    }
    if (json.image48 != null) {
      builder.setImage48(json.image48);
    }
    if (json.image72 != null) {
      builder.setImage72(json.image72);
    }
    if (json.image192 != null) {
      builder.setImage192(json.image192);
    }
    if (json.image512 != null) {
      builder.setImage512(json.image512);
    }
    if (json.image1024 != null) {
      builder.setImage1024(json.image1024);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UserProfileIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserProfile instance
   */
  public static UserProfile copyOf(UserProfileIF instance) {
    if (instance instanceof UserProfile) {
      return (UserProfile) instance;
    }
    return UserProfile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UserProfile UserProfile}.
   * @return A new UserProfile builder
   */
  public static UserProfile.Builder builder() {
    return new UserProfile.Builder();
  }

  /**
   * Builds instances of type {@link UserProfile UserProfile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String username;
    private @Nullable String usernameNormalized;
    private @Nullable String realName;
    private @Nullable String realNameNormalized;
    private @Nullable String email;
    private @Nullable String statusText;
    private @Nullable String statusEmoji;
    private @Nullable String title;
    private @Nullable String phone;
    private @Nullable String skype;
    private @Nullable Map<String, ProfileField> fields;
    private @Nullable String teamId;
    private @Nullable String avatarHash;
    private @Nullable String imageOriginal;
    private @Nullable String image24;
    private @Nullable String image32;
    private @Nullable String image48;
    private @Nullable String image72;
    private @Nullable String image192;
    private @Nullable String image512;
    private @Nullable String image1024;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserProfileIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserProfileIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> usernameOptional = instance.getUsername();
      if (usernameOptional.isPresent()) {
        setUsername(usernameOptional);
      }
      Optional<String> usernameNormalizedOptional = instance.getUsernameNormalized();
      if (usernameNormalizedOptional.isPresent()) {
        setUsernameNormalized(usernameNormalizedOptional);
      }
      Optional<String> realNameOptional = instance.getRealName();
      if (realNameOptional.isPresent()) {
        setRealName(realNameOptional);
      }
      Optional<String> realNameNormalizedOptional = instance.getRealNameNormalized();
      if (realNameNormalizedOptional.isPresent()) {
        setRealNameNormalized(realNameNormalizedOptional);
      }
      Optional<String> emailOptional = instance.getEmail();
      if (emailOptional.isPresent()) {
        setEmail(emailOptional);
      }
      Optional<String> statusTextOptional = instance.getStatusText();
      if (statusTextOptional.isPresent()) {
        setStatusText(statusTextOptional);
      }
      Optional<String> statusEmojiOptional = instance.getStatusEmoji();
      if (statusEmojiOptional.isPresent()) {
        setStatusEmoji(statusEmojiOptional);
      }
      Optional<String> titleOptional = instance.getTitle();
      if (titleOptional.isPresent()) {
        setTitle(titleOptional);
      }
      Optional<String> phoneOptional = instance.getPhone();
      if (phoneOptional.isPresent()) {
        setPhone(phoneOptional);
      }
      Optional<String> skypeOptional = instance.getSkype();
      if (skypeOptional.isPresent()) {
        setSkype(skypeOptional);
      }
      Optional<Map<String, ProfileField>> fieldsOptional = instance.getFields();
      if (fieldsOptional.isPresent()) {
        setFields(fieldsOptional);
      }
      Optional<String> teamIdOptional = instance.getTeamId();
      if (teamIdOptional.isPresent()) {
        setTeamId(teamIdOptional);
      }
      Optional<String> avatarHashOptional = instance.getAvatarHash();
      if (avatarHashOptional.isPresent()) {
        setAvatarHash(avatarHashOptional);
      }
      Optional<String> imageOriginalOptional = instance.getImageOriginal();
      if (imageOriginalOptional.isPresent()) {
        setImageOriginal(imageOriginalOptional);
      }
      Optional<String> image24Optional = instance.getImage24();
      if (image24Optional.isPresent()) {
        setImage24(image24Optional);
      }
      Optional<String> image32Optional = instance.getImage32();
      if (image32Optional.isPresent()) {
        setImage32(image32Optional);
      }
      Optional<String> image48Optional = instance.getImage48();
      if (image48Optional.isPresent()) {
        setImage48(image48Optional);
      }
      Optional<String> image72Optional = instance.getImage72();
      if (image72Optional.isPresent()) {
        setImage72(image72Optional);
      }
      Optional<String> image192Optional = instance.getImage192();
      if (image192Optional.isPresent()) {
        setImage192(image192Optional);
      }
      Optional<String> image512Optional = instance.getImage512();
      if (image512Optional.isPresent()) {
        setImage512(image512Optional);
      }
      Optional<String> image1024Optional = instance.getImage1024();
      if (image1024Optional.isPresent()) {
        setImage1024(image1024Optional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getUsername() username} to username.
     * @param username The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsername(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getUsernameNormalized() usernameNormalized} to usernameNormalized.
     * @param usernameNormalized The value for usernameNormalized, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsernameNormalized(@Nullable String usernameNormalized) {
      this.usernameNormalized = usernameNormalized;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getUsernameNormalized() usernameNormalized} to usernameNormalized.
     * @param usernameNormalized The value for usernameNormalized
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsernameNormalized(Optional<String> usernameNormalized) {
      this.usernameNormalized = usernameNormalized.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getRealName() realName} to realName.
     * @param realName The value for realName, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRealName(@Nullable String realName) {
      this.realName = realName;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getRealName() realName} to realName.
     * @param realName The value for realName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRealName(Optional<String> realName) {
      this.realName = realName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getRealNameNormalized() realNameNormalized} to realNameNormalized.
     * @param realNameNormalized The value for realNameNormalized, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRealNameNormalized(@Nullable String realNameNormalized) {
      this.realNameNormalized = realNameNormalized;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getRealNameNormalized() realNameNormalized} to realNameNormalized.
     * @param realNameNormalized The value for realNameNormalized
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRealNameNormalized(Optional<String> realNameNormalized) {
      this.realNameNormalized = realNameNormalized.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getEmail() email} to email.
     * @param email The value for email, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEmail(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getEmail() email} to email.
     * @param email The value for email
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEmail(Optional<String> email) {
      this.email = email.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getStatusText() statusText} to statusText.
     * @param statusText The value for statusText, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStatusText(@Nullable String statusText) {
      this.statusText = statusText;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getStatusText() statusText} to statusText.
     * @param statusText The value for statusText
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStatusText(Optional<String> statusText) {
      this.statusText = statusText.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getStatusEmoji() statusEmoji} to statusEmoji.
     * @param statusEmoji The value for statusEmoji, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStatusEmoji(@Nullable String statusEmoji) {
      this.statusEmoji = statusEmoji;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getStatusEmoji() statusEmoji} to statusEmoji.
     * @param statusEmoji The value for statusEmoji
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStatusEmoji(Optional<String> statusEmoji) {
      this.statusEmoji = statusEmoji.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getTitle() title} to title.
     * @param title The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTitle(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getTitle() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getPhone() phone} to phone.
     * @param phone The value for phone, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPhone(@Nullable String phone) {
      this.phone = phone;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getPhone() phone} to phone.
     * @param phone The value for phone
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPhone(Optional<String> phone) {
      this.phone = phone.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getSkype() skype} to skype.
     * @param skype The value for skype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSkype(@Nullable String skype) {
      this.skype = skype;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getSkype() skype} to skype.
     * @param skype The value for skype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSkype(Optional<String> skype) {
      this.skype = skype.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getFields() fields} to fields.
     * @param fields The value for fields, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setFields(@Nullable Map<String, ProfileField> fields) {
      this.fields = fields;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getFields() fields} to fields.
     * @param fields The value for fields
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFields(Optional<Map<String, ProfileField>> fields) {
      this.fields = fields.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getTeamId() teamId} to teamId.
     * @param teamId The value for teamId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTeamId(@Nullable String teamId) {
      this.teamId = teamId;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getTeamId() teamId} to teamId.
     * @param teamId The value for teamId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamId(Optional<String> teamId) {
      this.teamId = teamId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getAvatarHash() avatarHash} to avatarHash.
     * @param avatarHash The value for avatarHash, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAvatarHash(@Nullable String avatarHash) {
      this.avatarHash = avatarHash;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getAvatarHash() avatarHash} to avatarHash.
     * @param avatarHash The value for avatarHash
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAvatarHash(Optional<String> avatarHash) {
      this.avatarHash = avatarHash.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImageOriginal() imageOriginal} to imageOriginal.
     * @param imageOriginal The value for imageOriginal, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImageOriginal(@Nullable String imageOriginal) {
      this.imageOriginal = imageOriginal;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImageOriginal() imageOriginal} to imageOriginal.
     * @param imageOriginal The value for imageOriginal
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImageOriginal(Optional<String> imageOriginal) {
      this.imageOriginal = imageOriginal.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage24() image24} to image24.
     * @param image24 The value for image24, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage24(@Nullable String image24) {
      this.image24 = image24;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage24() image24} to image24.
     * @param image24 The value for image24
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage24(Optional<String> image24) {
      this.image24 = image24.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage32() image32} to image32.
     * @param image32 The value for image32, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage32(@Nullable String image32) {
      this.image32 = image32;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage32() image32} to image32.
     * @param image32 The value for image32
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage32(Optional<String> image32) {
      this.image32 = image32.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage48() image48} to image48.
     * @param image48 The value for image48, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage48(@Nullable String image48) {
      this.image48 = image48;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage48() image48} to image48.
     * @param image48 The value for image48
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage48(Optional<String> image48) {
      this.image48 = image48.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage72() image72} to image72.
     * @param image72 The value for image72, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage72(@Nullable String image72) {
      this.image72 = image72;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage72() image72} to image72.
     * @param image72 The value for image72
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage72(Optional<String> image72) {
      this.image72 = image72.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage192() image192} to image192.
     * @param image192 The value for image192, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage192(@Nullable String image192) {
      this.image192 = image192;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage192() image192} to image192.
     * @param image192 The value for image192
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage192(Optional<String> image192) {
      this.image192 = image192.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage512() image512} to image512.
     * @param image512 The value for image512, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage512(@Nullable String image512) {
      this.image512 = image512;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage512() image512} to image512.
     * @param image512 The value for image512
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage512(Optional<String> image512) {
      this.image512 = image512.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage1024() image1024} to image1024.
     * @param image1024 The value for image1024, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImage1024(@Nullable String image1024) {
      this.image1024 = image1024;
      return this;
    }

    /**
     * Initializes the optional value {@link UserProfileIF#getImage1024() image1024} to image1024.
     * @param image1024 The value for image1024
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImage1024(Optional<String> image1024) {
      this.image1024 = image1024.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UserProfile UserProfile}.
     * @return An immutable instance of UserProfile
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UserProfile build() throws InvalidImmutableStateException {
      return new UserProfile(
          username,
          usernameNormalized,
          realName,
          realNameNormalized,
          email,
          statusText,
          statusEmoji,
          title,
          phone,
          skype,
          fields,
          teamId,
          avatarHash,
          imageOriginal,
          image24,
          image32,
          image48,
          image72,
          image192,
          image512,
          image1024);
    }
  }
}
