package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackUserIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackUser.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackUserIF"})
@Immutable
public final class SlackUser implements SlackUserIF {
  private final @Nullable UserProfile profile;
  private final @Nullable Boolean deleted;
  private final @Nullable String color;
  private final @Nullable String admin;
  private final @Nullable String owner;
  private final @Nullable String teamId;
  private final @Nullable String realName;
  private final @Nullable Boolean primaryOwner;
  private final @Nullable Boolean restricted;
  private final @Nullable Boolean ultraRestricted;
  private final @Nullable Boolean bot;
  private final @Nullable Boolean appUser;
  private final @Nullable String timezone;
  private final @Nullable String timezoneLabel;
  private final @Nullable String timezoneOffset;
  private final @Nullable Integer rawUpdated;
  private final @Nullable String locale;
  private final Optional<Long> updatedAt;
  private final String id;
  private final @Nullable String username;

  private SlackUser(
      @Nullable UserProfile profile,
      @Nullable Boolean deleted,
      @Nullable String color,
      @Nullable String admin,
      @Nullable String owner,
      @Nullable String teamId,
      @Nullable String realName,
      @Nullable Boolean primaryOwner,
      @Nullable Boolean restricted,
      @Nullable Boolean ultraRestricted,
      @Nullable Boolean bot,
      @Nullable Boolean appUser,
      @Nullable String timezone,
      @Nullable String timezoneLabel,
      @Nullable String timezoneOffset,
      @Nullable Integer rawUpdated,
      @Nullable String locale,
      String id,
      @Nullable String username) {
    this.profile = profile;
    this.deleted = deleted;
    this.color = color;
    this.admin = admin;
    this.owner = owner;
    this.teamId = teamId;
    this.realName = realName;
    this.primaryOwner = primaryOwner;
    this.restricted = restricted;
    this.ultraRestricted = ultraRestricted;
    this.bot = bot;
    this.appUser = appUser;
    this.timezone = timezone;
    this.timezoneLabel = timezoneLabel;
    this.timezoneOffset = timezoneOffset;
    this.rawUpdated = rawUpdated;
    this.locale = locale;
    this.id = id;
    this.username = username;
    this.updatedAt = Objects.requireNonNull(SlackUserIF.super.getUpdatedAt(), "updatedAt");
  }

  /**
   * @return The value of the {@code profile} attribute
   */
  @JsonProperty
  @Override
  public Optional<UserProfile> getProfile() {
    return Optional.ofNullable(profile);
  }

  /**
   * @return The value of the {@code deleted} attribute
   */
  @JsonProperty("deleted")
  @Override
  public Optional<Boolean> isDeleted() {
    return Optional.ofNullable(deleted);
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getColor() {
    return Optional.ofNullable(color);
  }

  /**
   * @return The value of the {@code admin} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> isAdmin() {
    return Optional.ofNullable(admin);
  }

  /**
   * @return The value of the {@code owner} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> isOwner() {
    return Optional.ofNullable(owner);
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTeamId() {
    return Optional.ofNullable(teamId);
  }

  /**
   * @return The value of the {@code realName} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getRealName() {
    return Optional.ofNullable(realName);
  }

  /**
   * @return The value of the {@code primaryOwner} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isPrimaryOwner() {
    return Optional.ofNullable(primaryOwner);
  }

  /**
   * @return The value of the {@code restricted} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isRestricted() {
    return Optional.ofNullable(restricted);
  }

  /**
   * @return The value of the {@code ultraRestricted} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isUltraRestricted() {
    return Optional.ofNullable(ultraRestricted);
  }

  /**
   * @return The value of the {@code bot} attribute
   */
  @JsonProperty("is_bot")
  @Override
  public Optional<Boolean> isBot() {
    return Optional.ofNullable(bot);
  }

  /**
   * @return The value of the {@code appUser} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isAppUser() {
    return Optional.ofNullable(appUser);
  }

  /**
   * @return The value of the {@code timezone} attribute
   */
  @JsonProperty("tz")
  @Override
  public Optional<String> getTimezone() {
    return Optional.ofNullable(timezone);
  }

  /**
   * @return The value of the {@code timezoneLabel} attribute
   */
  @JsonProperty("tz_label")
  @Override
  public Optional<String> getTimezoneLabel() {
    return Optional.ofNullable(timezoneLabel);
  }

  /**
   * @return The value of the {@code timezoneOffset} attribute
   */
  @JsonProperty("tz_offset")
  @Override
  public Optional<String> getTimezoneOffset() {
    return Optional.ofNullable(timezoneOffset);
  }

  /**
   * @return The value of the {@code rawUpdated} attribute
   */
  @JsonProperty("updated")
  @Override
  public Optional<Integer> getRawUpdated() {
    return Optional.ofNullable(rawUpdated);
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getLocale() {
    return Optional.ofNullable(locale);
  }

  /**
   * @return The computed-at-construction value of the {@code updatedAt} attribute
   */
  @JsonProperty
  @Override
  public Optional<Long> getUpdatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty("name")
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getProfile() profile} attribute.
   * @param value The value for profile, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withProfile(@Nullable UserProfile value) {
    @Nullable UserProfile newValue = value;
    if (this.profile == newValue) return this;
    return new SlackUser(
        newValue,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getProfile() profile} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for profile
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withProfile(Optional<UserProfile> optional) {
    @Nullable UserProfile value = optional.orElse(null);
    if (this.profile == value) return this;
    return new SlackUser(
        value,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isDeleted() deleted} attribute.
   * @param value The value for deleted, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withDeleted(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.deleted, newValue)) return this;
    return new SlackUser(
        this.profile,
        newValue,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isDeleted() deleted} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deleted
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withDeleted(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.deleted, value)) return this;
    return new SlackUser(
        this.profile,
        value,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getColor() color} attribute.
   * @param value The value for color, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withColor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.color, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        newValue,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getColor() color} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for color
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withColor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.color, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        value,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isAdmin() admin} attribute.
   * @param value The value for admin, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withAdmin(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.admin, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        newValue,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isAdmin() admin} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for admin
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withAdmin(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.admin, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        value,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isOwner() owner} attribute.
   * @param value The value for owner, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withOwner(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.owner, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        newValue,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isOwner() owner} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for owner
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withOwner(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.owner, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        value,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getTeamId() teamId} attribute.
   * @param value The value for teamId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTeamId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.teamId, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        newValue,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getTeamId() teamId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for teamId
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTeamId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.teamId, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        value,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getRealName() realName} attribute.
   * @param value The value for realName, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRealName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.realName, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        newValue,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getRealName() realName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for realName
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRealName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.realName, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        value,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isPrimaryOwner() primaryOwner} attribute.
   * @param value The value for primaryOwner, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withPrimaryOwner(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.primaryOwner, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        newValue,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isPrimaryOwner() primaryOwner} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for primaryOwner
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withPrimaryOwner(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.primaryOwner, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        value,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isRestricted() restricted} attribute.
   * @param value The value for restricted, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRestricted(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.restricted, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        newValue,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isRestricted() restricted} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for restricted
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRestricted(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.restricted, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        value,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isUltraRestricted() ultraRestricted} attribute.
   * @param value The value for ultraRestricted, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withUltraRestricted(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.ultraRestricted, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        newValue,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isUltraRestricted() ultraRestricted} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ultraRestricted
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withUltraRestricted(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.ultraRestricted, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        value,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isBot() bot} attribute.
   * @param value The value for bot, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withBot(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.bot, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        newValue,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isBot() bot} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bot
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withBot(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.bot, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        value,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#isAppUser() appUser} attribute.
   * @param value The value for appUser, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withAppUser(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.appUser, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        newValue,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#isAppUser() appUser} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for appUser
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withAppUser(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.appUser, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        value,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getTimezone() timezone} attribute.
   * @param value The value for timezone, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezone(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.timezone, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        newValue,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getTimezone() timezone} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timezone
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezone(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.timezone, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        value,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getTimezoneLabel() timezoneLabel} attribute.
   * @param value The value for timezoneLabel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezoneLabel(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.timezoneLabel, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        newValue,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getTimezoneLabel() timezoneLabel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timezoneLabel
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezoneLabel(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.timezoneLabel, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        value,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getTimezoneOffset() timezoneOffset} attribute.
   * @param value The value for timezoneOffset, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezoneOffset(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.timezoneOffset, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        newValue,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getTimezoneOffset() timezoneOffset} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timezoneOffset
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withTimezoneOffset(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.timezoneOffset, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        value,
        this.rawUpdated,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getRawUpdated() rawUpdated} attribute.
   * @param value The value for rawUpdated, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRawUpdated(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.rawUpdated, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        newValue,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getRawUpdated() rawUpdated} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rawUpdated
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withRawUpdated(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.rawUpdated, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        value,
        this.locale,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getLocale() locale} attribute.
   * @param value The value for locale, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withLocale(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.locale, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        newValue,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getLocale() locale} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for locale
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withLocale(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.locale, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        value,
        this.id,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUserIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackUser withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        newValue,
        this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserIF#getUsername() username} attribute.
   * @param value The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withUsername(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.username, newValue)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserIF#getUsername() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final SlackUser withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return new SlackUser(
        this.profile,
        this.deleted,
        this.color,
        this.admin,
        this.owner,
        this.teamId,
        this.realName,
        this.primaryOwner,
        this.restricted,
        this.ultraRestricted,
        this.bot,
        this.appUser,
        this.timezone,
        this.timezoneLabel,
        this.timezoneOffset,
        this.rawUpdated,
        this.locale,
        this.id,
        value);
  }

  /**
   * This instance is equal to all instances of {@code SlackUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackUser
        && equalTo((SlackUser) another);
  }

  private boolean equalTo(SlackUser another) {
    return Objects.equals(profile, another.profile)
        && Objects.equals(deleted, another.deleted)
        && Objects.equals(color, another.color)
        && Objects.equals(admin, another.admin)
        && Objects.equals(owner, another.owner)
        && Objects.equals(teamId, another.teamId)
        && Objects.equals(realName, another.realName)
        && Objects.equals(primaryOwner, another.primaryOwner)
        && Objects.equals(restricted, another.restricted)
        && Objects.equals(ultraRestricted, another.ultraRestricted)
        && Objects.equals(bot, another.bot)
        && Objects.equals(appUser, another.appUser)
        && Objects.equals(timezone, another.timezone)
        && Objects.equals(timezoneLabel, another.timezoneLabel)
        && Objects.equals(timezoneOffset, another.timezoneOffset)
        && Objects.equals(rawUpdated, another.rawUpdated)
        && Objects.equals(locale, another.locale)
        && updatedAt.equals(another.updatedAt)
        && id.equals(another.id)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code profile}, {@code deleted}, {@code color}, {@code admin}, {@code owner}, {@code teamId}, {@code realName}, {@code primaryOwner}, {@code restricted}, {@code ultraRestricted}, {@code bot}, {@code appUser}, {@code timezone}, {@code timezoneLabel}, {@code timezoneOffset}, {@code rawUpdated}, {@code locale}, {@code updatedAt}, {@code id}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(profile);
    h = h * 17 + Objects.hashCode(deleted);
    h = h * 17 + Objects.hashCode(color);
    h = h * 17 + Objects.hashCode(admin);
    h = h * 17 + Objects.hashCode(owner);
    h = h * 17 + Objects.hashCode(teamId);
    h = h * 17 + Objects.hashCode(realName);
    h = h * 17 + Objects.hashCode(primaryOwner);
    h = h * 17 + Objects.hashCode(restricted);
    h = h * 17 + Objects.hashCode(ultraRestricted);
    h = h * 17 + Objects.hashCode(bot);
    h = h * 17 + Objects.hashCode(appUser);
    h = h * 17 + Objects.hashCode(timezone);
    h = h * 17 + Objects.hashCode(timezoneLabel);
    h = h * 17 + Objects.hashCode(timezoneOffset);
    h = h * 17 + Objects.hashCode(rawUpdated);
    h = h * 17 + Objects.hashCode(locale);
    h = h * 17 + updatedAt.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackUser{");
    if (profile != null) {
      builder.append("profile=").append(profile);
    }
    if (deleted != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("deleted=").append(deleted);
    }
    if (color != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("color=").append(color);
    }
    if (admin != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("admin=").append(admin);
    }
    if (owner != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("owner=").append(owner);
    }
    if (teamId != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("teamId=").append(teamId);
    }
    if (realName != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("realName=").append(realName);
    }
    if (primaryOwner != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("primaryOwner=").append(primaryOwner);
    }
    if (restricted != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("restricted=").append(restricted);
    }
    if (ultraRestricted != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("ultraRestricted=").append(ultraRestricted);
    }
    if (bot != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("bot=").append(bot);
    }
    if (appUser != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("appUser=").append(appUser);
    }
    if (timezone != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("timezone=").append(timezone);
    }
    if (timezoneLabel != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("timezoneLabel=").append(timezoneLabel);
    }
    if (timezoneOffset != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("timezoneOffset=").append(timezoneOffset);
    }
    if (rawUpdated != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("rawUpdated=").append(rawUpdated);
    }
    if (locale != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("locale=").append(locale);
    }
    if (builder.length() > 10) builder.append(", ");
    builder.append("updatedAt=").append(updatedAt);
    builder.append(", ");
    builder.append("id=").append(id);
    if (username != null) {
      builder.append(", ");
      builder.append("username=").append(username);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackUserIF {
    Optional<UserProfile> profile = Optional.empty();
    Optional<Boolean> deleted = Optional.empty();
    Optional<String> color = Optional.empty();
    Optional<String> admin = Optional.empty();
    Optional<String> owner = Optional.empty();
    Optional<String> teamId = Optional.empty();
    Optional<String> realName = Optional.empty();
    Optional<Boolean> primaryOwner = Optional.empty();
    Optional<Boolean> restricted = Optional.empty();
    Optional<Boolean> ultraRestricted = Optional.empty();
    Optional<Boolean> bot = Optional.empty();
    Optional<Boolean> appUser = Optional.empty();
    Optional<String> timezone = Optional.empty();
    Optional<String> timezoneLabel = Optional.empty();
    Optional<String> timezoneOffset = Optional.empty();
    Optional<Integer> rawUpdated = Optional.empty();
    Optional<String> locale = Optional.empty();
    @Nullable String id;
    Optional<String> username = Optional.empty();
    @JsonProperty
    public void setProfile(Optional<UserProfile> profile) {
      this.profile = profile;
    }
    @JsonProperty("deleted")
    public void setDeleted(Optional<Boolean> deleted) {
      this.deleted = deleted;
    }
    @JsonProperty
    public void setColor(Optional<String> color) {
      this.color = color;
    }
    @JsonProperty
    public void setAdmin(Optional<String> admin) {
      this.admin = admin;
    }
    @JsonProperty
    public void setOwner(Optional<String> owner) {
      this.owner = owner;
    }
    @JsonProperty
    public void setTeamId(Optional<String> teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setRealName(Optional<String> realName) {
      this.realName = realName;
    }
    @JsonProperty
    public void setPrimaryOwner(Optional<Boolean> primaryOwner) {
      this.primaryOwner = primaryOwner;
    }
    @JsonProperty
    public void setRestricted(Optional<Boolean> restricted) {
      this.restricted = restricted;
    }
    @JsonProperty
    public void setUltraRestricted(Optional<Boolean> ultraRestricted) {
      this.ultraRestricted = ultraRestricted;
    }
    @JsonProperty("is_bot")
    public void setBot(Optional<Boolean> bot) {
      this.bot = bot;
    }
    @JsonProperty
    public void setAppUser(Optional<Boolean> appUser) {
      this.appUser = appUser;
    }
    @JsonProperty("tz")
    public void setTimezone(Optional<String> timezone) {
      this.timezone = timezone;
    }
    @JsonProperty("tz_label")
    public void setTimezoneLabel(Optional<String> timezoneLabel) {
      this.timezoneLabel = timezoneLabel;
    }
    @JsonProperty("tz_offset")
    public void setTimezoneOffset(Optional<String> timezoneOffset) {
      this.timezoneOffset = timezoneOffset;
    }
    @JsonProperty("updated")
    public void setRawUpdated(Optional<Integer> rawUpdated) {
      this.rawUpdated = rawUpdated;
    }
    @JsonProperty
    public void setLocale(Optional<String> locale) {
      this.locale = locale;
    }
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @Override
    public Optional<UserProfile> getProfile() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isDeleted() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getColor() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> isAdmin() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> isOwner() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRealName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isPrimaryOwner() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isRestricted() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isUltraRestricted() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isBot() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isAppUser() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTimezone() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTimezoneLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTimezoneOffset() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getRawUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Long> getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackUser fromJson(Json json) {
    SlackUser.Builder builder = SlackUser.builder();
    if (json.profile != null) {
      builder.setProfile(json.profile);
    }
    if (json.deleted != null) {
      builder.setDeleted(json.deleted);
    }
    if (json.color != null) {
      builder.setColor(json.color);
    }
    if (json.admin != null) {
      builder.setAdmin(json.admin);
    }
    if (json.owner != null) {
      builder.setOwner(json.owner);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.realName != null) {
      builder.setRealName(json.realName);
    }
    if (json.primaryOwner != null) {
      builder.setPrimaryOwner(json.primaryOwner);
    }
    if (json.restricted != null) {
      builder.setRestricted(json.restricted);
    }
    if (json.ultraRestricted != null) {
      builder.setUltraRestricted(json.ultraRestricted);
    }
    if (json.bot != null) {
      builder.setBot(json.bot);
    }
    if (json.appUser != null) {
      builder.setAppUser(json.appUser);
    }
    if (json.timezone != null) {
      builder.setTimezone(json.timezone);
    }
    if (json.timezoneLabel != null) {
      builder.setTimezoneLabel(json.timezoneLabel);
    }
    if (json.timezoneOffset != null) {
      builder.setTimezoneOffset(json.timezoneOffset);
    }
    if (json.rawUpdated != null) {
      builder.setRawUpdated(json.rawUpdated);
    }
    if (json.locale != null) {
      builder.setLocale(json.locale);
    }
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackUserIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackUser instance
   */
  public static SlackUser copyOf(SlackUserIF instance) {
    if (instance instanceof SlackUser) {
      return (SlackUser) instance;
    }
    return SlackUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackUser SlackUser}.
   * @return A new SlackUser builder
   */
  public static SlackUser.Builder builder() {
    return new SlackUser.Builder();
  }

  /**
   * Builds instances of type {@link SlackUser SlackUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable UserProfile profile;
    private @Nullable Boolean deleted;
    private @Nullable String color;
    private @Nullable String admin;
    private @Nullable String owner;
    private @Nullable String teamId;
    private @Nullable String realName;
    private @Nullable Boolean primaryOwner;
    private @Nullable Boolean restricted;
    private @Nullable Boolean ultraRestricted;
    private @Nullable Boolean bot;
    private @Nullable Boolean appUser;
    private @Nullable String timezone;
    private @Nullable String timezoneLabel;
    private @Nullable String timezoneOffset;
    private @Nullable Integer rawUpdated;
    private @Nullable String locale;
    private @Nullable String id;
    private @Nullable String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.users.SlackUserCore} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUserCore instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.users.SlackUserIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUserIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackUserCore) {
        SlackUserCore instance = (SlackUserCore) object;
        setId(instance.getId());
        Optional<String> usernameOptional = instance.getUsername();
        if (usernameOptional.isPresent()) {
          setUsername(usernameOptional);
        }
      }
      if (object instanceof SlackUserIF) {
        SlackUserIF instance = (SlackUserIF) object;
        Optional<String> ownerOptional = instance.isOwner();
        if (ownerOptional.isPresent()) {
          setOwner(ownerOptional);
        }
        Optional<Boolean> appUserOptional = instance.isAppUser();
        if (appUserOptional.isPresent()) {
          setAppUser(appUserOptional);
        }
        Optional<String> timezoneLabelOptional = instance.getTimezoneLabel();
        if (timezoneLabelOptional.isPresent()) {
          setTimezoneLabel(timezoneLabelOptional);
        }
        Optional<String> colorOptional = instance.getColor();
        if (colorOptional.isPresent()) {
          setColor(colorOptional);
        }
        Optional<Boolean> botOptional = instance.isBot();
        if (botOptional.isPresent()) {
          setBot(botOptional);
        }
        Optional<String> timezoneOptional = instance.getTimezone();
        if (timezoneOptional.isPresent()) {
          setTimezone(timezoneOptional);
        }
        Optional<UserProfile> profileOptional = instance.getProfile();
        if (profileOptional.isPresent()) {
          setProfile(profileOptional);
        }
        Optional<Boolean> primaryOwnerOptional = instance.isPrimaryOwner();
        if (primaryOwnerOptional.isPresent()) {
          setPrimaryOwner(primaryOwnerOptional);
        }
        Optional<String> adminOptional = instance.isAdmin();
        if (adminOptional.isPresent()) {
          setAdmin(adminOptional);
        }
        Optional<String> localeOptional = instance.getLocale();
        if (localeOptional.isPresent()) {
          setLocale(localeOptional);
        }
        Optional<String> realNameOptional = instance.getRealName();
        if (realNameOptional.isPresent()) {
          setRealName(realNameOptional);
        }
        Optional<Boolean> deletedOptional = instance.isDeleted();
        if (deletedOptional.isPresent()) {
          setDeleted(deletedOptional);
        }
        Optional<String> timezoneOffsetOptional = instance.getTimezoneOffset();
        if (timezoneOffsetOptional.isPresent()) {
          setTimezoneOffset(timezoneOffsetOptional);
        }
        Optional<Boolean> restrictedOptional = instance.isRestricted();
        if (restrictedOptional.isPresent()) {
          setRestricted(restrictedOptional);
        }
        Optional<String> teamIdOptional = instance.getTeamId();
        if (teamIdOptional.isPresent()) {
          setTeamId(teamIdOptional);
        }
        Optional<Boolean> ultraRestrictedOptional = instance.isUltraRestricted();
        if (ultraRestrictedOptional.isPresent()) {
          setUltraRestricted(ultraRestrictedOptional);
        }
        Optional<Integer> rawUpdatedOptional = instance.getRawUpdated();
        if (rawUpdatedOptional.isPresent()) {
          setRawUpdated(rawUpdatedOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getProfile() profile} to profile.
     * @param profile The value for profile, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setProfile(@Nullable UserProfile profile) {
      this.profile = profile;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getProfile() profile} to profile.
     * @param profile The value for profile
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setProfile(Optional<UserProfile> profile) {
      this.profile = profile.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isDeleted() deleted} to deleted.
     * @param deleted The value for deleted, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setDeleted(@Nullable Boolean deleted) {
      this.deleted = deleted;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isDeleted() deleted} to deleted.
     * @param deleted The value for deleted
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDeleted(Optional<Boolean> deleted) {
      this.deleted = deleted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getColor() color} to color.
     * @param color The value for color, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setColor(@Nullable String color) {
      this.color = color;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getColor() color} to color.
     * @param color The value for color
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setColor(Optional<String> color) {
      this.color = color.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isAdmin() admin} to admin.
     * @param admin The value for admin, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAdmin(@Nullable String admin) {
      this.admin = admin;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isAdmin() admin} to admin.
     * @param admin The value for admin
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAdmin(Optional<String> admin) {
      this.admin = admin.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isOwner() owner} to owner.
     * @param owner The value for owner, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOwner(@Nullable String owner) {
      this.owner = owner;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isOwner() owner} to owner.
     * @param owner The value for owner
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOwner(Optional<String> owner) {
      this.owner = owner.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTeamId() teamId} to teamId.
     * @param teamId The value for teamId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTeamId(@Nullable String teamId) {
      this.teamId = teamId;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTeamId() teamId} to teamId.
     * @param teamId The value for teamId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamId(Optional<String> teamId) {
      this.teamId = teamId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getRealName() realName} to realName.
     * @param realName The value for realName, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRealName(@Nullable String realName) {
      this.realName = realName;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getRealName() realName} to realName.
     * @param realName The value for realName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRealName(Optional<String> realName) {
      this.realName = realName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isPrimaryOwner() primaryOwner} to primaryOwner.
     * @param primaryOwner The value for primaryOwner, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPrimaryOwner(@Nullable Boolean primaryOwner) {
      this.primaryOwner = primaryOwner;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isPrimaryOwner() primaryOwner} to primaryOwner.
     * @param primaryOwner The value for primaryOwner
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrimaryOwner(Optional<Boolean> primaryOwner) {
      this.primaryOwner = primaryOwner.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isRestricted() restricted} to restricted.
     * @param restricted The value for restricted, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRestricted(@Nullable Boolean restricted) {
      this.restricted = restricted;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isRestricted() restricted} to restricted.
     * @param restricted The value for restricted
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRestricted(Optional<Boolean> restricted) {
      this.restricted = restricted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isUltraRestricted() ultraRestricted} to ultraRestricted.
     * @param ultraRestricted The value for ultraRestricted, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUltraRestricted(@Nullable Boolean ultraRestricted) {
      this.ultraRestricted = ultraRestricted;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isUltraRestricted() ultraRestricted} to ultraRestricted.
     * @param ultraRestricted The value for ultraRestricted
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUltraRestricted(Optional<Boolean> ultraRestricted) {
      this.ultraRestricted = ultraRestricted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isBot() bot} to bot.
     * @param bot The value for bot, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBot(@Nullable Boolean bot) {
      this.bot = bot;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isBot() bot} to bot.
     * @param bot The value for bot
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBot(Optional<Boolean> bot) {
      this.bot = bot.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isAppUser() appUser} to appUser.
     * @param appUser The value for appUser, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAppUser(@Nullable Boolean appUser) {
      this.appUser = appUser;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#isAppUser() appUser} to appUser.
     * @param appUser The value for appUser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAppUser(Optional<Boolean> appUser) {
      this.appUser = appUser.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezone() timezone} to timezone.
     * @param timezone The value for timezone, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTimezone(@Nullable String timezone) {
      this.timezone = timezone;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezone() timezone} to timezone.
     * @param timezone The value for timezone
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimezone(Optional<String> timezone) {
      this.timezone = timezone.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezoneLabel() timezoneLabel} to timezoneLabel.
     * @param timezoneLabel The value for timezoneLabel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTimezoneLabel(@Nullable String timezoneLabel) {
      this.timezoneLabel = timezoneLabel;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezoneLabel() timezoneLabel} to timezoneLabel.
     * @param timezoneLabel The value for timezoneLabel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimezoneLabel(Optional<String> timezoneLabel) {
      this.timezoneLabel = timezoneLabel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezoneOffset() timezoneOffset} to timezoneOffset.
     * @param timezoneOffset The value for timezoneOffset, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTimezoneOffset(@Nullable String timezoneOffset) {
      this.timezoneOffset = timezoneOffset;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getTimezoneOffset() timezoneOffset} to timezoneOffset.
     * @param timezoneOffset The value for timezoneOffset
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimezoneOffset(Optional<String> timezoneOffset) {
      this.timezoneOffset = timezoneOffset.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getRawUpdated() rawUpdated} to rawUpdated.
     * @param rawUpdated The value for rawUpdated, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRawUpdated(@Nullable Integer rawUpdated) {
      this.rawUpdated = rawUpdated;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getRawUpdated() rawUpdated} to rawUpdated.
     * @param rawUpdated The value for rawUpdated
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRawUpdated(Optional<Integer> rawUpdated) {
      this.rawUpdated = rawUpdated.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getLocale() locale} to locale.
     * @param locale The value for locale, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLocale(@Nullable String locale) {
      this.locale = locale;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getLocale() locale} to locale.
     * @param locale The value for locale
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLocale(Optional<String> locale) {
      this.locale = locale.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUserIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getUsername() username} to username.
     * @param username The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsername(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserIF#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackUser SlackUser}.
     * @return An immutable instance of SlackUser
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackUser build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackUser(
          profile,
          deleted,
          color,
          admin,
          owner,
          teamId,
          realName,
          primaryOwner,
          restricted,
          ultraRestricted,
          bot,
          appUser,
          timezone,
          timezoneLabel,
          timezoneOffset,
          rawUpdated,
          locale,
          id,
          username);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      return "Cannot build SlackUser, some of required attributes are not set " + attributes;
    }
  }
}
