package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ProfileFieldIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ProfileField.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ProfileFieldIF"})
@Immutable
public final class ProfileField implements ProfileFieldIF {
  private final String value;
  private final @Nullable String alt;

  private ProfileField(String value, @Nullable String alt) {
    this.value = value;
    this.alt = alt;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code alt} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getAlt() {
    return Optional.ofNullable(alt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProfileFieldIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ProfileField withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new ProfileField(newValue, this.alt);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ProfileFieldIF#getAlt() alt} attribute.
   * @param value The value for alt, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ProfileField withAlt(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.alt, newValue)) return this;
    return new ProfileField(this.value, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ProfileFieldIF#getAlt() alt} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for alt
   * @return A modified copy of {@code this} object
   */
  public final ProfileField withAlt(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.alt, value)) return this;
    return new ProfileField(this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ProfileField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ProfileField
        && equalTo((ProfileField) another);
  }

  private boolean equalTo(ProfileField another) {
    return value.equals(another.value)
        && Objects.equals(alt, another.alt);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code alt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + value.hashCode();
    h = h * 17 + Objects.hashCode(alt);
    return h;
  }

  /**
   * Prints the immutable value {@code ProfileField} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ProfileField{");
    builder.append("value=").append(value);
    if (alt != null) {
      builder.append(", ");
      builder.append("alt=").append(alt);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ProfileFieldIF {
    @Nullable String value;
    Optional<String> alt = Optional.empty();
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty
    public void setAlt(Optional<String> alt) {
      this.alt = alt;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getAlt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ProfileField fromJson(Json json) {
    ProfileField.Builder builder = ProfileField.builder();
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.alt != null) {
      builder.setAlt(json.alt);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ProfileFieldIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProfileField instance
   */
  public static ProfileField copyOf(ProfileFieldIF instance) {
    if (instance instanceof ProfileField) {
      return (ProfileField) instance;
    }
    return ProfileField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ProfileField ProfileField}.
   * @return A new ProfileField builder
   */
  public static ProfileField.Builder builder() {
    return new ProfileField.Builder();
  }

  /**
   * Builds instances of type {@link ProfileField ProfileField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;
    private @Nullable String alt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProfileFieldIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProfileFieldIF instance) {
      Objects.requireNonNull(instance, "instance");
      setValue(instance.getValue());
      Optional<String> altOptional = instance.getAlt();
      if (altOptional.isPresent()) {
        setAlt(altOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProfileFieldIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the optional value {@link ProfileFieldIF#getAlt() alt} to alt.
     * @param alt The value for alt, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAlt(@Nullable String alt) {
      this.alt = alt;
      return this;
    }

    /**
     * Initializes the optional value {@link ProfileFieldIF#getAlt() alt} to alt.
     * @param alt The value for alt
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAlt(Optional<String> alt) {
      this.alt = alt.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ProfileField ProfileField}.
     * @return An immutable instance of ProfileField
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ProfileField build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ProfileField(value, alt);
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build ProfileField, some of required attributes are not set " + attributes;
    }
  }
}
