package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StateBlockIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StateBlock.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StateBlockIF"})
@Immutable
public final class StateBlock implements StateBlockIF {
  private final Map<String, StateAction> actions;

  private StateBlock(Map<String, StateAction> actions) {
    this.actions = actions;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @JsonProperty
  @JsonAnyGetter
  @Override
  public Map<String, StateAction> getActions() {
    return actions;
  }

  /**
   * Copy the current immutable object by replacing the {@link StateBlockIF#getActions() actions} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param actions The entries to be added to the actions map
   * @return A modified copy of {@code this} object
   */
  public final StateBlock withActions(Map<String, ? extends StateAction> actions) {
    if (this.actions == actions) return this;
    Map<String, StateAction> newValue = createUnmodifiableMap(true, false, actions);
    return new StateBlock(newValue);
  }

  /**
   * This instance is equal to all instances of {@code StateBlock} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof StateBlock
        && equalTo((StateBlock) another);
  }

  private boolean equalTo(StateBlock another) {
    return actions.equals(another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + actions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateBlock} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateBlock{"
        + "actions=" + actions
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StateBlockIF {
    final Map<String, StateAction> actions = new HashMap<String, StateAction>();

    @JsonAnySetter
    public void setActions(String key, StateAction value) {
      this.actions.put(key, value);
    }
    @Override
    public Map<String, StateAction> getActions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StateBlock fromJson(Json json) {
    StateBlock.Builder builder = StateBlock.builder();
    if (json.actions != null) {
      builder.putAllActions(json.actions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StateBlockIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StateBlock instance
   */
  public static StateBlock copyOf(StateBlockIF instance) {
    if (instance instanceof StateBlock) {
      return (StateBlock) instance;
    }
    return StateBlock.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link StateBlock StateBlock}.
   * @return A new StateBlock builder
   */
  public static StateBlock.Builder builder() {
    return new StateBlock.Builder();
  }

  /**
   * Builds instances of type {@link StateBlock StateBlock}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Map<String, StateAction> actions = new LinkedHashMap<String, StateAction>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateBlockIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StateBlockIF instance) {
      Objects.requireNonNull(instance, "instance");
      putAllActions(instance.getActions());
      return this;
    }

    /**
     * Put one entry to the {@link StateBlockIF#getActions() actions} map.
     * @param key The key in the actions map
     * @param value The associated value in the actions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putActions(String key, StateAction value) {
      this.actions.put(
          Objects.requireNonNull(key, "actions key"),
          Objects.requireNonNull(value, "actions value"));
      return this;
    }

    /**
     * Put one entry to the {@link StateBlockIF#getActions() actions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putActions(Map.Entry<String, ? extends StateAction> entry) {
      String k = entry.getKey();
      StateAction v = entry.getValue();
      this.actions.put(
          Objects.requireNonNull(k, "actions key"),
          Objects.requireNonNull(v, "actions value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link StateBlockIF#getActions() actions} map. Nulls are not permitted
     * @param actions The entries that will be added to the actions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActions(Map<String, ? extends StateAction> actions) {
      this.actions.clear();
      return putAllActions(actions);
    }

    /**
     * Put all mappings from the specified map as entries to {@link StateBlockIF#getActions() actions} map. Nulls are not permitted
     * @param actions The entries that will be added to the actions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllActions(Map<String, ? extends StateAction> actions) {
      for (Map.Entry<String, ? extends StateAction> entry : actions.entrySet()) {
        String k = entry.getKey();
        StateAction v = entry.getValue();
        this.actions.put(
            Objects.requireNonNull(k, "actions key"),
            Objects.requireNonNull(v, "actions value"));
      }
      return this;
    }

    /**
     * Builds a new {@link StateBlock StateBlock}.
     * @return An immutable instance of StateBlock
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public StateBlock build() throws InvalidImmutableStateException {
      return new StateBlock(createUnmodifiableMap(false, false, actions));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
