package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StateActionValueIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StateActionValue.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StateActionValueIF"})
@Immutable
public final class StateActionValue
    implements StateActionValueIF {
  private final String blockElementType;
  private final @Nullable Object blockElementValue;

  private StateActionValue(String blockElementType, @Nullable Object blockElementValue) {
    this.blockElementType = blockElementType;
    this.blockElementValue = blockElementValue;
  }

  /**
   * @return The value of the {@code blockElementType} attribute
   */
  @JsonProperty
  @Override
  public String getBlockElementType() {
    return blockElementType;
  }

  /**
   * @return The value of the {@code blockElementValue} attribute
   */
  @JsonProperty
  @Override
  public Optional<Object> getBlockElementValue() {
    return Optional.ofNullable(blockElementValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StateActionValueIF#getBlockElementType() blockElementType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param blockElementType A new value for blockElementType
   * @return A modified copy of the {@code this} object
   */
  public final StateActionValue withBlockElementType(String blockElementType) {
    if (this.blockElementType.equals(blockElementType)) return this;
    String newValue = Objects.requireNonNull(blockElementType, "blockElementType");
    return new StateActionValue(newValue, this.blockElementValue);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link StateActionValueIF#getBlockElementValue() blockElementValue} attribute.
   * @param value The value for blockElementValue, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final StateActionValue withBlockElementValue(@Nullable Object value) {
    @Nullable Object newValue = value;
    if (this.blockElementValue == newValue) return this;
    return new StateActionValue(this.blockElementType, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link StateActionValueIF#getBlockElementValue() blockElementValue} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockElementValue
   * @return A modified copy of {@code this} object
   */
  public final StateActionValue withBlockElementValue(Optional<Object> optional) {
    @Nullable Object value = optional.orElse(null);
    if (this.blockElementValue == value) return this;
    return new StateActionValue(this.blockElementType, value);
  }

  /**
   * This instance is equal to all instances of {@code StateActionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof StateActionValue
        && equalTo((StateActionValue) another);
  }

  private boolean equalTo(StateActionValue another) {
    return blockElementType.equals(another.blockElementType)
        && Objects.equals(blockElementValue, another.blockElementValue);
  }

  /**
   * Computes a hash code from attributes: {@code blockElementType}, {@code blockElementValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + blockElementType.hashCode();
    h = h * 17 + Objects.hashCode(blockElementValue);
    return h;
  }

  /**
   * Prints the immutable value {@code StateActionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("StateActionValue{");
    builder.append("blockElementType=").append(blockElementType);
    if (blockElementValue != null) {
      builder.append(", ");
      builder.append("blockElementValue=").append(blockElementValue);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StateActionValueIF {
    @Nullable String blockElementType;
    Optional<Object> blockElementValue = Optional.empty();
    @JsonProperty
    public void setBlockElementType(String blockElementType) {
      this.blockElementType = blockElementType;
    }
    @JsonProperty
    public void setBlockElementValue(Optional<Object> blockElementValue) {
      this.blockElementValue = blockElementValue;
    }
    @Override
    public String getBlockElementType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Object> getBlockElementValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StateActionValue fromJson(Json json) {
    StateActionValue.Builder builder = StateActionValue.builder();
    if (json.blockElementType != null) {
      builder.setBlockElementType(json.blockElementType);
    }
    if (json.blockElementValue != null) {
      builder.setBlockElementValue(json.blockElementValue);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StateActionValueIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StateActionValue instance
   */
  public static StateActionValue copyOf(StateActionValueIF instance) {
    if (instance instanceof StateActionValue) {
      return (StateActionValue) instance;
    }
    return StateActionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link StateActionValue StateActionValue}.
   * @return A new StateActionValue builder
   */
  public static StateActionValue.Builder builder() {
    return new StateActionValue.Builder();
  }

  /**
   * Builds instances of type {@link StateActionValue StateActionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BLOCK_ELEMENT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String blockElementType;
    private @Nullable Object blockElementValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateActionValueIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StateActionValueIF instance) {
      Objects.requireNonNull(instance, "instance");
      setBlockElementType(instance.getBlockElementType());
      Optional<Object> blockElementValueOptional = instance.getBlockElementValue();
      if (blockElementValueOptional.isPresent()) {
        setBlockElementValue(blockElementValueOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StateActionValueIF#getBlockElementType() blockElementType} attribute.
     * @param blockElementType The value for blockElementType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockElementType(String blockElementType) {
      this.blockElementType = Objects.requireNonNull(blockElementType, "blockElementType");
      initBits &= ~INIT_BIT_BLOCK_ELEMENT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link StateActionValueIF#getBlockElementValue() blockElementValue} to blockElementValue.
     * @param blockElementValue The value for blockElementValue, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockElementValue(@Nullable Object blockElementValue) {
      this.blockElementValue = blockElementValue;
      return this;
    }

    /**
     * Initializes the optional value {@link StateActionValueIF#getBlockElementValue() blockElementValue} to blockElementValue.
     * @param blockElementValue The value for blockElementValue
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockElementValue(Optional<Object> blockElementValue) {
      this.blockElementValue = blockElementValue.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link StateActionValue StateActionValue}.
     * @return An immutable instance of StateActionValue
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public StateActionValue build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new StateActionValue(blockElementType, blockElementValue);
    }

    private boolean blockElementTypeIsSet() {
      return (initBits & INIT_BIT_BLOCK_ELEMENT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!blockElementTypeIsSet()) attributes.add("blockElementType");
      return "Cannot build StateActionValue, some of required attributes are not set " + attributes;
    }
  }
}
