package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StateActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StateAction.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StateActionIF"})
@Immutable
public final class StateAction implements StateActionIF {
  private final Map<String, StateActionValue> actionValues;

  private StateAction(Map<String, StateActionValue> actionValues) {
    this.actionValues = actionValues;
  }

  /**
   * @return The value of the {@code actionValues} attribute
   */
  @JsonProperty
  @JsonAnyGetter
  @Override
  public Map<String, StateActionValue> getActionValues() {
    return actionValues;
  }

  /**
   * Copy the current immutable object by replacing the {@link StateActionIF#getActionValues() actionValues} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param actionValues The entries to be added to the actionValues map
   * @return A modified copy of {@code this} object
   */
  public final StateAction withActionValues(Map<String, ? extends StateActionValue> actionValues) {
    if (this.actionValues == actionValues) return this;
    Map<String, StateActionValue> newValue = createUnmodifiableMap(true, false, actionValues);
    return new StateAction(newValue);
  }

  /**
   * This instance is equal to all instances of {@code StateAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof StateAction
        && equalTo((StateAction) another);
  }

  private boolean equalTo(StateAction another) {
    return actionValues.equals(another.actionValues);
  }

  /**
   * Computes a hash code from attributes: {@code actionValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + actionValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StateAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StateAction{"
        + "actionValues=" + actionValues
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StateActionIF {
    final Map<String, StateActionValue> actionValues = new HashMap<String, StateActionValue>();

    @JsonAnySetter
    public void setActionValues(String key, StateActionValue value) {
      this.actionValues.put(key, value);
    }
    @Override
    public Map<String, StateActionValue> getActionValues() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StateAction fromJson(Json json) {
    StateAction.Builder builder = StateAction.builder();
    if (json.actionValues != null) {
      builder.putAllActionValues(json.actionValues);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StateActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StateAction instance
   */
  public static StateAction copyOf(StateActionIF instance) {
    if (instance instanceof StateAction) {
      return (StateAction) instance;
    }
    return StateAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link StateAction StateAction}.
   * @return A new StateAction builder
   */
  public static StateAction.Builder builder() {
    return new StateAction.Builder();
  }

  /**
   * Builds instances of type {@link StateAction StateAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Map<String, StateActionValue> actionValues = new LinkedHashMap<String, StateActionValue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StateActionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StateActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      putAllActionValues(instance.getActionValues());
      return this;
    }

    /**
     * Put one entry to the {@link StateActionIF#getActionValues() actionValues} map.
     * @param key The key in the actionValues map
     * @param value The associated value in the actionValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putActionValues(String key, StateActionValue value) {
      this.actionValues.put(
          Objects.requireNonNull(key, "actionValues key"),
          Objects.requireNonNull(value, "actionValues value"));
      return this;
    }

    /**
     * Put one entry to the {@link StateActionIF#getActionValues() actionValues} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putActionValues(Map.Entry<String, ? extends StateActionValue> entry) {
      String k = entry.getKey();
      StateActionValue v = entry.getValue();
      this.actionValues.put(
          Objects.requireNonNull(k, "actionValues key"),
          Objects.requireNonNull(v, "actionValues value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link StateActionIF#getActionValues() actionValues} map. Nulls are not permitted
     * @param actionValues The entries that will be added to the actionValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionValues(Map<String, ? extends StateActionValue> actionValues) {
      this.actionValues.clear();
      return putAllActionValues(actionValues);
    }

    /**
     * Put all mappings from the specified map as entries to {@link StateActionIF#getActionValues() actionValues} map. Nulls are not permitted
     * @param actionValues The entries that will be added to the actionValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllActionValues(Map<String, ? extends StateActionValue> actionValues) {
      for (Map.Entry<String, ? extends StateActionValue> entry : actionValues.entrySet()) {
        String k = entry.getKey();
        StateActionValue v = entry.getValue();
        this.actionValues.put(
            Objects.requireNonNull(k, "actionValues key"),
            Objects.requireNonNull(v, "actionValues value"));
      }
      return this;
    }

    /**
     * Builds a new {@link StateAction StateAction}.
     * @return An immutable instance of StateAction
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public StateAction build() throws InvalidImmutableStateException {
      return new StateAction(createUnmodifiableMap(false, false, actionValues));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
