package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.objects.Text;
import com.hubspot.slack.client.models.response.views.json.StateBlockDeserializer;
import com.hubspot.slack.client.models.response.views.json.StateBlockSerializer;
import com.hubspot.slack.client.models.views.ModalViewPayloadBase;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ModalViewResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ModalViewResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ModalViewResponseIF"})
@Immutable
public final class ModalViewResponse
    implements ModalViewResponseIF {
  private final String type;
  private final Text title;
  private final @Nullable Text closeButtonText;
  private final @Nullable Text submitButtonText;
  private final @Nullable Boolean clearOnClose;
  private final @Nullable Boolean notifyOnClose;
  private final List<Block> blocks;
  private final @Nullable String privateMetadata;
  private final @Nullable String callbackId;
  private final @Nullable String externalId;
  private final String appId;
  private final String botId;
  private final String currentViewId;
  private final String rootViewId;
  private final String teamId;
  private final StateBlock stateValues;
  private final String hash;
  private final @Nullable String previousViewId;

  private ModalViewResponse(
      Text title,
      @Nullable Text closeButtonText,
      @Nullable Text submitButtonText,
      @Nullable Boolean clearOnClose,
      @Nullable Boolean notifyOnClose,
      List<Block> blocks,
      @Nullable String privateMetadata,
      @Nullable String callbackId,
      @Nullable String externalId,
      String appId,
      String botId,
      String currentViewId,
      String rootViewId,
      String teamId,
      StateBlock stateValues,
      String hash,
      @Nullable String previousViewId) {
    this.title = title;
    this.closeButtonText = closeButtonText;
    this.submitButtonText = submitButtonText;
    this.clearOnClose = clearOnClose;
    this.notifyOnClose = notifyOnClose;
    this.blocks = blocks;
    this.privateMetadata = privateMetadata;
    this.callbackId = callbackId;
    this.externalId = externalId;
    this.appId = appId;
    this.botId = botId;
    this.currentViewId = currentViewId;
    this.rootViewId = rootViewId;
    this.teamId = teamId;
    this.stateValues = stateValues;
    this.hash = hash;
    this.previousViewId = previousViewId;
    this.type = Objects.requireNonNull(ModalViewResponseIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Text getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code closeButtonText} attribute
   */
  @JsonProperty("close")
  @Override
  public Optional<Text> getCloseButtonText() {
    return Optional.ofNullable(closeButtonText);
  }

  /**
   * @return The value of the {@code submitButtonText} attribute
   */
  @JsonProperty("submit")
  @Override
  public Optional<Text> getSubmitButtonText() {
    return Optional.ofNullable(submitButtonText);
  }

  /**
   * @return The value of the {@code clearOnClose} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getClearOnClose() {
    return Optional.ofNullable(clearOnClose);
  }

  /**
   * @return The value of the {@code notifyOnClose} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getNotifyOnClose() {
    return Optional.ofNullable(notifyOnClose);
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    return blocks;
  }

  /**
   * @return The value of the {@code privateMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPrivateMetadata() {
    return Optional.ofNullable(privateMetadata);
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCallbackId() {
    return Optional.ofNullable(callbackId);
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * @return The value of the {@code appId} attribute
   */
  @JsonProperty
  @Override
  public String getAppId() {
    return appId;
  }

  /**
   * @return The value of the {@code botId} attribute
   */
  @JsonProperty
  @Override
  public String getBotId() {
    return botId;
  }

  /**
   * @return The value of the {@code currentViewId} attribute
   */
  @JsonProperty("id")
  @Override
  public String getCurrentViewId() {
    return currentViewId;
  }

  /**
   * @return The value of the {@code rootViewId} attribute
   */
  @JsonProperty
  @Override
  public String getRootViewId() {
    return rootViewId;
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty
  @Override
  public String getTeamId() {
    return teamId;
  }

  /**
   * @return The value of the {@code stateValues} attribute
   */
  @JsonProperty("state")
  @JsonDeserialize(using = StateBlockDeserializer.class)
  @JsonSerialize(using = StateBlockSerializer.class)
  @Override
  public StateBlock getStateValues() {
    return stateValues;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code previousViewId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPreviousViewId() {
    return Optional.ofNullable(previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getTitle() title} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withTitle(Text title) {
    if (this.title == title) return this;
    Text newValue = Objects.requireNonNull(title, "title");
    return new ModalViewResponse(
        newValue,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getCloseButtonText() closeButtonText} attribute.
   * @param value The value for closeButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withCloseButtonText(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.closeButtonText == newValue) return this;
    return new ModalViewResponse(
        this.title,
        newValue,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getCloseButtonText() closeButtonText} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closeButtonText
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withCloseButtonText(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.closeButtonText == value) return this;
    return new ModalViewResponse(
        this.title,
        value,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getSubmitButtonText() submitButtonText} attribute.
   * @param value The value for submitButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withSubmitButtonText(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.submitButtonText == newValue) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        newValue,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getSubmitButtonText() submitButtonText} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for submitButtonText
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withSubmitButtonText(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.submitButtonText == value) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        value,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getClearOnClose() clearOnClose} attribute.
   * @param value The value for clearOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withClearOnClose(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.clearOnClose, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        newValue,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getClearOnClose() clearOnClose} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for clearOnClose
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withClearOnClose(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.clearOnClose, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        value,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getNotifyOnClose() notifyOnClose} attribute.
   * @param value The value for notifyOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withNotifyOnClose(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.notifyOnClose, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        newValue,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getNotifyOnClose() notifyOnClose} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notifyOnClose
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withNotifyOnClose(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.notifyOnClose, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        value,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModalViewResponseIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        newValue,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ModalViewResponseIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        newValue,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getPrivateMetadata() privateMetadata} attribute.
   * @param value The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withPrivateMetadata(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.privateMetadata, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        newValue,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getPrivateMetadata() privateMetadata} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateMetadata
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withPrivateMetadata(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privateMetadata, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        value,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getCallbackId() callbackId} attribute.
   * @param value The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withCallbackId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.callbackId, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        newValue,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getCallbackId() callbackId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for callbackId
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withCallbackId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.callbackId, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        value,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getExternalId() externalId} attribute.
   * @param value The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withExternalId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        newValue,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        value,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getAppId() appId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param appId A new value for appId
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withAppId(String appId) {
    if (this.appId.equals(appId)) return this;
    String newValue = Objects.requireNonNull(appId, "appId");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        newValue,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getBotId() botId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param botId A new value for botId
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withBotId(String botId) {
    if (this.botId.equals(botId)) return this;
    String newValue = Objects.requireNonNull(botId, "botId");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        newValue,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getCurrentViewId() currentViewId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param currentViewId A new value for currentViewId
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withCurrentViewId(String currentViewId) {
    if (this.currentViewId.equals(currentViewId)) return this;
    String newValue = Objects.requireNonNull(currentViewId, "currentViewId");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        newValue,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getRootViewId() rootViewId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param rootViewId A new value for rootViewId
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withRootViewId(String rootViewId) {
    if (this.rootViewId.equals(rootViewId)) return this;
    String newValue = Objects.requireNonNull(rootViewId, "rootViewId");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        newValue,
        this.teamId,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getTeamId() teamId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param teamId A new value for teamId
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withTeamId(String teamId) {
    if (this.teamId.equals(teamId)) return this;
    String newValue = Objects.requireNonNull(teamId, "teamId");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        newValue,
        this.stateValues,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getStateValues() stateValues} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param stateValues A new value for stateValues
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withStateValues(StateBlock stateValues) {
    if (this.stateValues == stateValues) return this;
    StateBlock newValue = Objects.requireNonNull(stateValues, "stateValues");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        newValue,
        this.hash,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewResponseIF#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param hash A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewResponse withHash(String hash) {
    if (this.hash.equals(hash)) return this;
    String newValue = Objects.requireNonNull(hash, "hash");
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        newValue,
        this.previousViewId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewResponseIF#getPreviousViewId() previousViewId} attribute.
   * @param value The value for previousViewId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withPreviousViewId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.previousViewId, newValue)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewResponseIF#getPreviousViewId() previousViewId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for previousViewId
   * @return A modified copy of {@code this} object
   */
  public final ModalViewResponse withPreviousViewId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.previousViewId, value)) return this;
    return new ModalViewResponse(
        this.title,
        this.closeButtonText,
        this.submitButtonText,
        this.clearOnClose,
        this.notifyOnClose,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId,
        this.appId,
        this.botId,
        this.currentViewId,
        this.rootViewId,
        this.teamId,
        this.stateValues,
        this.hash,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ModalViewResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ModalViewResponse
        && equalTo((ModalViewResponse) another);
  }

  private boolean equalTo(ModalViewResponse another) {
    return type.equals(another.type)
        && title.equals(another.title)
        && Objects.equals(closeButtonText, another.closeButtonText)
        && Objects.equals(submitButtonText, another.submitButtonText)
        && Objects.equals(clearOnClose, another.clearOnClose)
        && Objects.equals(notifyOnClose, another.notifyOnClose)
        && blocks.equals(another.blocks)
        && Objects.equals(privateMetadata, another.privateMetadata)
        && Objects.equals(callbackId, another.callbackId)
        && Objects.equals(externalId, another.externalId)
        && appId.equals(another.appId)
        && botId.equals(another.botId)
        && currentViewId.equals(another.currentViewId)
        && rootViewId.equals(another.rootViewId)
        && teamId.equals(another.teamId)
        && stateValues.equals(another.stateValues)
        && hash.equals(another.hash)
        && Objects.equals(previousViewId, another.previousViewId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code title}, {@code closeButtonText}, {@code submitButtonText}, {@code clearOnClose}, {@code notifyOnClose}, {@code blocks}, {@code privateMetadata}, {@code callbackId}, {@code externalId}, {@code appId}, {@code botId}, {@code currentViewId}, {@code rootViewId}, {@code teamId}, {@code stateValues}, {@code hash}, {@code previousViewId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + title.hashCode();
    h = h * 17 + Objects.hashCode(closeButtonText);
    h = h * 17 + Objects.hashCode(submitButtonText);
    h = h * 17 + Objects.hashCode(clearOnClose);
    h = h * 17 + Objects.hashCode(notifyOnClose);
    h = h * 17 + blocks.hashCode();
    h = h * 17 + Objects.hashCode(privateMetadata);
    h = h * 17 + Objects.hashCode(callbackId);
    h = h * 17 + Objects.hashCode(externalId);
    h = h * 17 + appId.hashCode();
    h = h * 17 + botId.hashCode();
    h = h * 17 + currentViewId.hashCode();
    h = h * 17 + rootViewId.hashCode();
    h = h * 17 + teamId.hashCode();
    h = h * 17 + stateValues.hashCode();
    h = h * 17 + hash.hashCode();
    h = h * 17 + Objects.hashCode(previousViewId);
    return h;
  }

  /**
   * Prints the immutable value {@code ModalViewResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ModalViewResponse{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("title=").append(title);
    if (closeButtonText != null) {
      builder.append(", ");
      builder.append("closeButtonText=").append(closeButtonText);
    }
    if (submitButtonText != null) {
      builder.append(", ");
      builder.append("submitButtonText=").append(submitButtonText);
    }
    if (clearOnClose != null) {
      builder.append(", ");
      builder.append("clearOnClose=").append(clearOnClose);
    }
    if (notifyOnClose != null) {
      builder.append(", ");
      builder.append("notifyOnClose=").append(notifyOnClose);
    }
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    if (privateMetadata != null) {
      builder.append(", ");
      builder.append("privateMetadata=").append(privateMetadata);
    }
    if (callbackId != null) {
      builder.append(", ");
      builder.append("callbackId=").append(callbackId);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    builder.append(", ");
    builder.append("appId=").append(appId);
    builder.append(", ");
    builder.append("botId=").append(botId);
    builder.append(", ");
    builder.append("currentViewId=").append(currentViewId);
    builder.append(", ");
    builder.append("rootViewId=").append(rootViewId);
    builder.append(", ");
    builder.append("teamId=").append(teamId);
    builder.append(", ");
    builder.append("stateValues=").append(stateValues);
    builder.append(", ");
    builder.append("hash=").append(hash);
    if (previousViewId != null) {
      builder.append(", ");
      builder.append("previousViewId=").append(previousViewId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ModalViewResponseIF {
    @Nullable Text title;
    Optional<Text> closeButtonText = Optional.empty();
    Optional<Text> submitButtonText = Optional.empty();
    Optional<Boolean> clearOnClose = Optional.empty();
    Optional<Boolean> notifyOnClose = Optional.empty();
    List<Block> blocks = Collections.emptyList();
    Optional<String> privateMetadata = Optional.empty();
    Optional<String> callbackId = Optional.empty();
    Optional<String> externalId = Optional.empty();
    @Nullable String appId;
    @Nullable String botId;
    @Nullable String currentViewId;
    @Nullable String rootViewId;
    @Nullable String teamId;
    @Nullable StateBlock stateValues;
    @Nullable String hash;
    Optional<String> previousViewId = Optional.empty();
    @JsonProperty
    public void setTitle(Text title) {
      this.title = title;
    }
    @JsonProperty("close")
    public void setCloseButtonText(Optional<Text> closeButtonText) {
      this.closeButtonText = closeButtonText;
    }
    @JsonProperty("submit")
    public void setSubmitButtonText(Optional<Text> submitButtonText) {
      this.submitButtonText = submitButtonText;
    }
    @JsonProperty
    public void setClearOnClose(Optional<Boolean> clearOnClose) {
      this.clearOnClose = clearOnClose;
    }
    @JsonProperty
    public void setNotifyOnClose(Optional<Boolean> notifyOnClose) {
      this.notifyOnClose = notifyOnClose;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
    }
    @JsonProperty
    public void setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata;
    }
    @JsonProperty
    public void setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @JsonProperty
    public void setAppId(String appId) {
      this.appId = appId;
    }
    @JsonProperty
    public void setBotId(String botId) {
      this.botId = botId;
    }
    @JsonProperty("id")
    public void setCurrentViewId(String currentViewId) {
      this.currentViewId = currentViewId;
    }
    @JsonProperty
    public void setRootViewId(String rootViewId) {
      this.rootViewId = rootViewId;
    }
    @JsonProperty
    public void setTeamId(String teamId) {
      this.teamId = teamId;
    }
    @JsonProperty("state")
    @JsonDeserialize(using = StateBlockDeserializer.class)
    @JsonSerialize(using = StateBlockSerializer.class)
    public void setStateValues(StateBlock stateValues) {
      this.stateValues = stateValues;
    }
    @JsonProperty
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty
    public void setPreviousViewId(Optional<String> previousViewId) {
      this.previousViewId = previousViewId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getCloseButtonText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getSubmitButtonText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getClearOnClose() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getNotifyOnClose() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPrivateMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public String getAppId() { throw new UnsupportedOperationException(); }
    @Override
    public String getBotId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCurrentViewId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRootViewId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public StateBlock getStateValues() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPreviousViewId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ModalViewResponse fromJson(Json json) {
    ModalViewResponse.Builder builder = ModalViewResponse.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.closeButtonText != null) {
      builder.setCloseButtonText(json.closeButtonText);
    }
    if (json.submitButtonText != null) {
      builder.setSubmitButtonText(json.submitButtonText);
    }
    if (json.clearOnClose != null) {
      builder.setClearOnClose(json.clearOnClose);
    }
    if (json.notifyOnClose != null) {
      builder.setNotifyOnClose(json.notifyOnClose);
    }
    if (json.blocks != null) {
      builder.addAllBlocks(json.blocks);
    }
    if (json.privateMetadata != null) {
      builder.setPrivateMetadata(json.privateMetadata);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.externalId != null) {
      builder.setExternalId(json.externalId);
    }
    if (json.appId != null) {
      builder.setAppId(json.appId);
    }
    if (json.botId != null) {
      builder.setBotId(json.botId);
    }
    if (json.currentViewId != null) {
      builder.setCurrentViewId(json.currentViewId);
    }
    if (json.rootViewId != null) {
      builder.setRootViewId(json.rootViewId);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.stateValues != null) {
      builder.setStateValues(json.stateValues);
    }
    if (json.hash != null) {
      builder.setHash(json.hash);
    }
    if (json.previousViewId != null) {
      builder.setPreviousViewId(json.previousViewId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ModalViewResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ModalViewResponse instance
   */
  public static ModalViewResponse copyOf(ModalViewResponseIF instance) {
    if (instance instanceof ModalViewResponse) {
      return (ModalViewResponse) instance;
    }
    return ModalViewResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ModalViewResponse ModalViewResponse}.
   * @return A new ModalViewResponse builder
   */
  public static ModalViewResponse.Builder builder() {
    return new ModalViewResponse.Builder();
  }

  /**
   * Builds instances of type {@link ModalViewResponse ModalViewResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_APP_ID = 0x2L;
    private static final long INIT_BIT_BOT_ID = 0x4L;
    private static final long INIT_BIT_CURRENT_VIEW_ID = 0x8L;
    private static final long INIT_BIT_ROOT_VIEW_ID = 0x10L;
    private static final long INIT_BIT_TEAM_ID = 0x20L;
    private static final long INIT_BIT_STATE_VALUES = 0x40L;
    private static final long INIT_BIT_HASH = 0x80L;
    private long initBits = 0xffL;

    private @Nullable Text title;
    private @Nullable Text closeButtonText;
    private @Nullable Text submitButtonText;
    private @Nullable Boolean clearOnClose;
    private @Nullable Boolean notifyOnClose;
    private List<Block> blocks = new ArrayList<Block>();
    private @Nullable String privateMetadata;
    private @Nullable String callbackId;
    private @Nullable String externalId;
    private @Nullable String appId;
    private @Nullable String botId;
    private @Nullable String currentViewId;
    private @Nullable String rootViewId;
    private @Nullable String teamId;
    private @Nullable StateBlock stateValues;
    private @Nullable String hash;
    private @Nullable String previousViewId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ModalViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModalViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.views.ViewResponseBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewResponseBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.views.ModalViewResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModalViewResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ModalViewPayloadBase) {
        ModalViewPayloadBase instance = (ModalViewPayloadBase) object;
        Optional<Text> submitButtonTextOptional = instance.getSubmitButtonText();
        if (submitButtonTextOptional.isPresent()) {
          setSubmitButtonText(submitButtonTextOptional);
        }
        Optional<Boolean> notifyOnCloseOptional = instance.getNotifyOnClose();
        if (notifyOnCloseOptional.isPresent()) {
          setNotifyOnClose(notifyOnCloseOptional);
        }
        Optional<Text> closeButtonTextOptional = instance.getCloseButtonText();
        if (closeButtonTextOptional.isPresent()) {
          setCloseButtonText(closeButtonTextOptional);
        }
        setTitle(instance.getTitle());
        Optional<Boolean> clearOnCloseOptional = instance.getClearOnClose();
        if (clearOnCloseOptional.isPresent()) {
          setClearOnClose(clearOnCloseOptional);
        }
      }
      if (object instanceof ViewPayloadBase) {
        ViewPayloadBase instance = (ViewPayloadBase) object;
        Optional<String> externalIdOptional = instance.getExternalId();
        if (externalIdOptional.isPresent()) {
          setExternalId(externalIdOptional);
        }
        Optional<String> privateMetadataOptional = instance.getPrivateMetadata();
        if (privateMetadataOptional.isPresent()) {
          setPrivateMetadata(privateMetadataOptional);
        }
        Optional<String> callbackIdOptional = instance.getCallbackId();
        if (callbackIdOptional.isPresent()) {
          setCallbackId(callbackIdOptional);
        }
        addAllBlocks(instance.getBlocks());
      }
      if (object instanceof ViewResponseBase) {
        ViewResponseBase instance = (ViewResponseBase) object;
        setAppId(instance.getAppId());
        setTeamId(instance.getTeamId());
        setStateValues(instance.getStateValues());
        setBotId(instance.getBotId());
        Optional<String> previousViewIdOptional = instance.getPreviousViewId();
        if (previousViewIdOptional.isPresent()) {
          setPreviousViewId(previousViewIdOptional);
        }
        setCurrentViewId(instance.getCurrentViewId());
        setHash(instance.getHash());
        setRootViewId(instance.getRootViewId());
      }
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Text title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getCloseButtonText() closeButtonText} to closeButtonText.
     * @param closeButtonText The value for closeButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCloseButtonText(@Nullable Text closeButtonText) {
      this.closeButtonText = closeButtonText;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getCloseButtonText() closeButtonText} to closeButtonText.
     * @param closeButtonText The value for closeButtonText
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCloseButtonText(Optional<Text> closeButtonText) {
      this.closeButtonText = closeButtonText.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getSubmitButtonText() submitButtonText} to submitButtonText.
     * @param submitButtonText The value for submitButtonText, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubmitButtonText(@Nullable Text submitButtonText) {
      this.submitButtonText = submitButtonText;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getSubmitButtonText() submitButtonText} to submitButtonText.
     * @param submitButtonText The value for submitButtonText
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubmitButtonText(Optional<Text> submitButtonText) {
      this.submitButtonText = submitButtonText.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getClearOnClose() clearOnClose} to clearOnClose.
     * @param clearOnClose The value for clearOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setClearOnClose(@Nullable Boolean clearOnClose) {
      this.clearOnClose = clearOnClose;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getClearOnClose() clearOnClose} to clearOnClose.
     * @param clearOnClose The value for clearOnClose
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setClearOnClose(Optional<Boolean> clearOnClose) {
      this.clearOnClose = clearOnClose.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getNotifyOnClose() notifyOnClose} to notifyOnClose.
     * @param notifyOnClose The value for notifyOnClose, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNotifyOnClose(@Nullable Boolean notifyOnClose) {
      this.notifyOnClose = notifyOnClose;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getNotifyOnClose() notifyOnClose} to notifyOnClose.
     * @param notifyOnClose The value for notifyOnClose
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNotifyOnClose(Optional<Boolean> notifyOnClose) {
      this.notifyOnClose = notifyOnClose.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ModalViewResponseIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      return this;
    }

    /**
     * Adds elements to {@link ModalViewResponseIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ModalViewResponseIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link ModalViewResponseIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
      this.privateMetadata = privateMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCallbackId(@Nullable String callbackId) {
      this.callbackId = callbackId;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getAppId() appId} attribute.
     * @param appId The value for appId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAppId(String appId) {
      this.appId = Objects.requireNonNull(appId, "appId");
      initBits &= ~INIT_BIT_APP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getBotId() botId} attribute.
     * @param botId The value for botId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBotId(String botId) {
      this.botId = Objects.requireNonNull(botId, "botId");
      initBits &= ~INIT_BIT_BOT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getCurrentViewId() currentViewId} attribute.
     * @param currentViewId The value for currentViewId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCurrentViewId(String currentViewId) {
      this.currentViewId = Objects.requireNonNull(currentViewId, "currentViewId");
      initBits &= ~INIT_BIT_CURRENT_VIEW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getRootViewId() rootViewId} attribute.
     * @param rootViewId The value for rootViewId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRootViewId(String rootViewId) {
      this.rootViewId = Objects.requireNonNull(rootViewId, "rootViewId");
      initBits &= ~INIT_BIT_ROOT_VIEW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getTeamId() teamId} attribute.
     * @param teamId The value for teamId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamId(String teamId) {
      this.teamId = Objects.requireNonNull(teamId, "teamId");
      initBits &= ~INIT_BIT_TEAM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getStateValues() stateValues} attribute.
     * @param stateValues The value for stateValues 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStateValues(StateBlock stateValues) {
      this.stateValues = Objects.requireNonNull(stateValues, "stateValues");
      initBits &= ~INIT_BIT_STATE_VALUES;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewResponseIF#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getPreviousViewId() previousViewId} to previousViewId.
     * @param previousViewId The value for previousViewId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPreviousViewId(@Nullable String previousViewId) {
      this.previousViewId = previousViewId;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewResponseIF#getPreviousViewId() previousViewId} to previousViewId.
     * @param previousViewId The value for previousViewId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPreviousViewId(Optional<String> previousViewId) {
      this.previousViewId = previousViewId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ModalViewResponse ModalViewResponse}.
     * @return An immutable instance of ModalViewResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ModalViewResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ModalViewResponse(
          title,
          closeButtonText,
          submitButtonText,
          clearOnClose,
          notifyOnClose,
          createUnmodifiableList(true, blocks),
          privateMetadata,
          callbackId,
          externalId,
          appId,
          botId,
          currentViewId,
          rootViewId,
          teamId,
          stateValues,
          hash,
          previousViewId);
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean appIdIsSet() {
      return (initBits & INIT_BIT_APP_ID) == 0;
    }

    private boolean botIdIsSet() {
      return (initBits & INIT_BIT_BOT_ID) == 0;
    }

    private boolean currentViewIdIsSet() {
      return (initBits & INIT_BIT_CURRENT_VIEW_ID) == 0;
    }

    private boolean rootViewIdIsSet() {
      return (initBits & INIT_BIT_ROOT_VIEW_ID) == 0;
    }

    private boolean teamIdIsSet() {
      return (initBits & INIT_BIT_TEAM_ID) == 0;
    }

    private boolean stateValuesIsSet() {
      return (initBits & INIT_BIT_STATE_VALUES) == 0;
    }

    private boolean hashIsSet() {
      return (initBits & INIT_BIT_HASH) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!titleIsSet()) attributes.add("title");
      if (!appIdIsSet()) attributes.add("appId");
      if (!botIdIsSet()) attributes.add("botId");
      if (!currentViewIdIsSet()) attributes.add("currentViewId");
      if (!rootViewIdIsSet()) attributes.add("rootViewId");
      if (!teamIdIsSet()) attributes.add("teamId");
      if (!stateValuesIsSet()) attributes.add("stateValues");
      if (!hashIsSet()) attributes.add("hash");
      return "Cannot build ModalViewResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
