package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ModalViewCommandResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ModalViewCommandResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ModalViewCommandResponseIF"})
@Immutable
public final class ModalViewCommandResponse
    implements ModalViewCommandResponseIF {
  private final ModalViewResponse view;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ModalViewCommandResponse(ModalViewResponse view, boolean ok, @Nullable ResponseMetadata responseMetadata) {
    this.view = view;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public ModalViewResponse getView() {
    return view;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewCommandResponseIF#getView() view} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param view A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewCommandResponse withView(ModalViewResponse view) {
    if (this.view == view) return this;
    ModalViewResponse newValue = Objects.requireNonNull(view, "view");
    return new ModalViewCommandResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModalViewCommandResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ModalViewCommandResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ModalViewCommandResponse(this.view, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ModalViewCommandResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ModalViewCommandResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ModalViewCommandResponse(this.view, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ModalViewCommandResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ModalViewCommandResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ModalViewCommandResponse(this.view, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ModalViewCommandResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ModalViewCommandResponse
        && equalTo((ModalViewCommandResponse) another);
  }

  private boolean equalTo(ModalViewCommandResponse another) {
    return view.equals(another.view)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code view}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + view.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ModalViewCommandResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ModalViewCommandResponse{");
    builder.append("view=").append(view);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ModalViewCommandResponseIF {
    @Nullable ModalViewResponse view;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setView(ModalViewResponse view) {
      this.view = view;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public ModalViewResponse getView() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ModalViewCommandResponse fromJson(Json json) {
    ModalViewCommandResponse.Builder builder = ModalViewCommandResponse.builder();
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ModalViewCommandResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ModalViewCommandResponse instance
   */
  public static ModalViewCommandResponse copyOf(ModalViewCommandResponseIF instance) {
    if (instance instanceof ModalViewCommandResponse) {
      return (ModalViewCommandResponse) instance;
    }
    return ModalViewCommandResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ModalViewCommandResponse ModalViewCommandResponse}.
   * @return A new ModalViewCommandResponse builder
   */
  public static ModalViewCommandResponse.Builder builder() {
    return new ModalViewCommandResponse.Builder();
  }

  /**
   * Builds instances of type {@link ModalViewCommandResponse ModalViewCommandResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VIEW = 0x1L;
    private static final long INIT_BIT_OK = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ModalViewResponse view;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.views.ModalViewCommandResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModalViewCommandResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ModalViewCommandResponseIF) {
        ModalViewCommandResponseIF instance = (ModalViewCommandResponseIF) object;
        setView(instance.getView());
      }
    }

    /**
     * Initializes the value for the {@link ModalViewCommandResponseIF#getView() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(ModalViewResponse view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Initializes the value for the {@link ModalViewCommandResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewCommandResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ModalViewCommandResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ModalViewCommandResponse ModalViewCommandResponse}.
     * @return An immutable instance of ModalViewCommandResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ModalViewCommandResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ModalViewCommandResponse(view, ok, responseMetadata);
    }

    private boolean viewIsSet() {
      return (initBits & INIT_BIT_VIEW) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!viewIsSet()) attributes.add("view");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ModalViewCommandResponse, some of required attributes are not set " + attributes;
    }
  }
}
