package com.hubspot.slack.client.models.response.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.users.UserProfile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsersProfileResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsersProfileResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsersProfileResponseIF"})
@Immutable
public final class UsersProfileResponse
    implements UsersProfileResponseIF {
  private final UserProfile userProfile;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private UsersProfileResponse(
      UserProfile userProfile,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.userProfile = userProfile;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code userProfile} attribute
   */
  @JsonProperty("profile")
  @Override
  public UserProfile getUserProfile() {
    return userProfile;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersProfileResponseIF#getUserProfile() userProfile} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param userProfile A new value for userProfile
   * @return A modified copy of the {@code this} object
   */
  public final UsersProfileResponse withUserProfile(UserProfile userProfile) {
    if (this.userProfile == userProfile) return this;
    UserProfile newValue = Objects.requireNonNull(userProfile, "userProfile");
    return new UsersProfileResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersProfileResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final UsersProfileResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new UsersProfileResponse(this.userProfile, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsersProfileResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsersProfileResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new UsersProfileResponse(this.userProfile, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsersProfileResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final UsersProfileResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new UsersProfileResponse(this.userProfile, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code UsersProfileResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsersProfileResponse
        && equalTo((UsersProfileResponse) another);
  }

  private boolean equalTo(UsersProfileResponse another) {
    return userProfile.equals(another.userProfile)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code userProfile}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userProfile.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UsersProfileResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsersProfileResponse{");
    builder.append("userProfile=").append(userProfile);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsersProfileResponseIF {
    @Nullable UserProfile userProfile;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty("profile")
    public void setUserProfile(UserProfile userProfile) {
      this.userProfile = userProfile;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public UserProfile getUserProfile() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsersProfileResponse fromJson(Json json) {
    UsersProfileResponse.Builder builder = UsersProfileResponse.builder();
    if (json.userProfile != null) {
      builder.setUserProfile(json.userProfile);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsersProfileResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsersProfileResponse instance
   */
  public static UsersProfileResponse copyOf(UsersProfileResponseIF instance) {
    if (instance instanceof UsersProfileResponse) {
      return (UsersProfileResponse) instance;
    }
    return UsersProfileResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsersProfileResponse UsersProfileResponse}.
   * @return A new UsersProfileResponse builder
   */
  public static UsersProfileResponse.Builder builder() {
    return new UsersProfileResponse.Builder();
  }

  /**
   * Builds instances of type {@link UsersProfileResponse UsersProfileResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_PROFILE = 0x1L;
    private static final long INIT_BIT_OK = 0x2L;
    private long initBits = 0x3L;

    private @Nullable UserProfile userProfile;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.users.UsersProfileResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsersProfileResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof UsersProfileResponseIF) {
        UsersProfileResponseIF instance = (UsersProfileResponseIF) object;
        setUserProfile(instance.getUserProfile());
      }
    }

    /**
     * Initializes the value for the {@link UsersProfileResponseIF#getUserProfile() userProfile} attribute.
     * @param userProfile The value for userProfile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserProfile(UserProfile userProfile) {
      this.userProfile = Objects.requireNonNull(userProfile, "userProfile");
      initBits &= ~INIT_BIT_USER_PROFILE;
      return this;
    }

    /**
     * Initializes the value for the {@link UsersProfileResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersProfileResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersProfileResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsersProfileResponse UsersProfileResponse}.
     * @return An immutable instance of UsersProfileResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsersProfileResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsersProfileResponse(userProfile, ok, responseMetadata);
    }

    private boolean userProfileIsSet() {
      return (initBits & INIT_BIT_USER_PROFILE) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userProfileIsSet()) attributes.add("userProfile");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build UsersProfileResponse, some of required attributes are not set " + attributes;
    }
  }
}
