package com.hubspot.slack.client.models.response.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.MessagePage;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SearchMessageResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SearchMessageResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SearchMessageResponseIF"})
@Immutable
public final class SearchMessageResponse
    implements SearchMessageResponseIF {
  private final String query;
  private final MessagePage messages;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private SearchMessageResponse(
      String query,
      MessagePage messages,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.query = query;
    this.messages = messages;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @JsonProperty
  @Override
  public String getQuery() {
    return query;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @JsonProperty
  @Override
  public MessagePage getMessages() {
    return messages;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessageResponseIF#getQuery() query} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param query A new value for query
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessageResponse withQuery(String query) {
    if (this.query.equals(query)) return this;
    String newValue = Objects.requireNonNull(query, "query");
    return new SearchMessageResponse(newValue, this.messages, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessageResponseIF#getMessages() messages} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param messages A new value for messages
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessageResponse withMessages(MessagePage messages) {
    if (this.messages == messages) return this;
    MessagePage newValue = Objects.requireNonNull(messages, "messages");
    return new SearchMessageResponse(this.query, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessageResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessageResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new SearchMessageResponse(this.query, this.messages, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SearchMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new SearchMessageResponse(this.query, this.messages, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final SearchMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new SearchMessageResponse(this.query, this.messages, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code SearchMessageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SearchMessageResponse
        && equalTo((SearchMessageResponse) another);
  }

  private boolean equalTo(SearchMessageResponse another) {
    return query.equals(another.query)
        && messages.equals(another.messages)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code query}, {@code messages}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + query.hashCode();
    h = h * 17 + messages.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchMessageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SearchMessageResponse{");
    builder.append("query=").append(query);
    builder.append(", ");
    builder.append("messages=").append(messages);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchMessageResponseIF {
    @Nullable String query;
    @Nullable MessagePage messages;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setQuery(String query) {
      this.query = query;
    }
    @JsonProperty
    public void setMessages(MessagePage messages) {
      this.messages = messages;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getQuery() { throw new UnsupportedOperationException(); }
    @Override
    public MessagePage getMessages() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SearchMessageResponse fromJson(Json json) {
    SearchMessageResponse.Builder builder = SearchMessageResponse.builder();
    if (json.query != null) {
      builder.setQuery(json.query);
    }
    if (json.messages != null) {
      builder.setMessages(json.messages);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchMessageResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchMessageResponse instance
   */
  public static SearchMessageResponse copyOf(SearchMessageResponseIF instance) {
    if (instance instanceof SearchMessageResponse) {
      return (SearchMessageResponse) instance;
    }
    return SearchMessageResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SearchMessageResponse SearchMessageResponse}.
   * @return A new SearchMessageResponse builder
   */
  public static SearchMessageResponse.Builder builder() {
    return new SearchMessageResponse.Builder();
  }

  /**
   * Builds instances of type {@link SearchMessageResponse SearchMessageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUERY = 0x1L;
    private static final long INIT_BIT_MESSAGES = 0x2L;
    private static final long INIT_BIT_OK = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String query;
    private @Nullable MessagePage messages;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.search.SearchMessageResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchMessageResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SearchMessageResponseIF) {
        SearchMessageResponseIF instance = (SearchMessageResponseIF) object;
        setMessages(instance.getMessages());
        setQuery(instance.getQuery());
      }
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link SearchMessageResponseIF#getQuery() query} attribute.
     * @param query The value for query 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setQuery(String query) {
      this.query = Objects.requireNonNull(query, "query");
      initBits &= ~INIT_BIT_QUERY;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessageResponseIF#getMessages() messages} attribute.
     * @param messages The value for messages 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessages(MessagePage messages) {
      this.messages = Objects.requireNonNull(messages, "messages");
      initBits &= ~INIT_BIT_MESSAGES;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessageResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SearchMessageResponse SearchMessageResponse}.
     * @return An immutable instance of SearchMessageResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SearchMessageResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SearchMessageResponse(query, messages, ok, responseMetadata);
    }

    private boolean queryIsSet() {
      return (initBits & INIT_BIT_QUERY) == 0;
    }

    private boolean messagesIsSet() {
      return (initBits & INIT_BIT_MESSAGES) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!queryIsSet()) attributes.add("query");
      if (!messagesIsSet()) attributes.add("messages");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build SearchMessageResponse, some of required attributes are not set " + attributes;
    }
  }
}
