package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.conversations.Conversation;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationListResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationListResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationListResponseIF"})
@Immutable
public final class ConversationListResponse
    implements ConversationListResponseIF {
  private final List<Conversation> conversations;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ConversationListResponse(
      List<Conversation> conversations,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.conversations = conversations;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code conversations} attribute
   */
  @JsonProperty("channels")
  @Override
  public List<Conversation> getConversations() {
    return conversations;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationListResponseIF#getConversations() conversations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationListResponse withConversations(Conversation... elements) {
    List<Conversation> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ConversationListResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationListResponseIF#getConversations() conversations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of conversations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationListResponse withConversations(Iterable<? extends Conversation> elements) {
    if (this.conversations == elements) return this;
    List<Conversation> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ConversationListResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationListResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ConversationListResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ConversationListResponse(this.conversations, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationListResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ConversationListResponse(this.conversations, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationListResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ConversationListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ConversationListResponse(this.conversations, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationListResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationListResponse
        && equalTo((ConversationListResponse) another);
  }

  private boolean equalTo(ConversationListResponse another) {
    return conversations.equals(another.conversations)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code conversations}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + conversations.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationListResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationListResponse{");
    builder.append("conversations=").append(conversations);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationListResponseIF {
    List<Conversation> conversations = Collections.emptyList();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty("channels")
    public void setConversations(List<Conversation> conversations) {
      this.conversations = conversations;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public List<Conversation> getConversations() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationListResponse fromJson(Json json) {
    ConversationListResponse.Builder builder = ConversationListResponse.builder();
    if (json.conversations != null) {
      builder.addAllConversations(json.conversations);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationListResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationListResponse instance
   */
  public static ConversationListResponse copyOf(ConversationListResponseIF instance) {
    if (instance instanceof ConversationListResponse) {
      return (ConversationListResponse) instance;
    }
    return ConversationListResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationListResponse ConversationListResponse}.
   * @return A new ConversationListResponse builder
   */
  public static ConversationListResponse.Builder builder() {
    return new ConversationListResponse.Builder();
  }

  /**
   * Builds instances of type {@link ConversationListResponse ConversationListResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OK = 0x1L;
    private long initBits = 0x1L;

    private List<Conversation> conversations = new ArrayList<Conversation>();
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.conversations.ConversationListResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationListResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ConversationListResponseIF) {
        ConversationListResponseIF instance = (ConversationListResponseIF) object;
        addAllConversations(instance.getConversations());
      }
    }

    /**
     * Adds one element to {@link ConversationListResponseIF#getConversations() conversations} list.
     * @param element A conversations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConversations(Conversation element) {
      this.conversations.add(Objects.requireNonNull(element, "conversations element"));
      return this;
    }

    /**
     * Adds elements to {@link ConversationListResponseIF#getConversations() conversations} list.
     * @param elements An array of conversations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConversations(Conversation... elements) {
      for (Conversation element : elements) {
        this.conversations.add(Objects.requireNonNull(element, "conversations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ConversationListResponseIF#getConversations() conversations} list.
     * @param elements An iterable of conversations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConversations(Iterable<? extends Conversation> elements) {
      this.conversations.clear();
      return addAllConversations(elements);
    }

    /**
     * Adds elements to {@link ConversationListResponseIF#getConversations() conversations} list.
     * @param elements An iterable of conversations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllConversations(Iterable<? extends Conversation> elements) {
      for (Conversation element : elements) {
        this.conversations.add(Objects.requireNonNull(element, "conversations element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationListResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationListResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationListResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationListResponse ConversationListResponse}.
     * @return An immutable instance of ConversationListResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationListResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationListResponse(createUnmodifiableList(true, conversations), ok, responseMetadata);
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ConversationListResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
