package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatUpdateMessageResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatUpdateMessageResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatUpdateMessageResponseIF"})
@Immutable
public final class ChatUpdateMessageResponse
    implements ChatUpdateMessageResponseIF {
  private final String ts;
  private final String channel;
  private final String text;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ChatUpdateMessageResponse(
      String ts,
      String channel,
      String text,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.ts = ts;
    this.channel = channel;
    this.text = text;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public String getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageResponseIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageResponse withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new ChatUpdateMessageResponse(newValue, this.channel, this.text, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageResponseIF#getChannel() channel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageResponse withChannel(String channel) {
    if (this.channel.equals(channel)) return this;
    String newValue = Objects.requireNonNull(channel, "channel");
    return new ChatUpdateMessageResponse(this.ts, newValue, this.text, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageResponseIF#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageResponse withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new ChatUpdateMessageResponse(this.ts, this.channel, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUpdateMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUpdateMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ChatUpdateMessageResponse(this.ts, this.channel, this.text, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ChatUpdateMessageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatUpdateMessageResponse
        && equalTo((ChatUpdateMessageResponse) another);
  }

  private boolean equalTo(ChatUpdateMessageResponse another) {
    return ts.equals(another.ts)
        && channel.equals(another.channel)
        && text.equals(another.text)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code ts}, {@code channel}, {@code text}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + ts.hashCode();
    h = h * 17 + channel.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatUpdateMessageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatUpdateMessageResponse{");
    builder.append("ts=").append(ts);
    builder.append(", ");
    builder.append("channel=").append(channel);
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatUpdateMessageResponseIF {
    @Nullable String ts;
    @Nullable String channel;
    @Nullable String text;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @JsonProperty
    public void setChannel(String channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatUpdateMessageResponse fromJson(Json json) {
    ChatUpdateMessageResponse.Builder builder = ChatUpdateMessageResponse.builder();
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatUpdateMessageResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatUpdateMessageResponse instance
   */
  public static ChatUpdateMessageResponse copyOf(ChatUpdateMessageResponseIF instance) {
    if (instance instanceof ChatUpdateMessageResponse) {
      return (ChatUpdateMessageResponse) instance;
    }
    return ChatUpdateMessageResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatUpdateMessageResponse ChatUpdateMessageResponse}.
   * @return A new ChatUpdateMessageResponse builder
   */
  public static ChatUpdateMessageResponse.Builder builder() {
    return new ChatUpdateMessageResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChatUpdateMessageResponse ChatUpdateMessageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TS = 0x1L;
    private static final long INIT_BIT_CHANNEL = 0x2L;
    private static final long INIT_BIT_TEXT = 0x4L;
    private static final long INIT_BIT_OK = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String ts;
    private @Nullable String channel;
    private @Nullable String text;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.chat.ChatUpdateMessageResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatUpdateMessageResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ChatUpdateMessageResponseIF) {
        ChatUpdateMessageResponseIF instance = (ChatUpdateMessageResponseIF) object;
        setChannel(instance.getChannel());
        setText(instance.getText());
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageResponseIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageResponseIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(String channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageResponseIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChatUpdateMessageResponse ChatUpdateMessageResponse}.
     * @return An immutable instance of ChatUpdateMessageResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatUpdateMessageResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatUpdateMessageResponse(ts, channel, text, ok, responseMetadata);
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tsIsSet()) attributes.add("ts");
      if (!channelIsSet()) attributes.add("channel");
      if (!textIsSet()) attributes.add("text");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ChatUpdateMessageResponse, some of required attributes are not set " + attributes;
    }
  }
}
