package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatGetPermalinkResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatGetPermalinkResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatGetPermalinkResponseIF"})
@Immutable
public final class ChatGetPermalinkResponse
    implements ChatGetPermalinkResponseIF {
  private final String channel;
  private final String permalink;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ChatGetPermalinkResponse(
      String channel,
      String permalink,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.channel = channel;
    this.permalink = permalink;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public String getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code permalink} attribute
   */
  @JsonProperty
  @Override
  public String getPermalink() {
    return permalink;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatGetPermalinkResponseIF#getChannel() channel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final ChatGetPermalinkResponse withChannel(String channel) {
    if (this.channel.equals(channel)) return this;
    String newValue = Objects.requireNonNull(channel, "channel");
    return new ChatGetPermalinkResponse(newValue, this.permalink, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatGetPermalinkResponseIF#getPermalink() permalink} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param permalink A new value for permalink
   * @return A modified copy of the {@code this} object
   */
  public final ChatGetPermalinkResponse withPermalink(String permalink) {
    if (this.permalink.equals(permalink)) return this;
    String newValue = Objects.requireNonNull(permalink, "permalink");
    return new ChatGetPermalinkResponse(this.channel, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatGetPermalinkResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ChatGetPermalinkResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ChatGetPermalinkResponse(this.channel, this.permalink, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatGetPermalinkResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatGetPermalinkResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ChatGetPermalinkResponse(this.channel, this.permalink, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatGetPermalinkResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ChatGetPermalinkResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ChatGetPermalinkResponse(this.channel, this.permalink, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ChatGetPermalinkResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatGetPermalinkResponse
        && equalTo((ChatGetPermalinkResponse) another);
  }

  private boolean equalTo(ChatGetPermalinkResponse another) {
    return channel.equals(another.channel)
        && permalink.equals(another.permalink)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code channel}, {@code permalink}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channel.hashCode();
    h = h * 17 + permalink.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatGetPermalinkResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatGetPermalinkResponse{");
    builder.append("channel=").append(channel);
    builder.append(", ");
    builder.append("permalink=").append(permalink);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatGetPermalinkResponseIF {
    @Nullable String channel;
    @Nullable String permalink;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setChannel(String channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setPermalink(String permalink) {
      this.permalink = permalink;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public String getPermalink() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatGetPermalinkResponse fromJson(Json json) {
    ChatGetPermalinkResponse.Builder builder = ChatGetPermalinkResponse.builder();
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.permalink != null) {
      builder.setPermalink(json.permalink);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatGetPermalinkResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatGetPermalinkResponse instance
   */
  public static ChatGetPermalinkResponse copyOf(ChatGetPermalinkResponseIF instance) {
    if (instance instanceof ChatGetPermalinkResponse) {
      return (ChatGetPermalinkResponse) instance;
    }
    return ChatGetPermalinkResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatGetPermalinkResponse ChatGetPermalinkResponse}.
   * @return A new ChatGetPermalinkResponse builder
   */
  public static ChatGetPermalinkResponse.Builder builder() {
    return new ChatGetPermalinkResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChatGetPermalinkResponse ChatGetPermalinkResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL = 0x1L;
    private static final long INIT_BIT_PERMALINK = 0x2L;
    private static final long INIT_BIT_OK = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String channel;
    private @Nullable String permalink;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.chat.ChatGetPermalinkResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatGetPermalinkResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ChatGetPermalinkResponseIF) {
        ChatGetPermalinkResponseIF instance = (ChatGetPermalinkResponseIF) object;
        setChannel(instance.getChannel());
        setPermalink(instance.getPermalink());
      }
    }

    /**
     * Initializes the value for the {@link ChatGetPermalinkResponseIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(String channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatGetPermalinkResponseIF#getPermalink() permalink} attribute.
     * @param permalink The value for permalink 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalink(String permalink) {
      this.permalink = Objects.requireNonNull(permalink, "permalink");
      initBits &= ~INIT_BIT_PERMALINK;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatGetPermalinkResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatGetPermalinkResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatGetPermalinkResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChatGetPermalinkResponse ChatGetPermalinkResponse}.
     * @return An immutable instance of ChatGetPermalinkResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatGetPermalinkResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatGetPermalinkResponse(channel, permalink, ok, responseMetadata);
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean permalinkIsSet() {
      return (initBits & INIT_BIT_PERMALINK) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIsSet()) attributes.add("channel");
      if (!permalinkIsSet()) attributes.add("permalink");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ChatGetPermalinkResponse, some of required attributes are not set " + attributes;
    }
  }
}
