package com.hubspot.slack.client.models.response.chat;

import org.immutables.value.Value.Immutable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.response.SlackResponse;

@Immutable
@HubSpotStyle
@JsonNaming(SnakeCaseStrategy.class)
public interface ChatDeleteResponseIF extends SlackResponse {
  @JsonProperty("channel")
  String getChannelId();

  @JsonProperty("ts")
  String getDeletedMessageTs();
}
