package com.hubspot.slack.client.models.response.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractChannelsHistoryResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsHistoryResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractChannelsHistoryResponse"})
@Immutable
public final class ChannelsHistoryResponse
    extends AbstractChannelsHistoryResponse {
  private final boolean hasMore;
  private final List<LiteMessage> messages;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;
  private final @Nullable Boolean inclusive;
  private final @Nullable String newestTimestamp;
  private final @Nullable String oldestTimestamp;
  private final PagingDirection pagingDirection;

  private ChannelsHistoryResponse(
      boolean hasMore,
      List<LiteMessage> messages,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata,
      @Nullable Boolean inclusive,
      @Nullable String newestTimestamp,
      @Nullable String oldestTimestamp) {
    this.hasMore = hasMore;
    this.messages = messages;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
    this.inclusive = inclusive;
    this.newestTimestamp = newestTimestamp;
    this.oldestTimestamp = oldestTimestamp;
    this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
  }

  /**
   * @return The value of the {@code hasMore} attribute
   */
  @JsonProperty("has_more")
  @Override
  public boolean hasMore() {
    return hasMore;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @JsonProperty
  @Override
  public List<LiteMessage> getMessages() {
    return messages;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * @return The value of the {@code inclusive} attribute
   */
  @JsonProperty("inclusive")
  @Override
  public Optional<Boolean> isInclusive() {
    return Optional.ofNullable(inclusive);
  }

  /**
   * @return The value of the {@code newestTimestamp} attribute
   */
  @JsonProperty("latest")
  @Override
  public Optional<String> getNewestTimestamp() {
    return Optional.ofNullable(newestTimestamp);
  }

  /**
   * @return The value of the {@code oldestTimestamp} attribute
   */
  @JsonProperty("oldest")
  @Override
  public Optional<String> getOldestTimestamp() {
    return Optional.ofNullable(oldestTimestamp);
  }

  /**
   * @return The computed-at-construction value of the {@code pagingDirection} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public PagingDirection getPagingDirection() {
    return pagingDirection;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChannelsHistoryResponse#hasMore() hasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param hasMore A new value for hasMore
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsHistoryResponse withHasMore(boolean hasMore) {
    if (this.hasMore == hasMore) return this;
    return new ChannelsHistoryResponse(
        hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractChannelsHistoryResponse#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withMessages(LiteMessage... elements) {
    List<LiteMessage> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ChannelsHistoryResponse(
        this.hasMore,
        newValue,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractChannelsHistoryResponse#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withMessages(Iterable<? extends LiteMessage> elements) {
    if (this.messages == elements) return this;
    List<LiteMessage> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ChannelsHistoryResponse(
        this.hasMore,
        newValue,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChannelsHistoryResponse#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsHistoryResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryResponse#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        newValue,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryResponse#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        value,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryResponse#isInclusive() inclusive} attribute.
   * @param value The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withInclusive(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.inclusive, newValue)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        newValue,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryResponse#isInclusive() inclusive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for inclusive
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withInclusive(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.inclusive, value)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        value,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryResponse#getNewestTimestamp() newestTimestamp} attribute.
   * @param value The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withNewestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.newestTimestamp, newValue)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        newValue,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryResponse#getNewestTimestamp() newestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for newestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withNewestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.newestTimestamp, value)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        value,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryResponse#getOldestTimestamp() oldestTimestamp} attribute.
   * @param value The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withOldestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.oldestTimestamp, newValue)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryResponse#getOldestTimestamp() oldestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oldestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryResponse withOldestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.oldestTimestamp, value)) return this;
    return new ChannelsHistoryResponse(
        this.hasMore,
        this.messages,
        this.ok,
        this.responseMetadata,
        this.inclusive,
        this.newestTimestamp,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ChannelsHistoryResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsHistoryResponse
        && equalTo((ChannelsHistoryResponse) another);
  }

  private boolean equalTo(ChannelsHistoryResponse another) {
    return hasMore == another.hasMore
        && messages.equals(another.messages)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata)
        && Objects.equals(inclusive, another.inclusive)
        && Objects.equals(newestTimestamp, another.newestTimestamp)
        && Objects.equals(oldestTimestamp, another.oldestTimestamp)
        && pagingDirection.equals(another.pagingDirection);
  }

  /**
   * Computes a hash code from attributes: {@code hasMore}, {@code messages}, {@code ok}, {@code responseMetadata}, {@code inclusive}, {@code newestTimestamp}, {@code oldestTimestamp}, {@code pagingDirection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Boolean.hashCode(hasMore);
    h = h * 17 + messages.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    h = h * 17 + Objects.hashCode(inclusive);
    h = h * 17 + Objects.hashCode(newestTimestamp);
    h = h * 17 + Objects.hashCode(oldestTimestamp);
    h = h * 17 + pagingDirection.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsHistoryResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelsHistoryResponse{");
    builder.append("hasMore=").append(hasMore);
    builder.append(", ");
    builder.append("messages=").append(messages);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    if (inclusive != null) {
      builder.append(", ");
      builder.append("inclusive=").append(inclusive);
    }
    if (newestTimestamp != null) {
      builder.append(", ");
      builder.append("newestTimestamp=").append(newestTimestamp);
    }
    if (oldestTimestamp != null) {
      builder.append(", ");
      builder.append("oldestTimestamp=").append(oldestTimestamp);
    }
    builder.append(", ");
    builder.append("pagingDirection=").append(pagingDirection);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractChannelsHistoryResponse {
    boolean hasMore;
    boolean hasMoreIsSet;
    List<LiteMessage> messages = Collections.emptyList();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    Optional<Boolean> inclusive = Optional.empty();
    Optional<String> newestTimestamp = Optional.empty();
    Optional<String> oldestTimestamp = Optional.empty();
    @JsonProperty("has_more")
    public void setHasMore(boolean hasMore) {
      this.hasMore = hasMore;
      this.hasMoreIsSet = true;
    }
    @JsonProperty
    public void setMessages(List<LiteMessage> messages) {
      this.messages = messages;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @JsonProperty("inclusive")
    public void setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive;
    }
    @JsonProperty("latest")
    public void setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
    }
    @JsonProperty("oldest")
    public void setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
    }
    @Override
    public boolean hasMore() { throw new UnsupportedOperationException(); }
    @Override
    public List<LiteMessage> getMessages() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isInclusive() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNewestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOldestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public PagingDirection getPagingDirection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsHistoryResponse fromJson(Json json) {
    ChannelsHistoryResponse.Builder builder = ChannelsHistoryResponse.builder();
    if (json.hasMoreIsSet) {
      builder.setHasMore(json.hasMore);
    }
    if (json.messages != null) {
      builder.addAllMessages(json.messages);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    if (json.inclusive != null) {
      builder.setInclusive(json.inclusive);
    }
    if (json.newestTimestamp != null) {
      builder.setNewestTimestamp(json.newestTimestamp);
    }
    if (json.oldestTimestamp != null) {
      builder.setOldestTimestamp(json.oldestTimestamp);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractChannelsHistoryResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsHistoryResponse instance
   */
  public static ChannelsHistoryResponse copyOf(AbstractChannelsHistoryResponse instance) {
    if (instance instanceof ChannelsHistoryResponse) {
      return (ChannelsHistoryResponse) instance;
    }
    return ChannelsHistoryResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsHistoryResponse ChannelsHistoryResponse}.
   * @return A new ChannelsHistoryResponse builder
   */
  public static ChannelsHistoryResponse.Builder builder() {
    return new ChannelsHistoryResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsHistoryResponse ChannelsHistoryResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HAS_MORE = 0x1L;
    private static final long INIT_BIT_OK = 0x2L;
    private long initBits = 0x3L;

    private boolean hasMore;
    private List<LiteMessage> messages = new ArrayList<LiteMessage>();
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;
    private @Nullable Boolean inclusive;
    private @Nullable String newestTimestamp;
    private @Nullable String oldestTimestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.channels.AbstractChannelsHistoryResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChannelsHistoryResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.TimeIntervalFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TimeIntervalFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof AbstractChannelsHistoryResponse) {
        AbstractChannelsHistoryResponse instance = (AbstractChannelsHistoryResponse) object;
        setHasMore(instance.hasMore());
        addAllMessages(instance.getMessages());
      }
      if (object instanceof TimeIntervalFilter) {
        TimeIntervalFilter instance = (TimeIntervalFilter) object;
        Optional<String> oldestTimestampOptional = instance.getOldestTimestamp();
        if (oldestTimestampOptional.isPresent()) {
          setOldestTimestamp(oldestTimestampOptional);
        }
        Optional<Boolean> inclusiveOptional = instance.isInclusive();
        if (inclusiveOptional.isPresent()) {
          setInclusive(inclusiveOptional);
        }
        Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
        if (newestTimestampOptional.isPresent()) {
          setNewestTimestamp(newestTimestampOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractChannelsHistoryResponse#hasMore() hasMore} attribute.
     * @param hasMore The value for hasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHasMore(boolean hasMore) {
      this.hasMore = hasMore;
      initBits &= ~INIT_BIT_HAS_MORE;
      return this;
    }

    /**
     * Adds one element to {@link AbstractChannelsHistoryResponse#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessages(LiteMessage element) {
      this.messages.add(Objects.requireNonNull(element, "messages element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractChannelsHistoryResponse#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessages(LiteMessage... elements) {
      for (LiteMessage element : elements) {
        this.messages.add(Objects.requireNonNull(element, "messages element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractChannelsHistoryResponse#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
      this.messages.clear();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link AbstractChannelsHistoryResponse#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
      for (LiteMessage element : elements) {
        this.messages.add(Objects.requireNonNull(element, "messages element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractChannelsHistoryResponse#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInclusive(@Nullable Boolean inclusive) {
      this.inclusive = inclusive;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryResponse#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChannelsHistoryResponse ChannelsHistoryResponse}.
     * @return An immutable instance of ChannelsHistoryResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsHistoryResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChannelsHistoryResponse(
          hasMore,
          createUnmodifiableList(true, messages),
          ok,
          responseMetadata,
          inclusive,
          newestTimestamp,
          oldestTimestamp);
    }

    private boolean hasMoreIsSet() {
      return (initBits & INIT_BIT_HAS_MORE) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!hasMoreIsSet()) attributes.add("hasMore");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ChannelsHistoryResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
