package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackErrorResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackErrorResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackErrorResponseIF"})
@Immutable
public final class SlackErrorResponse implements SlackErrorResponseIF {
  private final @Nullable SlackError error;
  private final List<SlackError> errors;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private SlackErrorResponse(
      @Nullable SlackError error,
      List<SlackError> errors,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.error = error;
    this.errors = errors;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackError> getError() {
    return Optional.ofNullable(error);
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty
  @Override
  public List<SlackError> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackErrorResponseIF#getError() error} attribute.
   * @param value The value for error, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withError(@Nullable SlackError value) {
    @Nullable SlackError newValue = value;
    if (this.error == newValue) return this;
    return new SlackErrorResponse(newValue, this.errors, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackErrorResponseIF#getError() error} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for error
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withError(Optional<SlackError> optional) {
    @Nullable SlackError value = optional.orElse(null);
    if (this.error == value) return this;
    return new SlackErrorResponse(value, this.errors, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackErrorResponseIF#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withErrors(SlackError... elements) {
    List<SlackError> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackErrorResponse(this.error, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackErrorResponseIF#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withErrors(Iterable<? extends SlackError> elements) {
    if (this.errors == elements) return this;
    List<SlackError> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackErrorResponse(this.error, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackErrorResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final SlackErrorResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new SlackErrorResponse(this.error, this.errors, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackErrorResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new SlackErrorResponse(this.error, this.errors, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackErrorResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final SlackErrorResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new SlackErrorResponse(this.error, this.errors, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code SlackErrorResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackErrorResponse
        && equalTo((SlackErrorResponse) another);
  }

  private boolean equalTo(SlackErrorResponse another) {
    return Objects.equals(error, another.error)
        && errors.equals(another.errors)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code error}, {@code errors}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(error);
    h = h * 17 + errors.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackErrorResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackErrorResponse{");
    if (error != null) {
      builder.append("error=").append(error);
    }
    if (builder.length() > 19) builder.append(", ");
    builder.append("errors=").append(errors);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackErrorResponseIF {
    Optional<SlackError> error = Optional.empty();
    List<SlackError> errors = Collections.emptyList();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setError(Optional<SlackError> error) {
      this.error = error;
    }
    @JsonProperty
    public void setErrors(List<SlackError> errors) {
      this.errors = errors;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public Optional<SlackError> getError() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackError> getErrors() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackErrorResponse fromJson(Json json) {
    SlackErrorResponse.Builder builder = SlackErrorResponse.builder();
    if (json.error != null) {
      builder.setError(json.error);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackErrorResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackErrorResponse instance
   */
  public static SlackErrorResponse copyOf(SlackErrorResponseIF instance) {
    if (instance instanceof SlackErrorResponse) {
      return (SlackErrorResponse) instance;
    }
    return SlackErrorResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackErrorResponse SlackErrorResponse}.
   * @return A new SlackErrorResponse builder
   */
  public static SlackErrorResponse.Builder builder() {
    return new SlackErrorResponse.Builder();
  }

  /**
   * Builds instances of type {@link SlackErrorResponse SlackErrorResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OK = 0x1L;
    private long initBits = 0x1L;

    private @Nullable SlackError error;
    private List<SlackError> errors = new ArrayList<SlackError>();
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackErrorResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackErrorResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackErrorResponseIF) {
        SlackErrorResponseIF instance = (SlackErrorResponseIF) object;
        Optional<SlackError> errorOptional = instance.getError();
        if (errorOptional.isPresent()) {
          setError(errorOptional);
        }
        addAllErrors(instance.getErrors());
      }
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link SlackErrorResponseIF#getError() error} to error.
     * @param error The value for error, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setError(@Nullable SlackError error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackErrorResponseIF#getError() error} to error.
     * @param error The value for error
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setError(Optional<SlackError> error) {
      this.error = error.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link SlackErrorResponseIF#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(SlackError element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackErrorResponseIF#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(SlackError... elements) {
      for (SlackError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackErrorResponseIF#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setErrors(Iterable<? extends SlackError> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link SlackErrorResponseIF#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends SlackError> elements) {
      for (SlackError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackErrorResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackErrorResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackErrorResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackErrorResponse SlackErrorResponse}.
     * @return An immutable instance of SlackErrorResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackErrorResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackErrorResponse(error, createUnmodifiableList(true, errors), ok, responseMetadata);
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build SlackErrorResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
