package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackErrorIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackError.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code SlackError.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackErrorIF"})
@Immutable
public final class SlackError implements SlackErrorIF {
  private final SlackErrorType type;
  private final String error;

  private SlackError(String error) {
    this.error = Objects.requireNonNull(error, "error");
    this.type = Objects.requireNonNull(SlackErrorIF.super.getType(), "type");
  }

  private SlackError(SlackError.Builder builder) {
    this.error = builder.error;
    this.type = builder.type != null
        ? builder.type
        : Objects.requireNonNull(SlackErrorIF.super.getType(), "type");
  }

  private SlackError(SlackErrorType type, String error) {
    this.type = type;
    this.error = error;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackErrorType getType() {
    return type;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty
  @Override
  public String getError() {
    return error;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackErrorIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackError withType(SlackErrorType type) {
    if (this.type == type) return this;
    SlackErrorType newValue = Objects.requireNonNull(type, "type");
    return new SlackError(newValue, this.error);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackErrorIF#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param error A new value for error
   * @return A modified copy of the {@code this} object
   */
  public final SlackError withError(String error) {
    if (this.error.equals(error)) return this;
    String newValue = Objects.requireNonNull(error, "error");
    return new SlackError(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackError
        && equalTo((SlackError) another);
  }

  private boolean equalTo(SlackError another) {
    return type.equals(another.type)
        && error.equals(another.error);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code error}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + error.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackError{"
        + "type=" + type
        + ", error=" + error
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackErrorIF {
    @Nullable SlackErrorType type;
    @Nullable String error;
    @JsonProperty
    public void setType(SlackErrorType type) {
      this.type = type;
    }
    @JsonProperty
    public void setError(String error) {
      this.error = error;
    }
    @Override
    public SlackErrorType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackError fromJson(Json json) {
    SlackError.Builder builder = SlackError.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.error != null) {
      builder.setError(json.error);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code SlackError} instance.
   * @param error The value for the {@code error} attribute
   * @return An immutable SlackError instance
   */
  public static SlackError of(String error) {
    return new SlackError(error);
  }

  /**
   * Creates an immutable copy of a {@link SlackErrorIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackError instance
   */
  public static SlackError copyOf(SlackErrorIF instance) {
    if (instance instanceof SlackError) {
      return (SlackError) instance;
    }
    return SlackError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackError SlackError}.
   * @return A new SlackError builder
   */
  public static SlackError.Builder builder() {
    return new SlackError.Builder();
  }

  /**
   * Builds instances of type {@link SlackError SlackError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ERROR = 0x1L;
    private long initBits = 0x1L;

    private @Nullable SlackErrorType type;
    private @Nullable String error;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackErrorIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackErrorIF instance) {
      Objects.requireNonNull(instance, "instance");
      setType(instance.getType());
      setError(instance.getError());
      return this;
    }

    /**
     * Initializes the value for the {@link SlackErrorIF#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackErrorIF#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackErrorType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackErrorIF#getError() error} attribute.
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setError(String error) {
      this.error = Objects.requireNonNull(error, "error");
      initBits &= ~INIT_BIT_ERROR;
      return this;
    }

    /**
     * Builds a new {@link SlackError SlackError}.
     * @return An immutable instance of SlackError
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackError build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackError(this);
    }

    private boolean errorIsSet() {
      return (initBits & INIT_BIT_ERROR) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!errorIsSet()) attributes.add("error");
      return "Cannot build SlackError, some of required attributes are not set " + attributes;
    }
  }
}
