package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link MessagePageIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MessagePage.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "MessagePageIF"})
@Immutable
public final class MessagePage implements MessagePageIF {
  private final int total;
  private final Paging paging;
  private final List<Message> matches;

  private MessagePage(int total, Paging paging, List<Message> matches) {
    this.total = total;
    this.paging = paging;
    this.matches = matches;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty
  @Override
  public int getTotal() {
    return total;
  }

  /**
   * @return The value of the {@code paging} attribute
   */
  @JsonProperty
  @Override
  public Paging getPaging() {
    return paging;
  }

  /**
   * @return The value of the {@code matches} attribute
   */
  @JsonProperty
  @Override
  public List<Message> getMatches() {
    return matches;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessagePageIF#getTotal() total} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param total A new value for total
   * @return A modified copy of the {@code this} object
   */
  public final MessagePage withTotal(int total) {
    if (this.total == total) return this;
    return new MessagePage(total, this.paging, this.matches);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessagePageIF#getPaging() paging} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param paging A new value for paging
   * @return A modified copy of the {@code this} object
   */
  public final MessagePage withPaging(Paging paging) {
    if (this.paging == paging) return this;
    Paging newValue = Objects.requireNonNull(paging, "paging");
    return new MessagePage(this.total, newValue, this.matches);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessagePageIF#getMatches() matches}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessagePage withMatches(Message... elements) {
    List<Message> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new MessagePage(this.total, this.paging, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessagePageIF#getMatches() matches}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of matches elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessagePage withMatches(Iterable<? extends Message> elements) {
    if (this.matches == elements) return this;
    List<Message> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new MessagePage(this.total, this.paging, newValue);
  }

  /**
   * This instance is equal to all instances of {@code MessagePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MessagePage
        && equalTo((MessagePage) another);
  }

  private boolean equalTo(MessagePage another) {
    return total == another.total
        && paging.equals(another.paging)
        && matches.equals(another.matches);
  }

  /**
   * Computes a hash code from attributes: {@code total}, {@code paging}, {@code matches}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + total;
    h = h * 17 + paging.hashCode();
    h = h * 17 + matches.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessagePage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessagePage{"
        + "total=" + total
        + ", paging=" + paging
        + ", matches=" + matches
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MessagePageIF {
    int total;
    boolean totalIsSet;
    @Nullable Paging paging;
    List<Message> matches = Collections.emptyList();
    @JsonProperty
    public void setTotal(int total) {
      this.total = total;
      this.totalIsSet = true;
    }
    @JsonProperty
    public void setPaging(Paging paging) {
      this.paging = paging;
    }
    @JsonProperty
    public void setMatches(List<Message> matches) {
      this.matches = matches;
    }
    @Override
    public int getTotal() { throw new UnsupportedOperationException(); }
    @Override
    public Paging getPaging() { throw new UnsupportedOperationException(); }
    @Override
    public List<Message> getMatches() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static MessagePage fromJson(Json json) {
    MessagePage.Builder builder = MessagePage.builder();
    if (json.totalIsSet) {
      builder.setTotal(json.total);
    }
    if (json.paging != null) {
      builder.setPaging(json.paging);
    }
    if (json.matches != null) {
      builder.addAllMatches(json.matches);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MessagePageIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessagePage instance
   */
  public static MessagePage copyOf(MessagePageIF instance) {
    if (instance instanceof MessagePage) {
      return (MessagePage) instance;
    }
    return MessagePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link MessagePage MessagePage}.
   * @return A new MessagePage builder
   */
  public static MessagePage.Builder builder() {
    return new MessagePage.Builder();
  }

  /**
   * Builds instances of type {@link MessagePage MessagePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL = 0x1L;
    private static final long INIT_BIT_PAGING = 0x2L;
    private long initBits = 0x3L;

    private int total;
    private @Nullable Paging paging;
    private List<Message> matches = new ArrayList<Message>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MessagePageIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessagePageIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTotal(instance.getTotal());
      setPaging(instance.getPaging());
      addAllMatches(instance.getMatches());
      return this;
    }

    /**
     * Initializes the value for the {@link MessagePageIF#getTotal() total} attribute.
     * @param total The value for total 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTotal(int total) {
      this.total = total;
      initBits &= ~INIT_BIT_TOTAL;
      return this;
    }

    /**
     * Initializes the value for the {@link MessagePageIF#getPaging() paging} attribute.
     * @param paging The value for paging 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPaging(Paging paging) {
      this.paging = Objects.requireNonNull(paging, "paging");
      initBits &= ~INIT_BIT_PAGING;
      return this;
    }

    /**
     * Adds one element to {@link MessagePageIF#getMatches() matches} list.
     * @param element A matches element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMatches(Message element) {
      this.matches.add(Objects.requireNonNull(element, "matches element"));
      return this;
    }

    /**
     * Adds elements to {@link MessagePageIF#getMatches() matches} list.
     * @param elements An array of matches elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMatches(Message... elements) {
      for (Message element : elements) {
        this.matches.add(Objects.requireNonNull(element, "matches element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link MessagePageIF#getMatches() matches} list.
     * @param elements An iterable of matches elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMatches(Iterable<? extends Message> elements) {
      this.matches.clear();
      return addAllMatches(elements);
    }

    /**
     * Adds elements to {@link MessagePageIF#getMatches() matches} list.
     * @param elements An iterable of matches elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMatches(Iterable<? extends Message> elements) {
      for (Message element : elements) {
        this.matches.add(Objects.requireNonNull(element, "matches element"));
      }
      return this;
    }

    /**
     * Builds a new {@link MessagePage MessagePage}.
     * @return An immutable instance of MessagePage
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public MessagePage build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new MessagePage(total, paging, createUnmodifiableList(true, matches));
    }

    private boolean totalIsSet() {
      return (initBits & INIT_BIT_TOTAL) == 0;
    }

    private boolean pagingIsSet() {
      return (initBits & INIT_BIT_PAGING) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!totalIsSet()) attributes.add("total");
      if (!pagingIsSet()) attributes.add("paging");
      return "Cannot build MessagePage, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
