package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.Option;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewRadioButtonGroupIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewRadioButtonGroup.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewRadioButtonGroupIF"})
@Immutable
public final class ViewRadioButtonGroup
    implements ViewRadioButtonGroupIF {
  private final @Nullable Option selectedOption;
  private final ViewInputType type;

  private ViewRadioButtonGroup(
      @Nullable Option selectedOption,
      ViewInputType type) {
    this.selectedOption = selectedOption;
    this.type = type;
  }

  /**
   * @return The value of the {@code selectedOption} attribute
   */
  @JsonProperty
  @JsonDeserialize(contentUsing = OptionOrOptionGroupDeserializer.class)
  @Override
  public Optional<Option> getSelectedOption() {
    return Optional.ofNullable(selectedOption);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ViewInputType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewRadioButtonGroupIF#getSelectedOption() selectedOption} attribute.
   * @param value The value for selectedOption, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewRadioButtonGroup withSelectedOption(@Nullable Option value) {
    @Nullable Option newValue = value;
    if (this.selectedOption == newValue) return this;
    return new ViewRadioButtonGroup(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewRadioButtonGroupIF#getSelectedOption() selectedOption} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for selectedOption
   * @return A modified copy of {@code this} object
   */
  public final ViewRadioButtonGroup withSelectedOption(Optional<Option> optional) {
    @Nullable Option value = optional.orElse(null);
    if (this.selectedOption == value) return this;
    return new ViewRadioButtonGroup(value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewRadioButtonGroupIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewRadioButtonGroup withType(ViewInputType type) {
    if (this.type == type) return this;
    ViewInputType newValue = Objects.requireNonNull(type, "type");
    return new ViewRadioButtonGroup(this.selectedOption, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewRadioButtonGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewRadioButtonGroup
        && equalTo((ViewRadioButtonGroup) another);
  }

  private boolean equalTo(ViewRadioButtonGroup another) {
    return Objects.equals(selectedOption, another.selectedOption)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code selectedOption}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(selectedOption);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewRadioButtonGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ViewRadioButtonGroup{");
    if (selectedOption != null) {
      builder.append("selectedOption=").append(selectedOption);
    }
    if (builder.length() > 21) builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewRadioButtonGroupIF {
    Optional<Option> selectedOption = Optional.empty();
    @Nullable ViewInputType type;
    @JsonProperty
    @JsonDeserialize(contentUsing = OptionOrOptionGroupDeserializer.class)
    public void setSelectedOption(Optional<Option> selectedOption) {
      this.selectedOption = selectedOption;
    }
    @JsonProperty
    public void setType(ViewInputType type) {
      this.type = type;
    }
    @Override
    public Optional<Option> getSelectedOption() { throw new UnsupportedOperationException(); }
    @Override
    public ViewInputType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewRadioButtonGroup fromJson(Json json) {
    ViewRadioButtonGroup.Builder builder = ViewRadioButtonGroup.builder();
    if (json.selectedOption != null) {
      builder.setSelectedOption(json.selectedOption);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewRadioButtonGroupIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewRadioButtonGroup instance
   */
  public static ViewRadioButtonGroup copyOf(ViewRadioButtonGroupIF instance) {
    if (instance instanceof ViewRadioButtonGroup) {
      return (ViewRadioButtonGroup) instance;
    }
    return ViewRadioButtonGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewRadioButtonGroup ViewRadioButtonGroup}.
   * @return A new ViewRadioButtonGroup builder
   */
  public static ViewRadioButtonGroup.Builder builder() {
    return new ViewRadioButtonGroup.Builder();
  }

  /**
   * Builds instances of type {@link ViewRadioButtonGroup ViewRadioButtonGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Option selectedOption;
    private @Nullable ViewInputType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewRadioButtonGroupIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewRadioButtonGroupIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewInput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewInput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewRadioButtonGroupIF) {
        ViewRadioButtonGroupIF instance = (ViewRadioButtonGroupIF) object;
        Optional<Option> selectedOptionOptional = instance.getSelectedOption();
        if (selectedOptionOptional.isPresent()) {
          setSelectedOption(selectedOptionOptional);
        }
      }
      if (object instanceof ViewInput) {
        ViewInput instance = (ViewInput) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the optional value {@link ViewRadioButtonGroupIF#getSelectedOption() selectedOption} to selectedOption.
     * @param selectedOption The value for selectedOption, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSelectedOption(@Nullable Option selectedOption) {
      this.selectedOption = selectedOption;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewRadioButtonGroupIF#getSelectedOption() selectedOption} to selectedOption.
     * @param selectedOption The value for selectedOption
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedOption(Optional<Option> selectedOption) {
      this.selectedOption = selectedOption.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ViewRadioButtonGroupIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ViewInputType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ViewRadioButtonGroup ViewRadioButtonGroup}.
     * @return An immutable instance of ViewRadioButtonGroup
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewRadioButtonGroup build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewRadioButtonGroup(selectedOption, type);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ViewRadioButtonGroup, some of required attributes are not set " + attributes;
    }
  }
}
