package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewPlainTextInputIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewPlainTextInput.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewPlainTextInputIF"})
@Immutable
public final class ViewPlainTextInput
    implements ViewPlainTextInputIF {
  private final @Nullable String value;
  private final ViewInputType type;

  private ViewPlainTextInput(
      @Nullable String value,
      ViewInputType type) {
    this.value = value;
    this.type = type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ViewInputType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewPlainTextInputIF#getValue() value} attribute.
   * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewPlainTextInput withValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.value, newValue)) return this;
    return new ViewPlainTextInput(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewPlainTextInputIF#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final ViewPlainTextInput withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return new ViewPlainTextInput(value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewPlainTextInputIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewPlainTextInput withType(ViewInputType type) {
    if (this.type == type) return this;
    ViewInputType newValue = Objects.requireNonNull(type, "type");
    return new ViewPlainTextInput(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewPlainTextInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewPlainTextInput
        && equalTo((ViewPlainTextInput) another);
  }

  private boolean equalTo(ViewPlainTextInput another) {
    return Objects.equals(value, another.value)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(value);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewPlainTextInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ViewPlainTextInput{");
    if (value != null) {
      builder.append("value=").append(value);
    }
    if (builder.length() > 19) builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewPlainTextInputIF {
    Optional<String> value = Optional.empty();
    @Nullable ViewInputType type;
    @JsonProperty
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty
    public void setType(ViewInputType type) {
      this.type = type;
    }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public ViewInputType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewPlainTextInput fromJson(Json json) {
    ViewPlainTextInput.Builder builder = ViewPlainTextInput.builder();
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewPlainTextInputIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewPlainTextInput instance
   */
  public static ViewPlainTextInput copyOf(ViewPlainTextInputIF instance) {
    if (instance instanceof ViewPlainTextInput) {
      return (ViewPlainTextInput) instance;
    }
    return ViewPlainTextInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewPlainTextInput ViewPlainTextInput}.
   * @return A new ViewPlainTextInput builder
   */
  public static ViewPlainTextInput.Builder builder() {
    return new ViewPlainTextInput.Builder();
  }

  /**
   * Builds instances of type {@link ViewPlainTextInput ViewPlainTextInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;
    private @Nullable ViewInputType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewPlainTextInputIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewPlainTextInputIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewInput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewInput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewPlainTextInputIF) {
        ViewPlainTextInputIF instance = (ViewPlainTextInputIF) object;
        Optional<String> valueOptional = instance.getValue();
        if (valueOptional.isPresent()) {
          setValue(valueOptional);
        }
      }
      if (object instanceof ViewInput) {
        ViewInput instance = (ViewInput) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the optional value {@link ViewPlainTextInputIF#getValue() value} to value.
     * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewPlainTextInputIF#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ViewPlainTextInputIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ViewInputType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ViewPlainTextInput ViewPlainTextInput}.
     * @return An immutable instance of ViewPlainTextInput
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewPlainTextInput build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewPlainTextInput(value, type);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ViewPlainTextInput, some of required attributes are not set " + attributes;
    }
  }
}
