package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewDatePickerIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewDatePicker.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewDatePickerIF"})
@Immutable
public final class ViewDatePicker
    implements ViewDatePickerIF {
  private final @Nullable LocalDate selectedDate;
  private final ViewInputType type;

  private ViewDatePicker(
      @Nullable LocalDate selectedDate,
      ViewInputType type) {
    this.selectedDate = selectedDate;
    this.type = type;
  }

  /**
   * @return The value of the {@code selectedDate} attribute
   */
  @JsonProperty
  @Override
  public Optional<LocalDate> getSelectedDate() {
    return Optional.ofNullable(selectedDate);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ViewInputType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewDatePickerIF#getSelectedDate() selectedDate} attribute.
   * @param value The value for selectedDate, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewDatePicker withSelectedDate(@Nullable LocalDate value) {
    @Nullable LocalDate newValue = value;
    if (this.selectedDate == newValue) return this;
    return new ViewDatePicker(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewDatePickerIF#getSelectedDate() selectedDate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for selectedDate
   * @return A modified copy of {@code this} object
   */
  public final ViewDatePicker withSelectedDate(Optional<LocalDate> optional) {
    @Nullable LocalDate value = optional.orElse(null);
    if (this.selectedDate == value) return this;
    return new ViewDatePicker(value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewDatePickerIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewDatePicker withType(ViewInputType type) {
    if (this.type == type) return this;
    ViewInputType newValue = Objects.requireNonNull(type, "type");
    return new ViewDatePicker(this.selectedDate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewDatePicker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewDatePicker
        && equalTo((ViewDatePicker) another);
  }

  private boolean equalTo(ViewDatePicker another) {
    return Objects.equals(selectedDate, another.selectedDate)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code selectedDate}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(selectedDate);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewDatePicker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ViewDatePicker{");
    if (selectedDate != null) {
      builder.append("selectedDate=").append(selectedDate);
    }
    if (builder.length() > 15) builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewDatePickerIF {
    Optional<LocalDate> selectedDate = Optional.empty();
    @Nullable ViewInputType type;
    @JsonProperty
    public void setSelectedDate(Optional<LocalDate> selectedDate) {
      this.selectedDate = selectedDate;
    }
    @JsonProperty
    public void setType(ViewInputType type) {
      this.type = type;
    }
    @Override
    public Optional<LocalDate> getSelectedDate() { throw new UnsupportedOperationException(); }
    @Override
    public ViewInputType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewDatePicker fromJson(Json json) {
    ViewDatePicker.Builder builder = ViewDatePicker.builder();
    if (json.selectedDate != null) {
      builder.setSelectedDate(json.selectedDate);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewDatePickerIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewDatePicker instance
   */
  public static ViewDatePicker copyOf(ViewDatePickerIF instance) {
    if (instance instanceof ViewDatePicker) {
      return (ViewDatePicker) instance;
    }
    return ViewDatePicker.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewDatePicker ViewDatePicker}.
   * @return A new ViewDatePicker builder
   */
  public static ViewDatePicker.Builder builder() {
    return new ViewDatePicker.Builder();
  }

  /**
   * Builds instances of type {@link ViewDatePicker ViewDatePicker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable LocalDate selectedDate;
    private @Nullable ViewInputType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewDatePickerIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewDatePickerIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewInput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewInput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewDatePickerIF) {
        ViewDatePickerIF instance = (ViewDatePickerIF) object;
        Optional<LocalDate> selectedDateOptional = instance.getSelectedDate();
        if (selectedDateOptional.isPresent()) {
          setSelectedDate(selectedDateOptional);
        }
      }
      if (object instanceof ViewInput) {
        ViewInput instance = (ViewInput) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the optional value {@link ViewDatePickerIF#getSelectedDate() selectedDate} to selectedDate.
     * @param selectedDate The value for selectedDate, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSelectedDate(@Nullable LocalDate selectedDate) {
      this.selectedDate = selectedDate;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewDatePickerIF#getSelectedDate() selectedDate} to selectedDate.
     * @param selectedDate The value for selectedDate
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedDate(Optional<LocalDate> selectedDate) {
      this.selectedDate = selectedDate.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ViewDatePickerIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ViewInputType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ViewDatePicker ViewDatePicker}.
     * @return An immutable instance of ViewDatePicker
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewDatePicker build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewDatePicker(selectedDate, type);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ViewDatePicker, some of required attributes are not set " + attributes;
    }
  }
}
