package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsersSelectInputIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsersSelectInput.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsersSelectInputIF"})
@Immutable
public final class UsersSelectInput
    implements UsersSelectInputIF {
  private final @Nullable String selectedUser;
  private final ViewInputType type;

  private UsersSelectInput(
      @Nullable String selectedUser,
      ViewInputType type) {
    this.selectedUser = selectedUser;
    this.type = type;
  }

  /**
   * @return The value of the {@code selectedUser} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getSelectedUser() {
    return Optional.ofNullable(selectedUser);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ViewInputType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsersSelectInputIF#getSelectedUser() selectedUser} attribute.
   * @param value The value for selectedUser, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsersSelectInput withSelectedUser(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.selectedUser, newValue)) return this;
    return new UsersSelectInput(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsersSelectInputIF#getSelectedUser() selectedUser} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for selectedUser
   * @return A modified copy of {@code this} object
   */
  public final UsersSelectInput withSelectedUser(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.selectedUser, value)) return this;
    return new UsersSelectInput(value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersSelectInputIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final UsersSelectInput withType(ViewInputType type) {
    if (this.type == type) return this;
    ViewInputType newValue = Objects.requireNonNull(type, "type");
    return new UsersSelectInput(this.selectedUser, newValue);
  }

  /**
   * This instance is equal to all instances of {@code UsersSelectInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsersSelectInput
        && equalTo((UsersSelectInput) another);
  }

  private boolean equalTo(UsersSelectInput another) {
    return Objects.equals(selectedUser, another.selectedUser)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code selectedUser}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(selectedUser);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsersSelectInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsersSelectInput{");
    if (selectedUser != null) {
      builder.append("selectedUser=").append(selectedUser);
    }
    if (builder.length() > 17) builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsersSelectInputIF {
    Optional<String> selectedUser = Optional.empty();
    @Nullable ViewInputType type;
    @JsonProperty
    public void setSelectedUser(Optional<String> selectedUser) {
      this.selectedUser = selectedUser;
    }
    @JsonProperty
    public void setType(ViewInputType type) {
      this.type = type;
    }
    @Override
    public Optional<String> getSelectedUser() { throw new UnsupportedOperationException(); }
    @Override
    public ViewInputType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsersSelectInput fromJson(Json json) {
    UsersSelectInput.Builder builder = UsersSelectInput.builder();
    if (json.selectedUser != null) {
      builder.setSelectedUser(json.selectedUser);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsersSelectInputIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsersSelectInput instance
   */
  public static UsersSelectInput copyOf(UsersSelectInputIF instance) {
    if (instance instanceof UsersSelectInput) {
      return (UsersSelectInput) instance;
    }
    return UsersSelectInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsersSelectInput UsersSelectInput}.
   * @return A new UsersSelectInput builder
   */
  public static UsersSelectInput.Builder builder() {
    return new UsersSelectInput.Builder();
  }

  /**
   * Builds instances of type {@link UsersSelectInput UsersSelectInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String selectedUser;
    private @Nullable ViewInputType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.UsersSelectInputIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsersSelectInputIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.views.ViewInput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewInput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UsersSelectInputIF) {
        UsersSelectInputIF instance = (UsersSelectInputIF) object;
        Optional<String> selectedUserOptional = instance.getSelectedUser();
        if (selectedUserOptional.isPresent()) {
          setSelectedUser(selectedUserOptional);
        }
      }
      if (object instanceof ViewInput) {
        ViewInput instance = (ViewInput) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the optional value {@link UsersSelectInputIF#getSelectedUser() selectedUser} to selectedUser.
     * @param selectedUser The value for selectedUser, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSelectedUser(@Nullable String selectedUser) {
      this.selectedUser = selectedUser;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersSelectInputIF#getSelectedUser() selectedUser} to selectedUser.
     * @param selectedUser The value for selectedUser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedUser(Optional<String> selectedUser) {
      this.selectedUser = selectedUser.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link UsersSelectInputIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ViewInputType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link UsersSelectInput UsersSelectInput}.
     * @return An immutable instance of UsersSelectInput
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsersSelectInput build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsersSelectInput(selectedUser, type);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build UsersSelectInput, some of required attributes are not set " + attributes;
    }
  }
}
