package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewSubmissionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewSubmission.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewSubmissionIF"})
@Immutable
public final class ViewSubmission implements ViewSubmissionIF {
  private final ViewInteractionPayload view;
  private final InteractiveCallbackType type;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;

  private ViewSubmission(
      ViewInteractionPayload view,
      InteractiveCallbackType type,
      String token,
      SlackTeam team,
      SlackUserLite user) {
    this.view = view;
    this.type = type;
    this.token = token;
    this.team = team;
    this.user = user;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public ViewInteractionPayload getView() {
    return view;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewSubmissionIF#getView() view} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param view A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final ViewSubmission withView(ViewInteractionPayload view) {
    if (this.view == view) return this;
    ViewInteractionPayload newValue = Objects.requireNonNull(view, "view");
    return new ViewSubmission(newValue, this.type, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewSubmissionIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewSubmission withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new ViewSubmission(this.view, newValue, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewSubmissionIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ViewSubmission withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new ViewSubmission(this.view, this.type, newValue, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewSubmissionIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final ViewSubmission withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new ViewSubmission(this.view, this.type, this.token, newValue, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewSubmissionIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ViewSubmission withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new ViewSubmission(this.view, this.type, this.token, this.team, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewSubmission} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewSubmission
        && equalTo((ViewSubmission) another);
  }

  private boolean equalTo(ViewSubmission another) {
    return view.equals(another.view)
        && type.equals(another.type)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user);
  }

  /**
   * Computes a hash code from attributes: {@code view}, {@code type}, {@code token}, {@code team}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + view.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewSubmission} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewSubmission{"
        + "view=" + view
        + ", type=" + type
        + ", token=" + token
        + ", team=" + team
        + ", user=" + user
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewSubmissionIF {
    @Nullable ViewInteractionPayload view;
    @Nullable InteractiveCallbackType type;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @JsonProperty
    public void setView(ViewInteractionPayload view) {
      this.view = view;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @Override
    public ViewInteractionPayload getView() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewSubmission fromJson(Json json) {
    ViewSubmission.Builder builder = ViewSubmission.builder();
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewSubmissionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewSubmission instance
   */
  public static ViewSubmission copyOf(ViewSubmissionIF instance) {
    if (instance instanceof ViewSubmission) {
      return (ViewSubmission) instance;
    }
    return ViewSubmission.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewSubmission ViewSubmission}.
   * @return A new ViewSubmission builder
   */
  public static ViewSubmission.Builder builder() {
    return new ViewSubmission.Builder();
  }

  /**
   * Builds instances of type {@link ViewSubmission ViewSubmission}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VIEW = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_TOKEN = 0x4L;
    private static final long INIT_BIT_TEAM = 0x8L;
    private static final long INIT_BIT_USER = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable ViewInteractionPayload view;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.ViewSubmissionIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewSubmissionIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewSubmissionIF) {
        ViewSubmissionIF instance = (ViewSubmissionIF) object;
        setView(instance.getView());
      }
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setTeam(instance.getTeam());
        setType(instance.getType());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
    }

    /**
     * Initializes the value for the {@link ViewSubmissionIF#getView() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(ViewInteractionPayload view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewSubmissionIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewSubmissionIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewSubmissionIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewSubmissionIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Builds a new {@link ViewSubmission ViewSubmission}.
     * @return An immutable instance of ViewSubmission
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewSubmission build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewSubmission(view, type, token, team, user);
    }

    private boolean viewIsSet() {
      return (initBits & INIT_BIT_VIEW) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!viewIsSet()) attributes.add("view");
      if (!typeIsSet()) attributes.add("type");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      return "Cannot build ViewSubmission, some of required attributes are not set " + attributes;
    }
  }
}
