package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewStateValuesPayloadIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewStateValuesPayload.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewStateValuesPayloadIF"})
@Immutable
public final class ViewStateValuesPayload
    implements ViewStateValuesPayloadIF {
  private final Map<String, Map<String, ViewInput>> blockIdToActionIdToValues;

  private ViewStateValuesPayload(
      Map<String, Map<String, ViewInput>> blockIdToActionIdToValues) {
    this.blockIdToActionIdToValues = blockIdToActionIdToValues;
  }

  /**
   * @return The value of the {@code blockIdToActionIdToValues} attribute
   */
  @JsonProperty("values")
  @Override
  public Map<String, Map<String, ViewInput>> getBlockIdToActionIdToValues() {
    return blockIdToActionIdToValues;
  }

  /**
   * Copy the current immutable object by replacing the {@link ViewStateValuesPayloadIF#getBlockIdToActionIdToValues() blockIdToActionIdToValues} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param blockIdToActionIdToValues The entries to be added to the blockIdToActionIdToValues map
   * @return A modified copy of {@code this} object
   */
  public final ViewStateValuesPayload withBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
    if (this.blockIdToActionIdToValues == blockIdToActionIdToValues) return this;
    Map<String, Map<String, ViewInput>> newValue = createUnmodifiableMap(true, false, blockIdToActionIdToValues);
    return new ViewStateValuesPayload(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewStateValuesPayload} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewStateValuesPayload
        && equalTo((ViewStateValuesPayload) another);
  }

  private boolean equalTo(ViewStateValuesPayload another) {
    return blockIdToActionIdToValues.equals(another.blockIdToActionIdToValues);
  }

  /**
   * Computes a hash code from attributes: {@code blockIdToActionIdToValues}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + blockIdToActionIdToValues.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewStateValuesPayload} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewStateValuesPayload{"
        + "blockIdToActionIdToValues=" + blockIdToActionIdToValues
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewStateValuesPayloadIF {
    @Nullable Map<String, Map<String, ViewInput>> blockIdToActionIdToValues;
    @JsonProperty("values")
    public void setBlockIdToActionIdToValues(Map<String, Map<String, ViewInput>> blockIdToActionIdToValues) {
      this.blockIdToActionIdToValues = blockIdToActionIdToValues;
    }
    @Override
    public Map<String, Map<String, ViewInput>> getBlockIdToActionIdToValues() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewStateValuesPayload fromJson(Json json) {
    ViewStateValuesPayload.Builder builder = ViewStateValuesPayload.builder();
    if (json.blockIdToActionIdToValues != null) {
      builder.putAllBlockIdToActionIdToValues(json.blockIdToActionIdToValues);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewStateValuesPayloadIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewStateValuesPayload instance
   */
  public static ViewStateValuesPayload copyOf(ViewStateValuesPayloadIF instance) {
    if (instance instanceof ViewStateValuesPayload) {
      return (ViewStateValuesPayload) instance;
    }
    return ViewStateValuesPayload.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewStateValuesPayload ViewStateValuesPayload}.
   * @return A new ViewStateValuesPayload builder
   */
  public static ViewStateValuesPayload.Builder builder() {
    return new ViewStateValuesPayload.Builder();
  }

  /**
   * Builds instances of type {@link ViewStateValuesPayload ViewStateValuesPayload}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Map<String, Map<String, ViewInput>> blockIdToActionIdToValues = new LinkedHashMap<String, Map<String, ViewInput>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewStateValuesPayloadIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewStateValuesPayloadIF instance) {
      Objects.requireNonNull(instance, "instance");
      putAllBlockIdToActionIdToValues(instance.getBlockIdToActionIdToValues());
      return this;
    }

    /**
     * Put one entry to the {@link ViewStateValuesPayloadIF#getBlockIdToActionIdToValues() blockIdToActionIdToValues} map.
     * @param key The key in the blockIdToActionIdToValues map
     * @param value The associated value in the blockIdToActionIdToValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putBlockIdToActionIdToValues(String key, Map<String, ViewInput> value) {
      this.blockIdToActionIdToValues.put(
          Objects.requireNonNull(key, "blockIdToActionIdToValues key"),
          Objects.requireNonNull(value, "blockIdToActionIdToValues value"));
      return this;
    }

    /**
     * Put one entry to the {@link ViewStateValuesPayloadIF#getBlockIdToActionIdToValues() blockIdToActionIdToValues} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putBlockIdToActionIdToValues(Map.Entry<String, ? extends Map<String, ViewInput>> entry) {
      String k = entry.getKey();
      Map<String, ViewInput> v = entry.getValue();
      this.blockIdToActionIdToValues.put(
          Objects.requireNonNull(k, "blockIdToActionIdToValues key"),
          Objects.requireNonNull(v, "blockIdToActionIdToValues value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ViewStateValuesPayloadIF#getBlockIdToActionIdToValues() blockIdToActionIdToValues} map. Nulls are not permitted
     * @param blockIdToActionIdToValues The entries that will be added to the blockIdToActionIdToValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
      this.blockIdToActionIdToValues.clear();
      return putAllBlockIdToActionIdToValues(blockIdToActionIdToValues);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ViewStateValuesPayloadIF#getBlockIdToActionIdToValues() blockIdToActionIdToValues} map. Nulls are not permitted
     * @param blockIdToActionIdToValues The entries that will be added to the blockIdToActionIdToValues map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllBlockIdToActionIdToValues(Map<String, ? extends Map<String, ViewInput>> blockIdToActionIdToValues) {
      for (Map.Entry<String, ? extends Map<String, ViewInput>> entry : blockIdToActionIdToValues.entrySet()) {
        String k = entry.getKey();
        Map<String, ViewInput> v = entry.getValue();
        this.blockIdToActionIdToValues.put(
            Objects.requireNonNull(k, "blockIdToActionIdToValues key"),
            Objects.requireNonNull(v, "blockIdToActionIdToValues value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ViewStateValuesPayload ViewStateValuesPayload}.
     * @return An immutable instance of ViewStateValuesPayload
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewStateValuesPayload build() throws InvalidImmutableStateException {
      return new ViewStateValuesPayload(createUnmodifiableMap(false, false, blockIdToActionIdToValues));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
