package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewStateValuesBlockIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewStateValuesBlock.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewStateValuesBlockIF"})
@Immutable
public final class ViewStateValuesBlock
    implements ViewStateValuesBlockIF {
  private final String type;
  private final String value;

  private ViewStateValuesBlock(String type, String value) {
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewStateValuesBlockIF#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewStateValuesBlock withType(String type) {
    if (this.type.equals(type)) return this;
    String newValue = Objects.requireNonNull(type, "type");
    return new ViewStateValuesBlock(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewStateValuesBlockIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ViewStateValuesBlock withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new ViewStateValuesBlock(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewStateValuesBlock} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewStateValuesBlock
        && equalTo((ViewStateValuesBlock) another);
  }

  private boolean equalTo(ViewStateValuesBlock another) {
    return type.equals(another.type)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewStateValuesBlock} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewStateValuesBlock{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewStateValuesBlockIF {
    @Nullable String type;
    @Nullable String value;
    @JsonProperty
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewStateValuesBlock fromJson(Json json) {
    ViewStateValuesBlock.Builder builder = ViewStateValuesBlock.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewStateValuesBlockIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewStateValuesBlock instance
   */
  public static ViewStateValuesBlock copyOf(ViewStateValuesBlockIF instance) {
    if (instance instanceof ViewStateValuesBlock) {
      return (ViewStateValuesBlock) instance;
    }
    return ViewStateValuesBlock.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewStateValuesBlock ViewStateValuesBlock}.
   * @return A new ViewStateValuesBlock builder
   */
  public static ViewStateValuesBlock.Builder builder() {
    return new ViewStateValuesBlock.Builder();
  }

  /**
   * Builds instances of type {@link ViewStateValuesBlock ViewStateValuesBlock}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String type;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewStateValuesBlockIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewStateValuesBlockIF instance) {
      Objects.requireNonNull(instance, "instance");
      setType(instance.getType());
      setValue(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link ViewStateValuesBlockIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewStateValuesBlockIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ViewStateValuesBlock ViewStateValuesBlock}.
     * @return An immutable instance of ViewStateValuesBlock
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewStateValuesBlock build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewStateValuesBlock(type, value);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build ViewStateValuesBlock, some of required attributes are not set " + attributes;
    }
  }
}
