package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewResponseActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewResponseAction.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewResponseActionIF"})
@Immutable
public final class ViewResponseAction
    implements ViewResponseActionIF {
  private final String responseAction;
  private final @Nullable ModalViewPayload view;
  private final Map<String, String> errors;

  private ViewResponseAction(
      String responseAction,
      @Nullable ModalViewPayload view,
      Map<String, String> errors) {
    this.responseAction = responseAction;
    this.view = view;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code responseAction} attribute
   */
  @JsonProperty
  @Override
  public String getResponseAction() {
    return responseAction;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Optional<ModalViewPayload> getView() {
    return Optional.ofNullable(view);
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Map<String, String> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewResponseActionIF#getResponseAction() responseAction} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param responseAction A new value for responseAction
   * @return A modified copy of the {@code this} object
   */
  public final ViewResponseAction withResponseAction(String responseAction) {
    if (this.responseAction.equals(responseAction)) return this;
    String newValue = Objects.requireNonNull(responseAction, "responseAction");
    return new ViewResponseAction(newValue, this.view, this.errors);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewResponseActionIF#getView() view} attribute.
   * @param value The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewResponseAction withView(@Nullable ModalViewPayload value) {
    @Nullable ModalViewPayload newValue = value;
    if (this.view == newValue) return this;
    return new ViewResponseAction(this.responseAction, newValue, this.errors);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewResponseActionIF#getView() view} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for view
   * @return A modified copy of {@code this} object
   */
  public final ViewResponseAction withView(Optional<ModalViewPayload> optional) {
    @Nullable ModalViewPayload value = optional.orElse(null);
    if (this.view == value) return this;
    return new ViewResponseAction(this.responseAction, value, this.errors);
  }

  /**
   * Copy the current immutable object by replacing the {@link ViewResponseActionIF#getErrors() errors} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param errors The entries to be added to the errors map
   * @return A modified copy of {@code this} object
   */
  public final ViewResponseAction withErrors(Map<String, ? extends String> errors) {
    if (this.errors == errors) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, errors);
    return new ViewResponseAction(this.responseAction, this.view, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewResponseAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewResponseAction
        && equalTo((ViewResponseAction) another);
  }

  private boolean equalTo(ViewResponseAction another) {
    return responseAction.equals(another.responseAction)
        && Objects.equals(view, another.view)
        && errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code responseAction}, {@code view}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + responseAction.hashCode();
    h = h * 17 + Objects.hashCode(view);
    h = h * 17 + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewResponseAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ViewResponseAction{");
    builder.append("responseAction=").append(responseAction);
    if (view != null) {
      builder.append(", ");
      builder.append("view=").append(view);
    }
    builder.append(", ");
    builder.append("errors=").append(errors);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewResponseActionIF {
    @Nullable String responseAction;
    Optional<ModalViewPayload> view = Optional.empty();
    @Nullable Map<String, String> errors;
    @JsonProperty
    public void setResponseAction(String responseAction) {
      this.responseAction = responseAction;
    }
    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setView(Optional<ModalViewPayload> view) {
      this.view = view;
    }
    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setErrors(Map<String, String> errors) {
      this.errors = errors;
    }
    @Override
    public String getResponseAction() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ModalViewPayload> getView() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getErrors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewResponseAction fromJson(Json json) {
    ViewResponseAction.Builder builder = ViewResponseAction.builder();
    if (json.responseAction != null) {
      builder.setResponseAction(json.responseAction);
    }
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.errors != null) {
      builder.putAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewResponseActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewResponseAction instance
   */
  public static ViewResponseAction copyOf(ViewResponseActionIF instance) {
    if (instance instanceof ViewResponseAction) {
      return (ViewResponseAction) instance;
    }
    return ViewResponseAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewResponseAction ViewResponseAction}.
   * @return A new ViewResponseAction builder
   */
  public static ViewResponseAction.Builder builder() {
    return new ViewResponseAction.Builder();
  }

  /**
   * Builds instances of type {@link ViewResponseAction ViewResponseAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RESPONSE_ACTION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String responseAction;
    private @Nullable ModalViewPayload view;
    private Map<String, String> errors = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewResponseActionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewResponseActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      setResponseAction(instance.getResponseAction());
      Optional<ModalViewPayload> viewOptional = instance.getView();
      if (viewOptional.isPresent()) {
        setView(viewOptional);
      }
      putAllErrors(instance.getErrors());
      return this;
    }

    /**
     * Initializes the value for the {@link ViewResponseActionIF#getResponseAction() responseAction} attribute.
     * @param responseAction The value for responseAction 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseAction(String responseAction) {
      this.responseAction = Objects.requireNonNull(responseAction, "responseAction");
      initBits &= ~INIT_BIT_RESPONSE_ACTION;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewResponseActionIF#getView() view} to view.
     * @param view The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setView(@Nullable ModalViewPayload view) {
      this.view = view;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewResponseActionIF#getView() view} to view.
     * @param view The value for view
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(Optional<ModalViewPayload> view) {
      this.view = view.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ViewResponseActionIF#getErrors() errors} map.
     * @param key The key in the errors map
     * @param value The associated value in the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putErrors(String key, String value) {
      this.errors.put(
          Objects.requireNonNull(key, "errors key"),
          Objects.requireNonNull(value, "errors value"));
      return this;
    }

    /**
     * Put one entry to the {@link ViewResponseActionIF#getErrors() errors} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putErrors(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.errors.put(
          Objects.requireNonNull(k, "errors key"),
          Objects.requireNonNull(v, "errors value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ViewResponseActionIF#getErrors() errors} map. Nulls are not permitted
     * @param errors The entries that will be added to the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setErrors(Map<String, ? extends String> errors) {
      this.errors.clear();
      return putAllErrors(errors);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ViewResponseActionIF#getErrors() errors} map. Nulls are not permitted
     * @param errors The entries that will be added to the errors map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllErrors(Map<String, ? extends String> errors) {
      for (Map.Entry<String, ? extends String> entry : errors.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.errors.put(
            Objects.requireNonNull(k, "errors key"),
            Objects.requireNonNull(v, "errors value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ViewResponseAction ViewResponseAction}.
     * @return An immutable instance of ViewResponseAction
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewResponseAction build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewResponseAction(responseAction, view, createUnmodifiableMap(false, false, errors));
    }

    private boolean responseActionIsSet() {
      return (initBits & INIT_BIT_RESPONSE_ACTION) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!responseActionIsSet()) attributes.add("responseAction");
      return "Cannot build ViewResponseAction, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
