package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewInteractionPayloadIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewInteractionPayload.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewInteractionPayloadIF"})
@Immutable
public final class ViewInteractionPayload
    implements ViewInteractionPayloadIF {
  private final ViewStateValuesPayload state;
  private final String hash;
  private final String type;
  private final List<Block> blocks;
  private final @Nullable String privateMetadata;
  private final @Nullable String callbackId;
  private final @Nullable String externalId;

  private ViewInteractionPayload(
      ViewStateValuesPayload state,
      String hash,
      String type,
      List<Block> blocks,
      @Nullable String privateMetadata,
      @Nullable String callbackId,
      @Nullable String externalId) {
    this.state = state;
    this.hash = hash;
    this.type = type;
    this.blocks = blocks;
    this.privateMetadata = privateMetadata;
    this.callbackId = callbackId;
    this.externalId = externalId;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty
  @Override
  public ViewStateValuesPayload getState() {
    return state;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    return blocks;
  }

  /**
   * @return The value of the {@code privateMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPrivateMetadata() {
    return Optional.ofNullable(privateMetadata);
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCallbackId() {
    return Optional.ofNullable(callbackId);
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewInteractionPayloadIF#getState() state} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param state A new value for state
   * @return A modified copy of the {@code this} object
   */
  public final ViewInteractionPayload withState(ViewStateValuesPayload state) {
    if (this.state == state) return this;
    ViewStateValuesPayload newValue = Objects.requireNonNull(state, "state");
    return new ViewInteractionPayload(
        newValue,
        this.hash,
        this.type,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewInteractionPayloadIF#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param hash A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ViewInteractionPayload withHash(String hash) {
    if (this.hash.equals(hash)) return this;
    String newValue = Objects.requireNonNull(hash, "hash");
    return new ViewInteractionPayload(
        this.state,
        newValue,
        this.type,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewInteractionPayloadIF#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewInteractionPayload withType(String type) {
    if (this.type.equals(type)) return this;
    String newValue = Objects.requireNonNull(type, "type");
    return new ViewInteractionPayload(
        this.state,
        this.hash,
        newValue,
        this.blocks,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewInteractionPayloadIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ViewInteractionPayload(
        this.state,
        this.hash,
        this.type,
        newValue,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewInteractionPayloadIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ViewInteractionPayload(
        this.state,
        this.hash,
        this.type,
        newValue,
        this.privateMetadata,
        this.callbackId,
        this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewInteractionPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * @param value The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withPrivateMetadata(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.privateMetadata, newValue)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, newValue, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewInteractionPayloadIF#getPrivateMetadata() privateMetadata} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateMetadata
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withPrivateMetadata(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.privateMetadata, value)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, value, this.callbackId, this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewInteractionPayloadIF#getCallbackId() callbackId} attribute.
   * @param value The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withCallbackId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.callbackId, newValue)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, this.privateMetadata, newValue, this.externalId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewInteractionPayloadIF#getCallbackId() callbackId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for callbackId
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withCallbackId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.callbackId, value)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, this.privateMetadata, value, this.externalId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ViewInteractionPayloadIF#getExternalId() externalId} attribute.
   * @param value The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withExternalId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, this.privateMetadata, this.callbackId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ViewInteractionPayloadIF#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ViewInteractionPayload withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ViewInteractionPayload(this.state, this.hash, this.type, this.blocks, this.privateMetadata, this.callbackId, value);
  }

  /**
   * This instance is equal to all instances of {@code ViewInteractionPayload} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewInteractionPayload
        && equalTo((ViewInteractionPayload) another);
  }

  private boolean equalTo(ViewInteractionPayload another) {
    return state.equals(another.state)
        && hash.equals(another.hash)
        && type.equals(another.type)
        && blocks.equals(another.blocks)
        && Objects.equals(privateMetadata, another.privateMetadata)
        && Objects.equals(callbackId, another.callbackId)
        && Objects.equals(externalId, another.externalId);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code hash}, {@code type}, {@code blocks}, {@code privateMetadata}, {@code callbackId}, {@code externalId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + state.hashCode();
    h = h * 17 + hash.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + blocks.hashCode();
    h = h * 17 + Objects.hashCode(privateMetadata);
    h = h * 17 + Objects.hashCode(callbackId);
    h = h * 17 + Objects.hashCode(externalId);
    return h;
  }

  /**
   * Prints the immutable value {@code ViewInteractionPayload} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ViewInteractionPayload{");
    builder.append("state=").append(state);
    builder.append(", ");
    builder.append("hash=").append(hash);
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    if (privateMetadata != null) {
      builder.append(", ");
      builder.append("privateMetadata=").append(privateMetadata);
    }
    if (callbackId != null) {
      builder.append(", ");
      builder.append("callbackId=").append(callbackId);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewInteractionPayloadIF {
    @Nullable ViewStateValuesPayload state;
    @Nullable String hash;
    @Nullable String type;
    List<Block> blocks = Collections.emptyList();
    Optional<String> privateMetadata = Optional.empty();
    Optional<String> callbackId = Optional.empty();
    Optional<String> externalId = Optional.empty();
    @JsonProperty
    public void setState(ViewStateValuesPayload state) {
      this.state = state;
    }
    @JsonProperty
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
    }
    @JsonProperty
    public void setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata;
    }
    @JsonProperty
    public void setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @Override
    public ViewStateValuesPayload getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPrivateMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExternalId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewInteractionPayload fromJson(Json json) {
    ViewInteractionPayload.Builder builder = ViewInteractionPayload.builder();
    if (json.state != null) {
      builder.setState(json.state);
    }
    if (json.hash != null) {
      builder.setHash(json.hash);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.blocks != null) {
      builder.addAllBlocks(json.blocks);
    }
    if (json.privateMetadata != null) {
      builder.setPrivateMetadata(json.privateMetadata);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.externalId != null) {
      builder.setExternalId(json.externalId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewInteractionPayloadIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewInteractionPayload instance
   */
  public static ViewInteractionPayload copyOf(ViewInteractionPayloadIF instance) {
    if (instance instanceof ViewInteractionPayload) {
      return (ViewInteractionPayload) instance;
    }
    return ViewInteractionPayload.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewInteractionPayload ViewInteractionPayload}.
   * @return A new ViewInteractionPayload builder
   */
  public static ViewInteractionPayload.Builder builder() {
    return new ViewInteractionPayload.Builder();
  }

  /**
   * Builds instances of type {@link ViewInteractionPayload ViewInteractionPayload}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATE = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable ViewStateValuesPayload state;
    private @Nullable String hash;
    private @Nullable String type;
    private List<Block> blocks = new ArrayList<Block>();
    private @Nullable String privateMetadata;
    private @Nullable String callbackId;
    private @Nullable String externalId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.ViewInteractionPayloadIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewInteractionPayloadIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.views.ViewPayloadBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewPayloadBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewInteractionPayloadIF) {
        ViewInteractionPayloadIF instance = (ViewInteractionPayloadIF) object;
        setHash(instance.getHash());
        setState(instance.getState());
      }
      if (object instanceof ViewPayloadBase) {
        ViewPayloadBase instance = (ViewPayloadBase) object;
        Optional<String> externalIdOptional = instance.getExternalId();
        if (externalIdOptional.isPresent()) {
          setExternalId(externalIdOptional);
        }
        Optional<String> privateMetadataOptional = instance.getPrivateMetadata();
        if (privateMetadataOptional.isPresent()) {
          setPrivateMetadata(privateMetadataOptional);
        }
        setType(instance.getType());
        Optional<String> callbackIdOptional = instance.getCallbackId();
        if (callbackIdOptional.isPresent()) {
          setCallbackId(callbackIdOptional);
        }
        addAllBlocks(instance.getBlocks());
      }
    }

    /**
     * Initializes the value for the {@link ViewInteractionPayloadIF#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setState(ViewStateValuesPayload state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewInteractionPayloadIF#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewInteractionPayloadIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link ViewInteractionPayloadIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      return this;
    }

    /**
     * Adds elements to {@link ViewInteractionPayloadIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ViewInteractionPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link ViewInteractionPayloadIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
      this.privateMetadata = privateMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getPrivateMetadata() privateMetadata} to privateMetadata.
     * @param privateMetadata The value for privateMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
      this.privateMetadata = privateMetadata.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCallbackId(@Nullable String callbackId) {
      this.callbackId = callbackId;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getCallbackId() callbackId} to callbackId.
     * @param callbackId The value for callbackId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(Optional<String> callbackId) {
      this.callbackId = callbackId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the optional value {@link ViewInteractionPayloadIF#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ViewInteractionPayload ViewInteractionPayload}.
     * @return An immutable instance of ViewInteractionPayload
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewInteractionPayload build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewInteractionPayload(
          state,
          hash,
          type,
          createUnmodifiableList(true, blocks),
          privateMetadata,
          callbackId,
          externalId);
    }

    private boolean stateIsSet() {
      return (initBits & INIT_BIT_STATE) == 0;
    }

    private boolean hashIsSet() {
      return (initBits & INIT_BIT_HASH) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!stateIsSet()) attributes.add("state");
      if (!hashIsSet()) attributes.add("hash");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ViewInteractionPayload, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
