package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewContainerIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewContainer.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewContainerIF"})
@Immutable
public final class ViewContainer implements ViewContainerIF {
  private final String viewId;
  private final ContainerType type;

  private ViewContainer(String viewId, ContainerType type) {
    this.viewId = viewId;
    this.type = type;
  }

  /**
   * @return The value of the {@code viewId} attribute
   */
  @JsonProperty
  @Override
  public String getViewId() {
    return viewId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ContainerType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewContainerIF#getViewId() viewId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param viewId A new value for viewId
   * @return A modified copy of the {@code this} object
   */
  public final ViewContainer withViewId(String viewId) {
    if (this.viewId.equals(viewId)) return this;
    String newValue = Objects.requireNonNull(viewId, "viewId");
    return new ViewContainer(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewContainerIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewContainer withType(ContainerType type) {
    if (this.type == type) return this;
    ContainerType newValue = Objects.requireNonNull(type, "type");
    return new ViewContainer(this.viewId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewContainer
        && equalTo((ViewContainer) another);
  }

  private boolean equalTo(ViewContainer another) {
    return viewId.equals(another.viewId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code viewId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + viewId.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewContainer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewContainer{"
        + "viewId=" + viewId
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewContainerIF {
    @Nullable String viewId;
    @Nullable ContainerType type;
    @JsonProperty
    public void setViewId(String viewId) {
      this.viewId = viewId;
    }
    @JsonProperty
    public void setType(ContainerType type) {
      this.type = type;
    }
    @Override
    public String getViewId() { throw new UnsupportedOperationException(); }
    @Override
    public ContainerType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewContainer fromJson(Json json) {
    ViewContainer.Builder builder = ViewContainer.builder();
    if (json.viewId != null) {
      builder.setViewId(json.viewId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewContainerIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewContainer instance
   */
  public static ViewContainer copyOf(ViewContainerIF instance) {
    if (instance instanceof ViewContainer) {
      return (ViewContainer) instance;
    }
    return ViewContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewContainer ViewContainer}.
   * @return A new ViewContainer builder
   */
  public static ViewContainer.Builder builder() {
    return new ViewContainer.Builder();
  }

  /**
   * Builds instances of type {@link ViewContainer ViewContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VIEW_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String viewId;
    private @Nullable ContainerType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.ViewContainerIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewContainerIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.Container} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Container instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ViewContainerIF) {
        ViewContainerIF instance = (ViewContainerIF) object;
        setViewId(instance.getViewId());
      }
      if (object instanceof Container) {
        Container instance = (Container) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link ViewContainerIF#getViewId() viewId} attribute.
     * @param viewId The value for viewId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setViewId(String viewId) {
      this.viewId = Objects.requireNonNull(viewId, "viewId");
      initBits &= ~INIT_BIT_VIEW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewContainerIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ContainerType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ViewContainer ViewContainer}.
     * @return An immutable instance of ViewContainer
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewContainer build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewContainer(viewId, type);
    }

    private boolean viewIdIsSet() {
      return (initBits & INIT_BIT_VIEW_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!viewIdIsSet()) attributes.add("viewId");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ViewContainer, some of required attributes are not set " + attributes;
    }
  }
}
