package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ViewClosedIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ViewClosed.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ViewClosedIF"})
@Immutable
public final class ViewClosed implements ViewClosedIF {
  private final ViewPayloadBase view;
  private final boolean isCleared;
  private final InteractiveCallbackType type;
  private final String callbackId;
  private final String actionTs;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;
  private final SlackChannel channel;

  private ViewClosed(
      ViewPayloadBase view,
      boolean isCleared,
      InteractiveCallbackType type,
      String callbackId,
      String actionTs,
      String token,
      SlackTeam team,
      SlackUserLite user,
      SlackChannel channel) {
    this.view = view;
    this.isCleared = isCleared;
    this.type = type;
    this.callbackId = callbackId;
    this.actionTs = actionTs;
    this.token = token;
    this.team = team;
    this.user = user;
    this.channel = channel;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public ViewPayloadBase getView() {
    return view;
  }

  /**
   * @return The value of the {@code isCleared} attribute
   */
  @JsonProperty
  @Override
  public boolean getIsCleared() {
    return isCleared;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getView() view} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param view A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withView(ViewPayloadBase view) {
    if (this.view == view) return this;
    ViewPayloadBase newValue = Objects.requireNonNull(view, "view");
    return new ViewClosed(
        newValue,
        this.isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getIsCleared() isCleared} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isCleared A new value for isCleared
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withIsCleared(boolean isCleared) {
    if (this.isCleared == isCleared) return this;
    return new ViewClosed(
        this.view,
        isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new ViewClosed(
        this.view,
        this.isCleared,
        newValue,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        newValue,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        this.callbackId,
        newValue,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        newValue,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        newValue,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewClosedIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final ViewClosed withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new ViewClosed(
        this.view,
        this.isCleared,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ViewClosed} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ViewClosed
        && equalTo((ViewClosed) another);
  }

  private boolean equalTo(ViewClosed another) {
    return view.equals(another.view)
        && isCleared == another.isCleared
        && type.equals(another.type)
        && callbackId.equals(another.callbackId)
        && actionTs.equals(another.actionTs)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user)
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code view}, {@code isCleared}, {@code type}, {@code callbackId}, {@code actionTs}, {@code token}, {@code team}, {@code user}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + view.hashCode();
    h = h * 17 + Boolean.hashCode(isCleared);
    h = h * 17 + type.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    h = h * 17 + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewClosed} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewClosed{"
        + "view=" + view
        + ", isCleared=" + isCleared
        + ", type=" + type
        + ", callbackId=" + callbackId
        + ", actionTs=" + actionTs
        + ", token=" + token
        + ", team=" + team
        + ", user=" + user
        + ", channel=" + channel
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewClosedIF {
    @Nullable ViewPayloadBase view;
    boolean isCleared;
    boolean isClearedIsSet;
    @Nullable InteractiveCallbackType type;
    @Nullable String callbackId;
    @Nullable String actionTs;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @Nullable SlackChannel channel;
    @JsonProperty
    public void setView(ViewPayloadBase view) {
      this.view = view;
    }
    @JsonProperty
    public void setIsCleared(boolean isCleared) {
      this.isCleared = isCleared;
      this.isClearedIsSet = true;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @Override
    public ViewPayloadBase getView() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIsCleared() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ViewClosed fromJson(Json json) {
    ViewClosed.Builder builder = ViewClosed.builder();
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.isClearedIsSet) {
      builder.setIsCleared(json.isCleared);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewClosedIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewClosed instance
   */
  public static ViewClosed copyOf(ViewClosedIF instance) {
    if (instance instanceof ViewClosed) {
      return (ViewClosed) instance;
    }
    return ViewClosed.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ViewClosed ViewClosed}.
   * @return A new ViewClosed builder
   */
  public static ViewClosed.Builder builder() {
    return new ViewClosed.Builder();
  }

  /**
   * Builds instances of type {@link ViewClosed ViewClosed}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VIEW = 0x1L;
    private static final long INIT_BIT_IS_CLEARED = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_CALLBACK_ID = 0x8L;
    private static final long INIT_BIT_ACTION_TS = 0x10L;
    private static final long INIT_BIT_TOKEN = 0x20L;
    private static final long INIT_BIT_TEAM = 0x40L;
    private static final long INIT_BIT_USER = 0x80L;
    private static final long INIT_BIT_CHANNEL = 0x100L;
    private long initBits = 0x1ffL;

    private @Nullable ViewPayloadBase view;
    private boolean isCleared;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String callbackId;
    private @Nullable String actionTs;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;
    private @Nullable SlackChannel channel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.ViewClosedIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewClosedIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setCallbackId(instance.getCallbackId());
        setChannel(instance.getChannel());
        setTeam(instance.getTeam());
        setType(instance.getType());
        setActionTs(instance.getActionTs());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
      if (object instanceof ViewClosedIF) {
        ViewClosedIF instance = (ViewClosedIF) object;
        setIsCleared(instance.getIsCleared());
        setView(instance.getView());
      }
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getView() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(ViewPayloadBase view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getIsCleared() isCleared} attribute.
     * @param isCleared The value for isCleared 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsCleared(boolean isCleared) {
      this.isCleared = isCleared;
      initBits &= ~INIT_BIT_IS_CLEARED;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewClosedIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Builds a new {@link ViewClosed ViewClosed}.
     * @return An immutable instance of ViewClosed
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ViewClosed build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ViewClosed(view, isCleared, type, callbackId, actionTs, token, team, user, channel);
    }

    private boolean viewIsSet() {
      return (initBits & INIT_BIT_VIEW) == 0;
    }

    private boolean isClearedIsSet() {
      return (initBits & INIT_BIT_IS_CLEARED) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!viewIsSet()) attributes.add("view");
      if (!isClearedIsSet()) attributes.add("isCleared");
      if (!typeIsSet()) attributes.add("type");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      if (!channelIsSet()) attributes.add("channel");
      return "Cannot build ViewClosed, some of required attributes are not set " + attributes;
    }
  }
}
