package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.TopLevelMessageResponseType;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TopLevelMessageInteractionResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code TopLevelMessageInteractionResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TopLevelMessageInteractionResponseIF"})
@Immutable
public final class TopLevelMessageInteractionResponse
    implements TopLevelMessageInteractionResponseIF {
  private final TopLevelMessageResponseType responseType;
  private final boolean replaceOriginal;
  private final boolean deleteOriginal;
  private final @Nullable String text;
  private final List<Attachment> attachments;
  private final List<Block> blocks;

  private TopLevelMessageInteractionResponse(TopLevelMessageInteractionResponse.Builder builder) {
    this.responseType = builder.responseType;
    this.replaceOriginal = builder.replaceOriginal;
    this.text = builder.text;
    this.attachments = createUnmodifiableList(true, builder.attachments);
    this.blocks = createUnmodifiableList(true, builder.blocks);
    this.deleteOriginal = builder.deleteOriginalIsSet()
        ? builder.deleteOriginal
        : TopLevelMessageInteractionResponseIF.super.getDeleteOriginal();
  }

  private TopLevelMessageInteractionResponse(
      TopLevelMessageResponseType responseType,
      boolean replaceOriginal,
      boolean deleteOriginal,
      @Nullable String text,
      List<Attachment> attachments,
      List<Block> blocks) {
    this.responseType = responseType;
    this.replaceOriginal = replaceOriginal;
    this.deleteOriginal = deleteOriginal;
    this.text = text;
    this.attachments = attachments;
    this.blocks = blocks;
  }

  /**
   * @return The value of the {@code responseType} attribute
   */
  @JsonProperty
  @Override
  public TopLevelMessageResponseType getResponseType() {
    return responseType;
  }

  /**
   * @return The value of the {@code replaceOriginal} attribute
   */
  @JsonProperty
  @Override
  public boolean getReplaceOriginal() {
    return replaceOriginal;
  }

  /**
   * @return The value of the {@code deleteOriginal} attribute
   */
  @JsonProperty
  @Override
  public boolean getDeleteOriginal() {
    return deleteOriginal;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    return blocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TopLevelMessageInteractionResponseIF#getResponseType() responseType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param responseType A new value for responseType
   * @return A modified copy of the {@code this} object
   */
  public final TopLevelMessageInteractionResponse withResponseType(TopLevelMessageResponseType responseType) {
    if (this.responseType == responseType) return this;
    TopLevelMessageResponseType newValue = Objects.requireNonNull(responseType, "responseType");
    return validate(new TopLevelMessageInteractionResponse(newValue, this.replaceOriginal, this.deleteOriginal, this.text, this.attachments, this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TopLevelMessageInteractionResponseIF#getReplaceOriginal() replaceOriginal} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param replaceOriginal A new value for replaceOriginal
   * @return A modified copy of the {@code this} object
   */
  public final TopLevelMessageInteractionResponse withReplaceOriginal(boolean replaceOriginal) {
    if (this.replaceOriginal == replaceOriginal) return this;
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        replaceOriginal,
        this.deleteOriginal,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TopLevelMessageInteractionResponseIF#getDeleteOriginal() deleteOriginal} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param deleteOriginal A new value for deleteOriginal
   * @return A modified copy of the {@code this} object
   */
  public final TopLevelMessageInteractionResponse withDeleteOriginal(boolean deleteOriginal) {
    if (this.deleteOriginal == deleteOriginal) return this;
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        this.replaceOriginal,
        deleteOriginal,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TopLevelMessageInteractionResponseIF#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        this.replaceOriginal,
        this.deleteOriginal,
        newValue,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TopLevelMessageInteractionResponseIF#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        this.replaceOriginal,
        this.deleteOriginal,
        value,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, this.text, newValue, this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new TopLevelMessageInteractionResponse(this.responseType, this.replaceOriginal, this.deleteOriginal, this.text, newValue, this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        this.replaceOriginal,
        this.deleteOriginal,
        this.text,
        this.attachments,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final TopLevelMessageInteractionResponse withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new TopLevelMessageInteractionResponse(
        this.responseType,
        this.replaceOriginal,
        this.deleteOriginal,
        this.text,
        this.attachments,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code TopLevelMessageInteractionResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof TopLevelMessageInteractionResponse
        && equalTo((TopLevelMessageInteractionResponse) another);
  }

  private boolean equalTo(TopLevelMessageInteractionResponse another) {
    return responseType.equals(another.responseType)
        && replaceOriginal == another.replaceOriginal
        && deleteOriginal == another.deleteOriginal
        && Objects.equals(text, another.text)
        && attachments.equals(another.attachments)
        && blocks.equals(another.blocks);
  }

  /**
   * Computes a hash code from attributes: {@code responseType}, {@code replaceOriginal}, {@code deleteOriginal}, {@code text}, {@code attachments}, {@code blocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + responseType.hashCode();
    h = h * 17 + Boolean.hashCode(replaceOriginal);
    h = h * 17 + Boolean.hashCode(deleteOriginal);
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + attachments.hashCode();
    h = h * 17 + blocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TopLevelMessageInteractionResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("TopLevelMessageInteractionResponse{");
    builder.append("responseType=").append(responseType);
    builder.append(", ");
    builder.append("replaceOriginal=").append(replaceOriginal);
    builder.append(", ");
    builder.append("deleteOriginal=").append(deleteOriginal);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements TopLevelMessageInteractionResponseIF {
    @Nullable TopLevelMessageResponseType responseType;
    boolean replaceOriginal;
    boolean replaceOriginalIsSet;
    boolean deleteOriginal;
    boolean deleteOriginalIsSet;
    Optional<String> text = Optional.empty();
    List<Attachment> attachments = Collections.emptyList();
    List<Block> blocks = Collections.emptyList();
    @JsonProperty
    public void setResponseType(TopLevelMessageResponseType responseType) {
      this.responseType = responseType;
    }
    @JsonProperty
    public void setReplaceOriginal(boolean replaceOriginal) {
      this.replaceOriginal = replaceOriginal;
      this.replaceOriginalIsSet = true;
    }
    @JsonProperty
    public void setDeleteOriginal(boolean deleteOriginal) {
      this.deleteOriginal = deleteOriginal;
      this.deleteOriginalIsSet = true;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
    }
    @Override
    public TopLevelMessageResponseType getResponseType() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getReplaceOriginal() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDeleteOriginal() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static TopLevelMessageInteractionResponse fromJson(Json json) {
    TopLevelMessageInteractionResponse.Builder builder = TopLevelMessageInteractionResponse.builder();
    if (json.responseType != null) {
      builder.setResponseType(json.responseType);
    }
    if (json.replaceOriginalIsSet) {
      builder.setReplaceOriginal(json.replaceOriginal);
    }
    if (json.deleteOriginalIsSet) {
      builder.setDeleteOriginal(json.deleteOriginal);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.blocks != null) {
      builder.addAllBlocks(json.blocks);
    }
    return builder.build();
  }

  private static TopLevelMessageInteractionResponse validate(TopLevelMessageInteractionResponse instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link TopLevelMessageInteractionResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TopLevelMessageInteractionResponse instance
   */
  public static TopLevelMessageInteractionResponse copyOf(TopLevelMessageInteractionResponseIF instance) {
    if (instance instanceof TopLevelMessageInteractionResponse) {
      return (TopLevelMessageInteractionResponse) instance;
    }
    return TopLevelMessageInteractionResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link TopLevelMessageInteractionResponse TopLevelMessageInteractionResponse}.
   * @return A new TopLevelMessageInteractionResponse builder
   */
  public static TopLevelMessageInteractionResponse.Builder builder() {
    return new TopLevelMessageInteractionResponse.Builder();
  }

  /**
   * Builds instances of type {@link TopLevelMessageInteractionResponse TopLevelMessageInteractionResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RESPONSE_TYPE = 0x1L;
    private static final long INIT_BIT_REPLACE_ORIGINAL = 0x2L;
    private static final long OPT_BIT_DELETE_ORIGINAL = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable TopLevelMessageResponseType responseType;
    private boolean replaceOriginal;
    private boolean deleteOriginal;
    private @Nullable String text;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Block> blocks = new ArrayList<Block>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TopLevelMessageInteractionResponseIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TopLevelMessageInteractionResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      setResponseType(instance.getResponseType());
      setReplaceOriginal(instance.getReplaceOriginal());
      setDeleteOriginal(instance.getDeleteOriginal());
      Optional<String> textOptional = instance.getText();
      if (textOptional.isPresent()) {
        setText(textOptional);
      }
      addAllAttachments(instance.getAttachments());
      addAllBlocks(instance.getBlocks());
      return this;
    }

    /**
     * Initializes the value for the {@link TopLevelMessageInteractionResponseIF#getResponseType() responseType} attribute.
     * @param responseType The value for responseType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseType(TopLevelMessageResponseType responseType) {
      this.responseType = Objects.requireNonNull(responseType, "responseType");
      initBits &= ~INIT_BIT_RESPONSE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link TopLevelMessageInteractionResponseIF#getReplaceOriginal() replaceOriginal} attribute.
     * @param replaceOriginal The value for replaceOriginal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplaceOriginal(boolean replaceOriginal) {
      this.replaceOriginal = replaceOriginal;
      initBits &= ~INIT_BIT_REPLACE_ORIGINAL;
      return this;
    }

    /**
     * Initializes the value for the {@link TopLevelMessageInteractionResponseIF#getDeleteOriginal() deleteOriginal} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TopLevelMessageInteractionResponseIF#getDeleteOriginal() deleteOriginal}.</em>
     * @param deleteOriginal The value for deleteOriginal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDeleteOriginal(boolean deleteOriginal) {
      this.deleteOriginal = deleteOriginal;
      optBits |= OPT_BIT_DELETE_ORIGINAL;
      return this;
    }

    /**
     * Initializes the optional value {@link TopLevelMessageInteractionResponseIF#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link TopLevelMessageInteractionResponseIF#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link TopLevelMessageInteractionResponseIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      return this;
    }

    /**
     * Adds elements to {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link TopLevelMessageInteractionResponseIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      return this;
    }

    /**
     * Builds a new {@link TopLevelMessageInteractionResponse TopLevelMessageInteractionResponse}.
     * @return An immutable instance of TopLevelMessageInteractionResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public TopLevelMessageInteractionResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return TopLevelMessageInteractionResponse.validate(new TopLevelMessageInteractionResponse(this));
    }

    private boolean deleteOriginalIsSet() {
      return (optBits & OPT_BIT_DELETE_ORIGINAL) != 0;
    }

    private boolean responseTypeIsSet() {
      return (initBits & INIT_BIT_RESPONSE_TYPE) == 0;
    }

    private boolean replaceOriginalIsSet() {
      return (initBits & INIT_BIT_REPLACE_ORIGINAL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!responseTypeIsSet()) attributes.add("responseType");
      if (!replaceOriginalIsSet()) attributes.add("replaceOriginal");
      return "Cannot build TopLevelMessageInteractionResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
