package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ShortcutIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Shortcut.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ShortcutIF"})
@Immutable
public final class Shortcut implements ShortcutIF {
  private final String triggerId;
  private final InteractiveCallbackType type;
  private final String callbackId;
  private final String actionTs;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;

  private Shortcut(
      String triggerId,
      InteractiveCallbackType type,
      String callbackId,
      String actionTs,
      String token,
      SlackTeam team,
      SlackUserLite user) {
    this.triggerId = triggerId;
    this.type = type;
    this.callbackId = callbackId;
    this.actionTs = actionTs;
    this.token = token;
    this.team = team;
    this.user = user;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new Shortcut(newValue, this.type, this.callbackId, this.actionTs, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new Shortcut(this.triggerId, newValue, this.callbackId, this.actionTs, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new Shortcut(this.triggerId, this.type, newValue, this.actionTs, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new Shortcut(this.triggerId, this.type, this.callbackId, newValue, this.token, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, newValue, this.team, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, this.token, newValue, this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ShortcutIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final Shortcut withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new Shortcut(this.triggerId, this.type, this.callbackId, this.actionTs, this.token, this.team, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Shortcut} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Shortcut
        && equalTo((Shortcut) another);
  }

  private boolean equalTo(Shortcut another) {
    return triggerId.equals(another.triggerId)
        && type.equals(another.type)
        && callbackId.equals(another.callbackId)
        && actionTs.equals(another.actionTs)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user);
  }

  /**
   * Computes a hash code from attributes: {@code triggerId}, {@code type}, {@code callbackId}, {@code actionTs}, {@code token}, {@code team}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Shortcut} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Shortcut{"
        + "triggerId=" + triggerId
        + ", type=" + type
        + ", callbackId=" + callbackId
        + ", actionTs=" + actionTs
        + ", token=" + token
        + ", team=" + team
        + ", user=" + user
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ShortcutIF {
    @Nullable String triggerId;
    @Nullable InteractiveCallbackType type;
    @Nullable String callbackId;
    @Nullable String actionTs;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Shortcut fromJson(Json json) {
    Shortcut.Builder builder = Shortcut.builder();
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ShortcutIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Shortcut instance
   */
  public static Shortcut copyOf(ShortcutIF instance) {
    if (instance instanceof Shortcut) {
      return (Shortcut) instance;
    }
    return Shortcut.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Shortcut Shortcut}.
   * @return A new Shortcut builder
   */
  public static Shortcut.Builder builder() {
    return new Shortcut.Builder();
  }

  /**
   * Builds instances of type {@link Shortcut Shortcut}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRIGGER_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_CALLBACK_ID = 0x4L;
    private static final long INIT_BIT_ACTION_TS = 0x8L;
    private static final long INIT_BIT_TOKEN = 0x10L;
    private static final long INIT_BIT_TEAM = 0x20L;
    private static final long INIT_BIT_USER = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String triggerId;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String callbackId;
    private @Nullable String actionTs;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.ShortcutIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ShortcutIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ShortcutIF) {
        ShortcutIF instance = (ShortcutIF) object;
        setTriggerId(instance.getTriggerId());
      }
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setTeam(instance.getTeam());
        setType(instance.getType());
        setCallbackId(instance.getCallbackId());
        setActionTs(instance.getActionTs());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link ShortcutIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Builds a new {@link Shortcut Shortcut}.
     * @return An immutable instance of Shortcut
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Shortcut build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Shortcut(triggerId, type, callbackId, actionTs, token, team, user);
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!typeIsSet()) attributes.add("type");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      return "Cannot build Shortcut, some of required attributes are not set " + attributes;
    }
  }
}
