package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link MessageContainerIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MessageContainer.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "MessageContainerIF"})
@Immutable
public final class MessageContainer implements MessageContainerIF {
  private final String messageTs;
  private final String channelId;
  private final boolean ephemeral;
  private final ContainerType type;

  private MessageContainer(
      String messageTs,
      String channelId,
      boolean ephemeral,
      ContainerType type) {
    this.messageTs = messageTs;
    this.channelId = channelId;
    this.ephemeral = ephemeral;
    this.type = type;
  }

  /**
   * @return The value of the {@code messageTs} attribute
   */
  @JsonProperty
  @Override
  public String getMessageTs() {
    return messageTs;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code ephemeral} attribute
   */
  @JsonProperty("is_ephemeral")
  @Override
  public boolean isEphemeral() {
    return ephemeral;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ContainerType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageContainerIF#getMessageTs() messageTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param messageTs A new value for messageTs
   * @return A modified copy of the {@code this} object
   */
  public final MessageContainer withMessageTs(String messageTs) {
    if (this.messageTs.equals(messageTs)) return this;
    String newValue = Objects.requireNonNull(messageTs, "messageTs");
    return new MessageContainer(newValue, this.channelId, this.ephemeral, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageContainerIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final MessageContainer withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new MessageContainer(this.messageTs, newValue, this.ephemeral, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageContainerIF#isEphemeral() ephemeral} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ephemeral A new value for ephemeral
   * @return A modified copy of the {@code this} object
   */
  public final MessageContainer withEphemeral(boolean ephemeral) {
    if (this.ephemeral == ephemeral) return this;
    return new MessageContainer(this.messageTs, this.channelId, ephemeral, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageContainerIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final MessageContainer withType(ContainerType type) {
    if (this.type == type) return this;
    ContainerType newValue = Objects.requireNonNull(type, "type");
    return new MessageContainer(this.messageTs, this.channelId, this.ephemeral, newValue);
  }

  /**
   * This instance is equal to all instances of {@code MessageContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MessageContainer
        && equalTo((MessageContainer) another);
  }

  private boolean equalTo(MessageContainer another) {
    return messageTs.equals(another.messageTs)
        && channelId.equals(another.channelId)
        && ephemeral == another.ephemeral
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code messageTs}, {@code channelId}, {@code ephemeral}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + messageTs.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Boolean.hashCode(ephemeral);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageContainer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageContainer{"
        + "messageTs=" + messageTs
        + ", channelId=" + channelId
        + ", ephemeral=" + ephemeral
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MessageContainerIF {
    @Nullable String messageTs;
    @Nullable String channelId;
    boolean ephemeral;
    boolean ephemeralIsSet;
    @Nullable ContainerType type;
    @JsonProperty
    public void setMessageTs(String messageTs) {
      this.messageTs = messageTs;
    }
    @JsonProperty
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("is_ephemeral")
    public void setEphemeral(boolean ephemeral) {
      this.ephemeral = ephemeral;
      this.ephemeralIsSet = true;
    }
    @JsonProperty
    public void setType(ContainerType type) {
      this.type = type;
    }
    @Override
    public String getMessageTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isEphemeral() { throw new UnsupportedOperationException(); }
    @Override
    public ContainerType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static MessageContainer fromJson(Json json) {
    MessageContainer.Builder builder = MessageContainer.builder();
    if (json.messageTs != null) {
      builder.setMessageTs(json.messageTs);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.ephemeralIsSet) {
      builder.setEphemeral(json.ephemeral);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MessageContainerIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageContainer instance
   */
  public static MessageContainer copyOf(MessageContainerIF instance) {
    if (instance instanceof MessageContainer) {
      return (MessageContainer) instance;
    }
    return MessageContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link MessageContainer MessageContainer}.
   * @return A new MessageContainer builder
   */
  public static MessageContainer.Builder builder() {
    return new MessageContainer.Builder();
  }

  /**
   * Builds instances of type {@link MessageContainer MessageContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE_TS = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private static final long INIT_BIT_EPHEMERAL = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String messageTs;
    private @Nullable String channelId;
    private boolean ephemeral;
    private @Nullable ContainerType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.MessageContainerIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageContainerIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.Container} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Container instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof MessageContainerIF) {
        MessageContainerIF instance = (MessageContainerIF) object;
        setEphemeral(instance.isEphemeral());
        setMessageTs(instance.getMessageTs());
        setChannelId(instance.getChannelId());
      }
      if (object instanceof Container) {
        Container instance = (Container) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link MessageContainerIF#getMessageTs() messageTs} attribute.
     * @param messageTs The value for messageTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageTs(String messageTs) {
      this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
      initBits &= ~INIT_BIT_MESSAGE_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageContainerIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageContainerIF#isEphemeral() ephemeral} attribute.
     * @param ephemeral The value for ephemeral 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEphemeral(boolean ephemeral) {
      this.ephemeral = ephemeral;
      initBits &= ~INIT_BIT_EPHEMERAL;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageContainerIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ContainerType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link MessageContainer MessageContainer}.
     * @return An immutable instance of MessageContainer
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public MessageContainer build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new MessageContainer(messageTs, channelId, ephemeral, type);
    }

    private boolean messageTsIsSet() {
      return (initBits & INIT_BIT_MESSAGE_TS) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean ephemeralIsSet() {
      return (initBits & INIT_BIT_EPHEMERAL) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!messageTsIsSet()) attributes.add("messageTs");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!ephemeralIsSet()) attributes.add("ephemeral");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build MessageContainer, some of required attributes are not set " + attributes;
    }
  }
}
