package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InteractiveLoadOptionsRequestIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractiveLoadOptionsRequest.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InteractiveLoadOptionsRequestIF"})
@Immutable
public final class InteractiveLoadOptionsRequest
    implements InteractiveLoadOptionsRequestIF {
  private final String name;
  private final String value;
  private final String callbackId;
  private final SlackTeam team;
  private final SlackChannel channel;
  private final SlackUserLite user;
  private final InteractiveLoadOptionsRequestType type;
  private final String actionTs;
  private final @Nullable String messageTs;
  private final @Nullable String attachmentId;
  private final String token;

  private InteractiveLoadOptionsRequest(
      String name,
      String value,
      String callbackId,
      SlackTeam team,
      SlackChannel channel,
      SlackUserLite user,
      InteractiveLoadOptionsRequestType type,
      String actionTs,
      @Nullable String messageTs,
      @Nullable String attachmentId,
      String token) {
    this.name = name;
    this.value = value;
    this.callbackId = callbackId;
    this.team = team;
    this.channel = channel;
    this.user = user;
    this.type = type;
    this.actionTs = actionTs;
    this.messageTs = messageTs;
    this.attachmentId = attachmentId;
    this.token = token;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveLoadOptionsRequestType getType() {
    return type;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code messageTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getMessageTs() {
    return Optional.ofNullable(messageTs);
  }

  /**
   * @return The value of the {@code attachmentId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getAttachmentId() {
    return Optional.ofNullable(attachmentId);
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new InteractiveLoadOptionsRequest(
        newValue,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new InteractiveLoadOptionsRequest(
        this.name,
        newValue,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        newValue,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        newValue,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        newValue,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        newValue,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withType(InteractiveLoadOptionsRequestType type) {
    if (this.type == type) return this;
    InteractiveLoadOptionsRequestType newValue = Objects.requireNonNull(type, "type");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        newValue,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        newValue,
        this.messageTs,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InteractiveLoadOptionsRequestIF#getMessageTs() messageTs} attribute.
   * @param value The value for messageTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final InteractiveLoadOptionsRequest withMessageTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.messageTs, newValue)) return this;
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        newValue,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InteractiveLoadOptionsRequestIF#getMessageTs() messageTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for messageTs
   * @return A modified copy of {@code this} object
   */
  public final InteractiveLoadOptionsRequest withMessageTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.messageTs, value)) return this;
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        value,
        this.attachmentId,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InteractiveLoadOptionsRequestIF#getAttachmentId() attachmentId} attribute.
   * @param value The value for attachmentId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final InteractiveLoadOptionsRequest withAttachmentId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.attachmentId, newValue)) return this;
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        newValue,
        this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InteractiveLoadOptionsRequestIF#getAttachmentId() attachmentId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for attachmentId
   * @return A modified copy of {@code this} object
   */
  public final InteractiveLoadOptionsRequest withAttachmentId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.attachmentId, value)) return this;
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        value,
        this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveLoadOptionsRequestIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveLoadOptionsRequest withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new InteractiveLoadOptionsRequest(
        this.name,
        this.value,
        this.callbackId,
        this.team,
        this.channel,
        this.user,
        this.type,
        this.actionTs,
        this.messageTs,
        this.attachmentId,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractiveLoadOptionsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof InteractiveLoadOptionsRequest
        && equalTo((InteractiveLoadOptionsRequest) another);
  }

  private boolean equalTo(InteractiveLoadOptionsRequest another) {
    return name.equals(another.name)
        && value.equals(another.value)
        && callbackId.equals(another.callbackId)
        && team.equals(another.team)
        && channel.equals(another.channel)
        && user.equals(another.user)
        && type.equals(another.type)
        && actionTs.equals(another.actionTs)
        && Objects.equals(messageTs, another.messageTs)
        && Objects.equals(attachmentId, another.attachmentId)
        && token.equals(another.token);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code value}, {@code callbackId}, {@code team}, {@code channel}, {@code user}, {@code type}, {@code actionTs}, {@code messageTs}, {@code attachmentId}, {@code token}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + value.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + channel.hashCode();
    h = h * 17 + user.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + Objects.hashCode(messageTs);
    h = h * 17 + Objects.hashCode(attachmentId);
    h = h * 17 + token.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractiveLoadOptionsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("InteractiveLoadOptionsRequest{");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("value=").append(value);
    builder.append(", ");
    builder.append("callbackId=").append(callbackId);
    builder.append(", ");
    builder.append("team=").append(team);
    builder.append(", ");
    builder.append("channel=").append(channel);
    builder.append(", ");
    builder.append("user=").append(user);
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("actionTs=").append(actionTs);
    if (messageTs != null) {
      builder.append(", ");
      builder.append("messageTs=").append(messageTs);
    }
    if (attachmentId != null) {
      builder.append(", ");
      builder.append("attachmentId=").append(attachmentId);
    }
    builder.append(", ");
    builder.append("token=").append(token);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements InteractiveLoadOptionsRequestIF {
    @Nullable String name;
    @Nullable String value;
    @Nullable String callbackId;
    @Nullable SlackTeam team;
    @Nullable SlackChannel channel;
    @Nullable SlackUserLite user;
    @Nullable InteractiveLoadOptionsRequestType type;
    @Nullable String actionTs;
    Optional<String> messageTs = Optional.empty();
    Optional<String> attachmentId = Optional.empty();
    @Nullable String token;
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @JsonProperty
    public void setType(InteractiveLoadOptionsRequestType type) {
      this.type = type;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setMessageTs(Optional<String> messageTs) {
      this.messageTs = messageTs;
    }
    @JsonProperty
    public void setAttachmentId(Optional<String> attachmentId) {
      this.attachmentId = attachmentId;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveLoadOptionsRequestType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getMessageTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getAttachmentId() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static InteractiveLoadOptionsRequest fromJson(Json json) {
    InteractiveLoadOptionsRequest.Builder builder = InteractiveLoadOptionsRequest.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.messageTs != null) {
      builder.setMessageTs(json.messageTs);
    }
    if (json.attachmentId != null) {
      builder.setAttachmentId(json.attachmentId);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InteractiveLoadOptionsRequestIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractiveLoadOptionsRequest instance
   */
  public static InteractiveLoadOptionsRequest copyOf(InteractiveLoadOptionsRequestIF instance) {
    if (instance instanceof InteractiveLoadOptionsRequest) {
      return (InteractiveLoadOptionsRequest) instance;
    }
    return InteractiveLoadOptionsRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link InteractiveLoadOptionsRequest InteractiveLoadOptionsRequest}.
   * @return A new InteractiveLoadOptionsRequest builder
   */
  public static InteractiveLoadOptionsRequest.Builder builder() {
    return new InteractiveLoadOptionsRequest.Builder();
  }

  /**
   * Builds instances of type {@link InteractiveLoadOptionsRequest InteractiveLoadOptionsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long INIT_BIT_CALLBACK_ID = 0x4L;
    private static final long INIT_BIT_TEAM = 0x8L;
    private static final long INIT_BIT_CHANNEL = 0x10L;
    private static final long INIT_BIT_USER = 0x20L;
    private static final long INIT_BIT_TYPE = 0x40L;
    private static final long INIT_BIT_ACTION_TS = 0x80L;
    private static final long INIT_BIT_TOKEN = 0x100L;
    private long initBits = 0x1ffL;

    private @Nullable String name;
    private @Nullable String value;
    private @Nullable String callbackId;
    private @Nullable SlackTeam team;
    private @Nullable SlackChannel channel;
    private @Nullable SlackUserLite user;
    private @Nullable InteractiveLoadOptionsRequestType type;
    private @Nullable String actionTs;
    private @Nullable String messageTs;
    private @Nullable String attachmentId;
    private @Nullable String token;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractiveLoadOptionsRequestIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractiveLoadOptionsRequestIF instance) {
      Objects.requireNonNull(instance, "instance");
      setName(instance.getName());
      setValue(instance.getValue());
      setCallbackId(instance.getCallbackId());
      setTeam(instance.getTeam());
      setChannel(instance.getChannel());
      setUser(instance.getUser());
      setType(instance.getType());
      setActionTs(instance.getActionTs());
      Optional<String> messageTsOptional = instance.getMessageTs();
      if (messageTsOptional.isPresent()) {
        setMessageTs(messageTsOptional);
      }
      Optional<String> attachmentIdOptional = instance.getAttachmentId();
      if (attachmentIdOptional.isPresent()) {
        setAttachmentId(attachmentIdOptional);
      }
      setToken(instance.getToken());
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveLoadOptionsRequestType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveLoadOptionsRequestIF#getMessageTs() messageTs} to messageTs.
     * @param messageTs The value for messageTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMessageTs(@Nullable String messageTs) {
      this.messageTs = messageTs;
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveLoadOptionsRequestIF#getMessageTs() messageTs} to messageTs.
     * @param messageTs The value for messageTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageTs(Optional<String> messageTs) {
      this.messageTs = messageTs.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveLoadOptionsRequestIF#getAttachmentId() attachmentId} to attachmentId.
     * @param attachmentId The value for attachmentId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAttachmentId(@Nullable String attachmentId) {
      this.attachmentId = attachmentId;
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveLoadOptionsRequestIF#getAttachmentId() attachmentId} to attachmentId.
     * @param attachmentId The value for attachmentId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachmentId(Optional<String> attachmentId) {
      this.attachmentId = attachmentId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveLoadOptionsRequestIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link InteractiveLoadOptionsRequest InteractiveLoadOptionsRequest}.
     * @return An immutable instance of InteractiveLoadOptionsRequest
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public InteractiveLoadOptionsRequest build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new InteractiveLoadOptionsRequest(name, value, callbackId, team, channel, user, type, actionTs, messageTs, attachmentId, token);
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      if (!valueIsSet()) attributes.add("value");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!teamIsSet()) attributes.add("team");
      if (!channelIsSet()) attributes.add("channel");
      if (!userIsSet()) attributes.add("user");
      if (!typeIsSet()) attributes.add("type");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      return "Cannot build InteractiveLoadOptionsRequest, some of required attributes are not set " + attributes;
    }
  }
}
