package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.actions.Action;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InteractiveActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractiveAction.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InteractiveActionIF"})
@Immutable
public final class InteractiveAction
    implements InteractiveActionIF {
  private final List<Action> actions;
  private final String messageTs;
  private final int attachmentId;
  private final boolean appUnfurl;
  private final @Nullable LiteMessage originalMessage;
  private final String responseUrl;
  private final String triggerId;
  private final InteractiveCallbackType type;
  private final String callbackId;
  private final String actionTs;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;
  private final SlackChannel channel;

  private InteractiveAction(
      List<Action> actions,
      String messageTs,
      int attachmentId,
      boolean appUnfurl,
      @Nullable LiteMessage originalMessage,
      String responseUrl,
      String triggerId,
      InteractiveCallbackType type,
      String callbackId,
      String actionTs,
      String token,
      SlackTeam team,
      SlackUserLite user,
      SlackChannel channel) {
    this.actions = actions;
    this.messageTs = messageTs;
    this.attachmentId = attachmentId;
    this.appUnfurl = appUnfurl;
    this.originalMessage = originalMessage;
    this.responseUrl = responseUrl;
    this.triggerId = triggerId;
    this.type = type;
    this.callbackId = callbackId;
    this.actionTs = actionTs;
    this.token = token;
    this.team = team;
    this.user = user;
    this.channel = channel;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @JsonProperty
  @Override
  public List<Action> getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code messageTs} attribute
   */
  @JsonProperty
  @Override
  public String getMessageTs() {
    return messageTs;
  }

  /**
   * @return The value of the {@code attachmentId} attribute
   */
  @JsonProperty
  @Override
  public int getAttachmentId() {
    return attachmentId;
  }

  /**
   * @return The value of the {@code appUnfurl} attribute
   */
  @JsonProperty("is_app_unfurl")
  @Override
  public boolean isAppUnfurl() {
    return appUnfurl;
  }

  /**
   * @return The value of the {@code originalMessage} attribute
   */
  @JsonProperty
  @Override
  public Optional<LiteMessage> getOriginalMessage() {
    return Optional.ofNullable(originalMessage);
  }

  /**
   * @return The value of the {@code responseUrl} attribute
   */
  @JsonProperty
  @Override
  public String getResponseUrl() {
    return responseUrl;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractiveActionIF#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractiveAction withActions(Action... elements) {
    List<Action> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new InteractiveAction(
        newValue,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractiveActionIF#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractiveAction withActions(Iterable<? extends Action> elements) {
    if (this.actions == elements) return this;
    List<Action> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new InteractiveAction(
        newValue,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getMessageTs() messageTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param messageTs A new value for messageTs
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withMessageTs(String messageTs) {
    if (this.messageTs.equals(messageTs)) return this;
    String newValue = Objects.requireNonNull(messageTs, "messageTs");
    return new InteractiveAction(
        this.actions,
        newValue,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getAttachmentId() attachmentId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param attachmentId A new value for attachmentId
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withAttachmentId(int attachmentId) {
    if (this.attachmentId == attachmentId) return this;
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#isAppUnfurl() appUnfurl} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param appUnfurl A new value for appUnfurl
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withAppUnfurl(boolean appUnfurl) {
    if (this.appUnfurl == appUnfurl) return this;
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InteractiveActionIF#getOriginalMessage() originalMessage} attribute.
   * @param value The value for originalMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final InteractiveAction withOriginalMessage(@Nullable LiteMessage value) {
    @Nullable LiteMessage newValue = value;
    if (this.originalMessage == newValue) return this;
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        newValue,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InteractiveActionIF#getOriginalMessage() originalMessage} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for originalMessage
   * @return A modified copy of {@code this} object
   */
  public final InteractiveAction withOriginalMessage(Optional<LiteMessage> optional) {
    @Nullable LiteMessage value = optional.orElse(null);
    if (this.originalMessage == value) return this;
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        value,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getResponseUrl() responseUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param responseUrl A new value for responseUrl
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withResponseUrl(String responseUrl) {
    if (this.responseUrl.equals(responseUrl)) return this;
    String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        newValue,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        newValue,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        newValue,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        newValue,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        newValue,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        newValue,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        newValue,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractiveActionIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final InteractiveAction withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new InteractiveAction(
        this.actions,
        this.messageTs,
        this.attachmentId,
        this.appUnfurl,
        this.originalMessage,
        this.responseUrl,
        this.triggerId,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractiveAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof InteractiveAction
        && equalTo((InteractiveAction) another);
  }

  private boolean equalTo(InteractiveAction another) {
    return actions.equals(another.actions)
        && messageTs.equals(another.messageTs)
        && attachmentId == another.attachmentId
        && appUnfurl == another.appUnfurl
        && Objects.equals(originalMessage, another.originalMessage)
        && responseUrl.equals(another.responseUrl)
        && triggerId.equals(another.triggerId)
        && type.equals(another.type)
        && callbackId.equals(another.callbackId)
        && actionTs.equals(another.actionTs)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user)
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code actions}, {@code messageTs}, {@code attachmentId}, {@code appUnfurl}, {@code originalMessage}, {@code responseUrl}, {@code triggerId}, {@code type}, {@code callbackId}, {@code actionTs}, {@code token}, {@code team}, {@code user}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + actions.hashCode();
    h = h * 17 + messageTs.hashCode();
    h = h * 17 + attachmentId;
    h = h * 17 + Boolean.hashCode(appUnfurl);
    h = h * 17 + Objects.hashCode(originalMessage);
    h = h * 17 + responseUrl.hashCode();
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    h = h * 17 + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractiveAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("InteractiveAction{");
    builder.append("actions=").append(actions);
    builder.append(", ");
    builder.append("messageTs=").append(messageTs);
    builder.append(", ");
    builder.append("attachmentId=").append(attachmentId);
    builder.append(", ");
    builder.append("appUnfurl=").append(appUnfurl);
    if (originalMessage != null) {
      builder.append(", ");
      builder.append("originalMessage=").append(originalMessage);
    }
    builder.append(", ");
    builder.append("responseUrl=").append(responseUrl);
    builder.append(", ");
    builder.append("triggerId=").append(triggerId);
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("callbackId=").append(callbackId);
    builder.append(", ");
    builder.append("actionTs=").append(actionTs);
    builder.append(", ");
    builder.append("token=").append(token);
    builder.append(", ");
    builder.append("team=").append(team);
    builder.append(", ");
    builder.append("user=").append(user);
    builder.append(", ");
    builder.append("channel=").append(channel);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements InteractiveActionIF {
    List<Action> actions = Collections.emptyList();
    @Nullable String messageTs;
    int attachmentId;
    boolean attachmentIdIsSet;
    boolean appUnfurl;
    boolean appUnfurlIsSet;
    Optional<LiteMessage> originalMessage = Optional.empty();
    @Nullable String responseUrl;
    @Nullable String triggerId;
    @Nullable InteractiveCallbackType type;
    @Nullable String callbackId;
    @Nullable String actionTs;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @Nullable SlackChannel channel;
    @JsonProperty
    public void setActions(List<Action> actions) {
      this.actions = actions;
    }
    @JsonProperty
    public void setMessageTs(String messageTs) {
      this.messageTs = messageTs;
    }
    @JsonProperty
    public void setAttachmentId(int attachmentId) {
      this.attachmentId = attachmentId;
      this.attachmentIdIsSet = true;
    }
    @JsonProperty("is_app_unfurl")
    public void setAppUnfurl(boolean appUnfurl) {
      this.appUnfurl = appUnfurl;
      this.appUnfurlIsSet = true;
    }
    @JsonProperty
    public void setOriginalMessage(Optional<LiteMessage> originalMessage) {
      this.originalMessage = originalMessage;
    }
    @JsonProperty
    public void setResponseUrl(String responseUrl) {
      this.responseUrl = responseUrl;
    }
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @Override
    public List<Action> getActions() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessageTs() { throw new UnsupportedOperationException(); }
    @Override
    public int getAttachmentId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isAppUnfurl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<LiteMessage> getOriginalMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getResponseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static InteractiveAction fromJson(Json json) {
    InteractiveAction.Builder builder = InteractiveAction.builder();
    if (json.actions != null) {
      builder.addAllActions(json.actions);
    }
    if (json.messageTs != null) {
      builder.setMessageTs(json.messageTs);
    }
    if (json.attachmentIdIsSet) {
      builder.setAttachmentId(json.attachmentId);
    }
    if (json.appUnfurlIsSet) {
      builder.setAppUnfurl(json.appUnfurl);
    }
    if (json.originalMessage != null) {
      builder.setOriginalMessage(json.originalMessage);
    }
    if (json.responseUrl != null) {
      builder.setResponseUrl(json.responseUrl);
    }
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InteractiveActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractiveAction instance
   */
  public static InteractiveAction copyOf(InteractiveActionIF instance) {
    if (instance instanceof InteractiveAction) {
      return (InteractiveAction) instance;
    }
    return InteractiveAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link InteractiveAction InteractiveAction}.
   * @return A new InteractiveAction builder
   */
  public static InteractiveAction.Builder builder() {
    return new InteractiveAction.Builder();
  }

  /**
   * Builds instances of type {@link InteractiveAction InteractiveAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE_TS = 0x1L;
    private static final long INIT_BIT_ATTACHMENT_ID = 0x2L;
    private static final long INIT_BIT_APP_UNFURL = 0x4L;
    private static final long INIT_BIT_RESPONSE_URL = 0x8L;
    private static final long INIT_BIT_TRIGGER_ID = 0x10L;
    private static final long INIT_BIT_TYPE = 0x20L;
    private static final long INIT_BIT_CALLBACK_ID = 0x40L;
    private static final long INIT_BIT_ACTION_TS = 0x80L;
    private static final long INIT_BIT_TOKEN = 0x100L;
    private static final long INIT_BIT_TEAM = 0x200L;
    private static final long INIT_BIT_USER = 0x400L;
    private static final long INIT_BIT_CHANNEL = 0x800L;
    private long initBits = 0xfffL;

    private List<Action> actions = new ArrayList<Action>();
    private @Nullable String messageTs;
    private int attachmentId;
    private boolean appUnfurl;
    private @Nullable LiteMessage originalMessage;
    private @Nullable String responseUrl;
    private @Nullable String triggerId;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String callbackId;
    private @Nullable String actionTs;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;
    private @Nullable SlackChannel channel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.InteractiveActionIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractiveActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setCallbackId(instance.getCallbackId());
        setChannel(instance.getChannel());
        setTeam(instance.getTeam());
        setType(instance.getType());
        setActionTs(instance.getActionTs());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
      if (object instanceof InteractiveActionIF) {
        InteractiveActionIF instance = (InteractiveActionIF) object;
        setResponseUrl(instance.getResponseUrl());
        setAppUnfurl(instance.isAppUnfurl());
        setTriggerId(instance.getTriggerId());
        setAttachmentId(instance.getAttachmentId());
        Optional<LiteMessage> originalMessageOptional = instance.getOriginalMessage();
        if (originalMessageOptional.isPresent()) {
          setOriginalMessage(originalMessageOptional);
        }
        setMessageTs(instance.getMessageTs());
        addAllActions(instance.getActions());
      }
    }

    /**
     * Adds one element to {@link InteractiveActionIF#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActions(Action element) {
      this.actions.add(Objects.requireNonNull(element, "actions element"));
      return this;
    }

    /**
     * Adds elements to {@link InteractiveActionIF#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActions(Action... elements) {
      for (Action element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link InteractiveActionIF#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActions(Iterable<? extends Action> elements) {
      this.actions.clear();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link InteractiveActionIF#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActions(Iterable<? extends Action> elements) {
      for (Action element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getMessageTs() messageTs} attribute.
     * @param messageTs The value for messageTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageTs(String messageTs) {
      this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
      initBits &= ~INIT_BIT_MESSAGE_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getAttachmentId() attachmentId} attribute.
     * @param attachmentId The value for attachmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachmentId(int attachmentId) {
      this.attachmentId = attachmentId;
      initBits &= ~INIT_BIT_ATTACHMENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#isAppUnfurl() appUnfurl} attribute.
     * @param appUnfurl The value for appUnfurl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAppUnfurl(boolean appUnfurl) {
      this.appUnfurl = appUnfurl;
      initBits &= ~INIT_BIT_APP_UNFURL;
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveActionIF#getOriginalMessage() originalMessage} to originalMessage.
     * @param originalMessage The value for originalMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOriginalMessage(@Nullable LiteMessage originalMessage) {
      this.originalMessage = originalMessage;
      return this;
    }

    /**
     * Initializes the optional value {@link InteractiveActionIF#getOriginalMessage() originalMessage} to originalMessage.
     * @param originalMessage The value for originalMessage
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOriginalMessage(Optional<LiteMessage> originalMessage) {
      this.originalMessage = originalMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getResponseUrl() responseUrl} attribute.
     * @param responseUrl The value for responseUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseUrl(String responseUrl) {
      this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
      initBits &= ~INIT_BIT_RESPONSE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link InteractiveActionIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Builds a new {@link InteractiveAction InteractiveAction}.
     * @return An immutable instance of InteractiveAction
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public InteractiveAction build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new InteractiveAction(
          createUnmodifiableList(true, actions),
          messageTs,
          attachmentId,
          appUnfurl,
          originalMessage,
          responseUrl,
          triggerId,
          type,
          callbackId,
          actionTs,
          token,
          team,
          user,
          channel);
    }

    private boolean messageTsIsSet() {
      return (initBits & INIT_BIT_MESSAGE_TS) == 0;
    }

    private boolean attachmentIdIsSet() {
      return (initBits & INIT_BIT_ATTACHMENT_ID) == 0;
    }

    private boolean appUnfurlIsSet() {
      return (initBits & INIT_BIT_APP_UNFURL) == 0;
    }

    private boolean responseUrlIsSet() {
      return (initBits & INIT_BIT_RESPONSE_URL) == 0;
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!messageTsIsSet()) attributes.add("messageTs");
      if (!attachmentIdIsSet()) attributes.add("attachmentId");
      if (!appUnfurlIsSet()) attributes.add("appUnfurl");
      if (!responseUrlIsSet()) attributes.add("responseUrl");
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!typeIsSet()) attributes.add("type");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      if (!channelIsSet()) attributes.add("channel");
      return "Cannot build InteractiveAction, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
