package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DialogSubmissionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DialogSubmission.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DialogSubmissionIF"})
@Immutable
public final class DialogSubmission implements DialogSubmissionIF {
  private final Map<String, Optional<String>> submission;
  private final @Nullable String state;
  private final InteractiveCallbackType type;
  private final String callbackId;
  private final String actionTs;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;
  private final SlackChannel channel;

  private DialogSubmission(
      Map<String, Optional<String>> submission,
      @Nullable String state,
      InteractiveCallbackType type,
      String callbackId,
      String actionTs,
      String token,
      SlackTeam team,
      SlackUserLite user,
      SlackChannel channel) {
    this.submission = submission;
    this.state = state;
    this.type = type;
    this.callbackId = callbackId;
    this.actionTs = actionTs;
    this.token = token;
    this.team = team;
    this.user = user;
    this.channel = channel;
  }

  /**
   * This map is a key:value mapping of the values the user submitted to the dialog,
   * where the keys are the field names used when creating the dialog.
   */
  @JsonProperty
  @Override
  public Map<String, Optional<String>> getSubmission() {
    return submission;
  }

  /**
   * This state is passed from the dialog creation and is echoed back from the user submission.
   */
  @JsonProperty
  @Override
  public Optional<String> getState() {
    return Optional.ofNullable(state);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * Copy the current immutable object by replacing the {@link DialogSubmissionIF#getSubmission() submission} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param submission The entries to be added to the submission map
   * @return A modified copy of {@code this} object
   */
  public final DialogSubmission withSubmission(Map<String, ? extends Optional<String>> submission) {
    if (this.submission == submission) return this;
    Map<String, Optional<String>> newValue = createUnmodifiableMap(true, false, submission);
    return new DialogSubmission(
        newValue,
        this.state,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DialogSubmissionIF#getState() state} attribute.
   * @param value The value for state, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final DialogSubmission withState(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.state, newValue)) return this;
    return new DialogSubmission(
        this.submission,
        newValue,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DialogSubmissionIF#getState() state} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for state
   * @return A modified copy of {@code this} object
   */
  public final DialogSubmission withState(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.state, value)) return this;
    return new DialogSubmission(
        this.submission,
        value,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new DialogSubmission(
        this.submission,
        this.state,
        newValue,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        newValue,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        this.callbackId,
        newValue,
        this.token,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        this.callbackId,
        this.actionTs,
        newValue,
        this.team,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        newValue,
        this.user,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogSubmissionIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final DialogSubmission withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new DialogSubmission(
        this.submission,
        this.state,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.user,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code DialogSubmission} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof DialogSubmission
        && equalTo((DialogSubmission) another);
  }

  private boolean equalTo(DialogSubmission another) {
    return submission.equals(another.submission)
        && Objects.equals(state, another.state)
        && type.equals(another.type)
        && callbackId.equals(another.callbackId)
        && actionTs.equals(another.actionTs)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user)
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code submission}, {@code state}, {@code type}, {@code callbackId}, {@code actionTs}, {@code token}, {@code team}, {@code user}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + submission.hashCode();
    h = h * 17 + Objects.hashCode(state);
    h = h * 17 + type.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    h = h * 17 + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DialogSubmission} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DialogSubmission{");
    builder.append("submission=").append(submission);
    if (state != null) {
      builder.append(", ");
      builder.append("state=").append(state);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("callbackId=").append(callbackId);
    builder.append(", ");
    builder.append("actionTs=").append(actionTs);
    builder.append(", ");
    builder.append("token=").append(token);
    builder.append(", ");
    builder.append("team=").append(team);
    builder.append(", ");
    builder.append("user=").append(user);
    builder.append(", ");
    builder.append("channel=").append(channel);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialogSubmissionIF {
    @Nullable Map<String, Optional<String>> submission;
    Optional<String> state = Optional.empty();
    @Nullable InteractiveCallbackType type;
    @Nullable String callbackId;
    @Nullable String actionTs;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @Nullable SlackChannel channel;
    @JsonProperty
    public void setSubmission(Map<String, Optional<String>> submission) {
      this.submission = submission;
    }
    @JsonProperty
    public void setState(Optional<String> state) {
      this.state = state;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @Override
    public Map<String, Optional<String>> getSubmission() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getState() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DialogSubmission fromJson(Json json) {
    DialogSubmission.Builder builder = DialogSubmission.builder();
    if (json.submission != null) {
      builder.putAllSubmission(json.submission);
    }
    if (json.state != null) {
      builder.setState(json.state);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialogSubmissionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DialogSubmission instance
   */
  public static DialogSubmission copyOf(DialogSubmissionIF instance) {
    if (instance instanceof DialogSubmission) {
      return (DialogSubmission) instance;
    }
    return DialogSubmission.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link DialogSubmission DialogSubmission}.
   * @return A new DialogSubmission builder
   */
  public static DialogSubmission.Builder builder() {
    return new DialogSubmission.Builder();
  }

  /**
   * Builds instances of type {@link DialogSubmission DialogSubmission}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_CALLBACK_ID = 0x2L;
    private static final long INIT_BIT_ACTION_TS = 0x4L;
    private static final long INIT_BIT_TOKEN = 0x8L;
    private static final long INIT_BIT_TEAM = 0x10L;
    private static final long INIT_BIT_USER = 0x20L;
    private static final long INIT_BIT_CHANNEL = 0x40L;
    private long initBits = 0x7fL;

    private Map<String, Optional<String>> submission = new LinkedHashMap<String, Optional<String>>();
    private @Nullable String state;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String callbackId;
    private @Nullable String actionTs;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;
    private @Nullable SlackChannel channel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.DialogSubmissionIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DialogSubmissionIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialogSubmissionIF) {
        DialogSubmissionIF instance = (DialogSubmissionIF) object;
        putAllSubmission(instance.getSubmission());
        Optional<String> stateOptional = instance.getState();
        if (stateOptional.isPresent()) {
          setState(stateOptional);
        }
      }
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setCallbackId(instance.getCallbackId());
        setChannel(instance.getChannel());
        setTeam(instance.getTeam());
        setType(instance.getType());
        setActionTs(instance.getActionTs());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
    }

    /**
     * Put one entry to the {@link DialogSubmissionIF#getSubmission() submission} map.
     * @param key The key in the submission map
     * @param value The associated value in the submission map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putSubmission(String key, Optional<String> value) {
      this.submission.put(
          Objects.requireNonNull(key, "submission key"),
          Objects.requireNonNull(value, "submission value"));
      return this;
    }

    /**
     * Put one entry to the {@link DialogSubmissionIF#getSubmission() submission} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putSubmission(Map.Entry<String, ? extends Optional<String>> entry) {
      String k = entry.getKey();
      Optional<String> v = entry.getValue();
      this.submission.put(
          Objects.requireNonNull(k, "submission key"),
          Objects.requireNonNull(v, "submission value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialogSubmissionIF#getSubmission() submission} map. Nulls are not permitted
     * @param submission The entries that will be added to the submission map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubmission(Map<String, ? extends Optional<String>> submission) {
      this.submission.clear();
      return putAllSubmission(submission);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialogSubmissionIF#getSubmission() submission} map. Nulls are not permitted
     * @param submission The entries that will be added to the submission map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSubmission(Map<String, ? extends Optional<String>> submission) {
      for (Map.Entry<String, ? extends Optional<String>> entry : submission.entrySet()) {
        String k = entry.getKey();
        Optional<String> v = entry.getValue();
        this.submission.put(
            Objects.requireNonNull(k, "submission key"),
            Objects.requireNonNull(v, "submission value"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link DialogSubmissionIF#getState() state} to state.
     * @param state The value for state, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setState(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the optional value {@link DialogSubmissionIF#getState() state} to state.
     * @param state The value for state
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setState(Optional<String> state) {
      this.state = state.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogSubmissionIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Builds a new {@link DialogSubmission DialogSubmission}.
     * @return An immutable instance of DialogSubmission
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public DialogSubmission build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new DialogSubmission(
          createUnmodifiableMap(false, false, submission),
          state,
          type,
          callbackId,
          actionTs,
          token,
          team,
          user,
          channel);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      if (!channelIsSet()) attributes.add("channel");
      return "Cannot build DialogSubmission, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
