package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BlocksLoadOptionsResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BlocksLoadOptionsResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BlocksLoadOptionsResponseIF"})
@Immutable
public final class BlocksLoadOptionsResponse
    implements BlocksLoadOptionsResponseIF {
  private final List<Option> options;
  private final List<OptionGroup> optionGroups;

  private BlocksLoadOptionsResponse(
      List<Option> options,
      List<OptionGroup> optionGroups) {
    this.options = options;
    this.optionGroups = optionGroups;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public List<Option> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code optionGroups} attribute
   */
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public List<OptionGroup> getOptionGroups() {
    return optionGroups;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlocksLoadOptionsResponseIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlocksLoadOptionsResponse withOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new BlocksLoadOptionsResponse(newValue, this.optionGroups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlocksLoadOptionsResponseIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlocksLoadOptionsResponse withOptions(Iterable<? extends Option> elements) {
    if (this.options == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new BlocksLoadOptionsResponse(newValue, this.optionGroups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlocksLoadOptionsResponse withOptionGroups(OptionGroup... elements) {
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new BlocksLoadOptionsResponse(this.options, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of optionGroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlocksLoadOptionsResponse withOptionGroups(Iterable<? extends OptionGroup> elements) {
    if (this.optionGroups == elements) return this;
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new BlocksLoadOptionsResponse(this.options, newValue);
  }

  /**
   * This instance is equal to all instances of {@code BlocksLoadOptionsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BlocksLoadOptionsResponse
        && equalTo((BlocksLoadOptionsResponse) another);
  }

  private boolean equalTo(BlocksLoadOptionsResponse another) {
    return options.equals(another.options)
        && optionGroups.equals(another.optionGroups);
  }

  /**
   * Computes a hash code from attributes: {@code options}, {@code optionGroups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + options.hashCode();
    h = h * 17 + optionGroups.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlocksLoadOptionsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BlocksLoadOptionsResponse{"
        + "options=" + options
        + ", optionGroups=" + optionGroups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlocksLoadOptionsResponseIF {
    List<Option> options = Collections.emptyList();
    List<OptionGroup> optionGroups = Collections.emptyList();
    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setOptions(List<Option> options) {
      this.options = options;
    }
    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setOptionGroups(List<OptionGroup> optionGroups) {
      this.optionGroups = optionGroups;
    }
    @Override
    public List<Option> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public List<OptionGroup> getOptionGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BlocksLoadOptionsResponse fromJson(Json json) {
    BlocksLoadOptionsResponse.Builder builder = BlocksLoadOptionsResponse.builder();
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.optionGroups != null) {
      builder.addAllOptionGroups(json.optionGroups);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlocksLoadOptionsResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlocksLoadOptionsResponse instance
   */
  public static BlocksLoadOptionsResponse copyOf(BlocksLoadOptionsResponseIF instance) {
    if (instance instanceof BlocksLoadOptionsResponse) {
      return (BlocksLoadOptionsResponse) instance;
    }
    return BlocksLoadOptionsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BlocksLoadOptionsResponse BlocksLoadOptionsResponse}.
   * @return A new BlocksLoadOptionsResponse builder
   */
  public static BlocksLoadOptionsResponse.Builder builder() {
    return new BlocksLoadOptionsResponse.Builder();
  }

  /**
   * Builds instances of type {@link BlocksLoadOptionsResponse BlocksLoadOptionsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<Option> options = new ArrayList<Option>();
    private List<OptionGroup> optionGroups = new ArrayList<OptionGroup>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlocksLoadOptionsResponseIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BlocksLoadOptionsResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      addAllOptions(instance.getOptions());
      addAllOptionGroups(instance.getOptionGroups());
      return this;
    }

    /**
     * Adds one element to {@link BlocksLoadOptionsResponseIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link BlocksLoadOptionsResponseIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option... elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link BlocksLoadOptionsResponseIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends Option> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link BlocksLoadOptionsResponseIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups} list.
     * @param element A optionGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup element) {
      this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups} list.
     * @param elements An array of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup... elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptionGroups(Iterable<? extends OptionGroup> elements) {
      this.optionGroups.clear();
      return addAllOptionGroups(elements);
    }

    /**
     * Adds elements to {@link BlocksLoadOptionsResponseIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptionGroups(Iterable<? extends OptionGroup> elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BlocksLoadOptionsResponse BlocksLoadOptionsResponse}.
     * @return An immutable instance of BlocksLoadOptionsResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public BlocksLoadOptionsResponse build() throws InvalidImmutableStateException {
      return new BlocksLoadOptionsResponse(createUnmodifiableList(true, options), createUnmodifiableList(true, optionGroups));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
