package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BlocksLoadOptionsRequestIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BlocksLoadOptionsRequest.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BlocksLoadOptionsRequestIF"})
@Immutable
public final class BlocksLoadOptionsRequest
    implements BlocksLoadOptionsRequestIF {
  private final String type;
  private final SlackUserLite user;
  private final SlackTeam team;
  private final String token;
  private final String actionId;
  private final String blockId;
  private final String value;
  private final Container container;

  private BlocksLoadOptionsRequest(
      String type,
      SlackUserLite user,
      SlackTeam team,
      String token,
      String actionId,
      String blockId,
      String value,
      Container container) {
    this.type = type;
    this.user = user;
    this.team = team;
    this.token = token;
    this.actionId = actionId;
    this.blockId = blockId;
    this.value = value;
    this.container = container;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public String getBlockId() {
    return blockId;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code container} attribute
   */
  @JsonProperty
  @Override
  public Container getContainer() {
    return container;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withType(String type) {
    if (this.type.equals(type)) return this;
    String newValue = Objects.requireNonNull(type, "type");
    return new BlocksLoadOptionsRequest(
        newValue,
        this.user,
        this.team,
        this.token,
        this.actionId,
        this.blockId,
        this.value,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new BlocksLoadOptionsRequest(
        this.type,
        newValue,
        this.team,
        this.token,
        this.actionId,
        this.blockId,
        this.value,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new BlocksLoadOptionsRequest(
        this.type,
        this.user,
        newValue,
        this.token,
        this.actionId,
        this.blockId,
        this.value,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new BlocksLoadOptionsRequest(
        this.type,
        this.user,
        this.team,
        newValue,
        this.actionId,
        this.blockId,
        this.value,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, newValue, this.blockId, this.value, this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getBlockId() blockId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param blockId A new value for blockId
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withBlockId(String blockId) {
    if (this.blockId.equals(blockId)) return this;
    String newValue = Objects.requireNonNull(blockId, "blockId");
    return new BlocksLoadOptionsRequest(
        this.type,
        this.user,
        this.team,
        this.token,
        this.actionId,
        newValue,
        this.value,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new BlocksLoadOptionsRequest(
        this.type,
        this.user,
        this.team,
        this.token,
        this.actionId,
        this.blockId,
        newValue,
        this.container);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlocksLoadOptionsRequestIF#getContainer() container} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param container A new value for container
   * @return A modified copy of the {@code this} object
   */
  public final BlocksLoadOptionsRequest withContainer(Container container) {
    if (this.container == container) return this;
    Container newValue = Objects.requireNonNull(container, "container");
    return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code BlocksLoadOptionsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BlocksLoadOptionsRequest
        && equalTo((BlocksLoadOptionsRequest) another);
  }

  private boolean equalTo(BlocksLoadOptionsRequest another) {
    return type.equals(another.type)
        && user.equals(another.user)
        && team.equals(another.team)
        && token.equals(another.token)
        && actionId.equals(another.actionId)
        && blockId.equals(another.blockId)
        && value.equals(another.value)
        && container.equals(another.container);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code user}, {@code team}, {@code token}, {@code actionId}, {@code blockId}, {@code value}, {@code container}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + user.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + blockId.hashCode();
    h = h * 17 + value.hashCode();
    h = h * 17 + container.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlocksLoadOptionsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BlocksLoadOptionsRequest{"
        + "type=" + type
        + ", user=" + user
        + ", team=" + team
        + ", token=" + token
        + ", actionId=" + actionId
        + ", blockId=" + blockId
        + ", value=" + value
        + ", container=" + container
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlocksLoadOptionsRequestIF {
    @Nullable String type;
    @Nullable SlackUserLite user;
    @Nullable SlackTeam team;
    @Nullable String token;
    @Nullable String actionId;
    @Nullable String blockId;
    @Nullable String value;
    @Nullable Container container;
    @JsonProperty
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setBlockId(String blockId) {
      this.blockId = blockId;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty
    public void setContainer(Container container) {
      this.container = container;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public String getBlockId() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Container getContainer() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BlocksLoadOptionsRequest fromJson(Json json) {
    BlocksLoadOptionsRequest.Builder builder = BlocksLoadOptionsRequest.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.container != null) {
      builder.setContainer(json.container);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlocksLoadOptionsRequestIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlocksLoadOptionsRequest instance
   */
  public static BlocksLoadOptionsRequest copyOf(BlocksLoadOptionsRequestIF instance) {
    if (instance instanceof BlocksLoadOptionsRequest) {
      return (BlocksLoadOptionsRequest) instance;
    }
    return BlocksLoadOptionsRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BlocksLoadOptionsRequest BlocksLoadOptionsRequest}.
   * @return A new BlocksLoadOptionsRequest builder
   */
  public static BlocksLoadOptionsRequest.Builder builder() {
    return new BlocksLoadOptionsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BlocksLoadOptionsRequest BlocksLoadOptionsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_USER = 0x2L;
    private static final long INIT_BIT_TEAM = 0x4L;
    private static final long INIT_BIT_TOKEN = 0x8L;
    private static final long INIT_BIT_ACTION_ID = 0x10L;
    private static final long INIT_BIT_BLOCK_ID = 0x20L;
    private static final long INIT_BIT_VALUE = 0x40L;
    private static final long INIT_BIT_CONTAINER = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String type;
    private @Nullable SlackUserLite user;
    private @Nullable SlackTeam team;
    private @Nullable String token;
    private @Nullable String actionId;
    private @Nullable String blockId;
    private @Nullable String value;
    private @Nullable Container container;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlocksLoadOptionsRequestIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BlocksLoadOptionsRequestIF instance) {
      Objects.requireNonNull(instance, "instance");
      setType(instance.getType());
      setUser(instance.getUser());
      setTeam(instance.getTeam());
      setToken(instance.getToken());
      setActionId(instance.getActionId());
      setBlockId(instance.getBlockId());
      setValue(instance.getValue());
      setContainer(instance.getContainer());
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getBlockId() blockId} attribute.
     * @param blockId The value for blockId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(String blockId) {
      this.blockId = Objects.requireNonNull(blockId, "blockId");
      initBits &= ~INIT_BIT_BLOCK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link BlocksLoadOptionsRequestIF#getContainer() container} attribute.
     * @param container The value for container 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setContainer(Container container) {
      this.container = Objects.requireNonNull(container, "container");
      initBits &= ~INIT_BIT_CONTAINER;
      return this;
    }

    /**
     * Builds a new {@link BlocksLoadOptionsRequest BlocksLoadOptionsRequest}.
     * @return An immutable instance of BlocksLoadOptionsRequest
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public BlocksLoadOptionsRequest build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new BlocksLoadOptionsRequest(type, user, team, token, actionId, blockId, value, container);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private boolean blockIdIsSet() {
      return (initBits & INIT_BIT_BLOCK_ID) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private boolean containerIsSet() {
      return (initBits & INIT_BIT_CONTAINER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!userIsSet()) attributes.add("user");
      if (!teamIsSet()) attributes.add("team");
      if (!tokenIsSet()) attributes.add("token");
      if (!actionIdIsSet()) attributes.add("actionId");
      if (!blockIdIsSet()) attributes.add("blockId");
      if (!valueIsSet()) attributes.add("value");
      if (!containerIsSet()) attributes.add("container");
      return "Cannot build BlocksLoadOptionsRequest, some of required attributes are not set " + attributes;
    }
  }
}
