package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BlockElementActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BlockElementAction.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BlockElementActionIF"})
@Immutable
public final class BlockElementAction
    implements BlockElementActionIF {
  private final String blockId;
  private final String actionId;
  private final BlockElement element;
  private final @Nullable String selectedValue;
  private final @Nullable LocalDate selectedDate;
  private final @Nullable String actionTs;

  private BlockElementAction(
      String blockId,
      String actionId,
      BlockElement element,
      @Nullable String selectedValue,
      @Nullable LocalDate selectedDate,
      @Nullable String actionTs) {
    this.blockId = blockId;
    this.actionId = actionId;
    this.element = element;
    this.selectedValue = selectedValue;
    this.selectedDate = selectedDate;
    this.actionTs = actionTs;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public String getBlockId() {
    return blockId;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code element} attribute
   */
  @JsonProperty
  @Override
  public BlockElement getElement() {
    return element;
  }

  /**
   * @return The value of the {@code selectedValue} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getSelectedValue() {
    return Optional.ofNullable(selectedValue);
  }

  /**
   * @return The value of the {@code selectedDate} attribute
   */
  @JsonProperty("selected_date")
  @Override
  public Optional<LocalDate> getSelectedDate() {
    return Optional.ofNullable(selectedDate);
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getActionTs() {
    return Optional.ofNullable(actionTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockElementActionIF#getBlockId() blockId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param blockId A new value for blockId
   * @return A modified copy of the {@code this} object
   */
  public final BlockElementAction withBlockId(String blockId) {
    if (this.blockId.equals(blockId)) return this;
    String newValue = Objects.requireNonNull(blockId, "blockId");
    return new BlockElementAction(newValue, this.actionId, this.element, this.selectedValue, this.selectedDate, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockElementActionIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final BlockElementAction withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new BlockElementAction(this.blockId, newValue, this.element, this.selectedValue, this.selectedDate, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockElementActionIF#getElement() element} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param element A new value for element
   * @return A modified copy of the {@code this} object
   */
  public final BlockElementAction withElement(BlockElement element) {
    if (this.element == element) return this;
    BlockElement newValue = Objects.requireNonNull(element, "element");
    return new BlockElementAction(this.blockId, this.actionId, newValue, this.selectedValue, this.selectedDate, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockElementActionIF#getSelectedValue() selectedValue} attribute.
   * @param value The value for selectedValue, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withSelectedValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.selectedValue, newValue)) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, newValue, this.selectedDate, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockElementActionIF#getSelectedValue() selectedValue} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for selectedValue
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withSelectedValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.selectedValue, value)) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, value, this.selectedDate, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockElementActionIF#getSelectedDate() selectedDate} attribute.
   * @param value The value for selectedDate, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withSelectedDate(@Nullable LocalDate value) {
    @Nullable LocalDate newValue = value;
    if (this.selectedDate == newValue) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, newValue, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockElementActionIF#getSelectedDate() selectedDate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for selectedDate
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withSelectedDate(Optional<LocalDate> optional) {
    @Nullable LocalDate value = optional.orElse(null);
    if (this.selectedDate == value) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, value, this.actionTs);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockElementActionIF#getActionTs() actionTs} attribute.
   * @param value The value for actionTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withActionTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.actionTs, newValue)) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, this.selectedDate, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockElementActionIF#getActionTs() actionTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for actionTs
   * @return A modified copy of {@code this} object
   */
  public final BlockElementAction withActionTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.actionTs, value)) return this;
    return new BlockElementAction(this.blockId, this.actionId, this.element, this.selectedValue, this.selectedDate, value);
  }

  /**
   * This instance is equal to all instances of {@code BlockElementAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BlockElementAction
        && equalTo((BlockElementAction) another);
  }

  private boolean equalTo(BlockElementAction another) {
    return blockId.equals(another.blockId)
        && actionId.equals(another.actionId)
        && element.equals(another.element)
        && Objects.equals(selectedValue, another.selectedValue)
        && Objects.equals(selectedDate, another.selectedDate)
        && Objects.equals(actionTs, another.actionTs);
  }

  /**
   * Computes a hash code from attributes: {@code blockId}, {@code actionId}, {@code element}, {@code selectedValue}, {@code selectedDate}, {@code actionTs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + blockId.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + element.hashCode();
    h = h * 17 + Objects.hashCode(selectedValue);
    h = h * 17 + Objects.hashCode(selectedDate);
    h = h * 17 + Objects.hashCode(actionTs);
    return h;
  }

  /**
   * Prints the immutable value {@code BlockElementAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("BlockElementAction{");
    builder.append("blockId=").append(blockId);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    builder.append(", ");
    builder.append("element=").append(element);
    if (selectedValue != null) {
      builder.append(", ");
      builder.append("selectedValue=").append(selectedValue);
    }
    if (selectedDate != null) {
      builder.append(", ");
      builder.append("selectedDate=").append(selectedDate);
    }
    if (actionTs != null) {
      builder.append(", ");
      builder.append("actionTs=").append(actionTs);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlockElementActionIF {
    @Nullable String blockId;
    @Nullable String actionId;
    @Nullable BlockElement element;
    Optional<String> selectedValue = Optional.empty();
    Optional<LocalDate> selectedDate = Optional.empty();
    Optional<String> actionTs = Optional.empty();
    @JsonProperty
    public void setBlockId(String blockId) {
      this.blockId = blockId;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setElement(BlockElement element) {
      this.element = element;
    }
    @JsonProperty
    public void setSelectedValue(Optional<String> selectedValue) {
      this.selectedValue = selectedValue;
    }
    @JsonProperty("selected_date")
    public void setSelectedDate(Optional<LocalDate> selectedDate) {
      this.selectedDate = selectedDate;
    }
    @JsonProperty
    public void setActionTs(Optional<String> actionTs) {
      this.actionTs = actionTs;
    }
    @Override
    public String getBlockId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public BlockElement getElement() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSelectedValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<LocalDate> getSelectedDate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getActionTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BlockElementAction fromJson(Json json) {
    BlockElementAction.Builder builder = BlockElementAction.builder();
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.element != null) {
      builder.setElement(json.element);
    }
    if (json.selectedValue != null) {
      builder.setSelectedValue(json.selectedValue);
    }
    if (json.selectedDate != null) {
      builder.setSelectedDate(json.selectedDate);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlockElementActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlockElementAction instance
   */
  public static BlockElementAction copyOf(BlockElementActionIF instance) {
    if (instance instanceof BlockElementAction) {
      return (BlockElementAction) instance;
    }
    return BlockElementAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BlockElementAction BlockElementAction}.
   * @return A new BlockElementAction builder
   */
  public static BlockElementAction.Builder builder() {
    return new BlockElementAction.Builder();
  }

  /**
   * Builds instances of type {@link BlockElementAction BlockElementAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BLOCK_ID = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private static final long INIT_BIT_ELEMENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String blockId;
    private @Nullable String actionId;
    private @Nullable BlockElement element;
    private @Nullable String selectedValue;
    private @Nullable LocalDate selectedDate;
    private @Nullable String actionTs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlockElementActionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BlockElementActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      setBlockId(instance.getBlockId());
      setActionId(instance.getActionId());
      setElement(instance.getElement());
      Optional<String> selectedValueOptional = instance.getSelectedValue();
      if (selectedValueOptional.isPresent()) {
        setSelectedValue(selectedValueOptional);
      }
      Optional<LocalDate> selectedDateOptional = instance.getSelectedDate();
      if (selectedDateOptional.isPresent()) {
        setSelectedDate(selectedDateOptional);
      }
      Optional<String> actionTsOptional = instance.getActionTs();
      if (actionTsOptional.isPresent()) {
        setActionTs(actionTsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BlockElementActionIF#getBlockId() blockId} attribute.
     * @param blockId The value for blockId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(String blockId) {
      this.blockId = Objects.requireNonNull(blockId, "blockId");
      initBits &= ~INIT_BIT_BLOCK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlockElementActionIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlockElementActionIF#getElement() element} attribute.
     * @param element The value for element 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setElement(BlockElement element) {
      this.element = Objects.requireNonNull(element, "element");
      initBits &= ~INIT_BIT_ELEMENT;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getSelectedValue() selectedValue} to selectedValue.
     * @param selectedValue The value for selectedValue, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSelectedValue(@Nullable String selectedValue) {
      this.selectedValue = selectedValue;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getSelectedValue() selectedValue} to selectedValue.
     * @param selectedValue The value for selectedValue
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedValue(Optional<String> selectedValue) {
      this.selectedValue = selectedValue.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getSelectedDate() selectedDate} to selectedDate.
     * @param selectedDate The value for selectedDate, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSelectedDate(@Nullable LocalDate selectedDate) {
      this.selectedDate = selectedDate;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getSelectedDate() selectedDate} to selectedDate.
     * @param selectedDate The value for selectedDate
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedDate(Optional<LocalDate> selectedDate) {
      this.selectedDate = selectedDate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getActionTs() actionTs} to actionTs.
     * @param actionTs The value for actionTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setActionTs(@Nullable String actionTs) {
      this.actionTs = actionTs;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockElementActionIF#getActionTs() actionTs} to actionTs.
     * @param actionTs The value for actionTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(Optional<String> actionTs) {
      this.actionTs = actionTs.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link BlockElementAction BlockElementAction}.
     * @return An immutable instance of BlockElementAction
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public BlockElementAction build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new BlockElementAction(blockId, actionId, element, selectedValue, selectedDate, actionTs);
    }

    private boolean blockIdIsSet() {
      return (initBits & INIT_BIT_BLOCK_ID) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private boolean elementIsSet() {
      return (initBits & INIT_BIT_ELEMENT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!blockIdIsSet()) attributes.add("blockId");
      if (!actionIdIsSet()) attributes.add("actionId");
      if (!elementIsSet()) attributes.add("element");
      return "Cannot build BlockElementAction, some of required attributes are not set " + attributes;
    }
  }
}
