package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.views.ViewResponseBase;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BlockActionsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BlockActions.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BlockActionsIF"})
@Immutable
public final class BlockActions implements BlockActionsIF {
  private final String triggerId;
  private final @Nullable String responseUrl;
  private final @Nullable LiteMessage message;
  private final @Nullable ViewResponseBase view;
  private final List<BlockElementAction> elementActions;
  private final InteractiveCallbackType type;
  private final String token;
  private final SlackTeam team;
  private final SlackUserLite user;

  private BlockActions(
      String triggerId,
      @Nullable String responseUrl,
      @Nullable LiteMessage message,
      @Nullable ViewResponseBase view,
      List<BlockElementAction> elementActions,
      InteractiveCallbackType type,
      String token,
      SlackTeam team,
      SlackUserLite user) {
    this.triggerId = triggerId;
    this.responseUrl = responseUrl;
    this.message = message;
    this.view = view;
    this.elementActions = elementActions;
    this.type = type;
    this.token = token;
    this.team = team;
    this.user = user;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code responseUrl} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getResponseUrl() {
    return Optional.ofNullable(responseUrl);
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty
  @Override
  public Optional<LiteMessage> getMessage() {
    return Optional.ofNullable(message);
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public Optional<ViewResponseBase> getView() {
    return Optional.ofNullable(view);
  }

  /**
   * @return The value of the {@code elementActions} attribute
   */
  @JsonProperty("actions")
  @Override
  public List<BlockElementAction> getElementActions() {
    return elementActions;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockActionsIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final BlockActions withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new BlockActions(
        newValue,
        this.responseUrl,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockActionsIF#getResponseUrl() responseUrl} attribute.
   * @param value The value for responseUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withResponseUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.responseUrl, newValue)) return this;
    return new BlockActions(
        this.triggerId,
        newValue,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockActionsIF#getResponseUrl() responseUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseUrl
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withResponseUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.responseUrl, value)) return this;
    return new BlockActions(
        this.triggerId,
        value,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockActionsIF#getMessage() message} attribute.
   * @param value The value for message, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withMessage(@Nullable LiteMessage value) {
    @Nullable LiteMessage newValue = value;
    if (this.message == newValue) return this;
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        newValue,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockActionsIF#getMessage() message} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for message
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withMessage(Optional<LiteMessage> optional) {
    @Nullable LiteMessage value = optional.orElse(null);
    if (this.message == value) return this;
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        value,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link BlockActionsIF#getView() view} attribute.
   * @param value The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withView(@Nullable ViewResponseBase value) {
    @Nullable ViewResponseBase newValue = value;
    if (this.view == newValue) return this;
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        newValue,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BlockActionsIF#getView() view} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for view
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withView(Optional<ViewResponseBase> optional) {
    @Nullable ViewResponseBase value = optional.orElse(null);
    if (this.view == value) return this;
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        value,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockActionsIF#getElementActions() elementActions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withElementActions(BlockElementAction... elements) {
    List<BlockElementAction> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        newValue,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockActionsIF#getElementActions() elementActions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elementActions elements to set
   * @return A modified copy of {@code this} object
   */
  public final BlockActions withElementActions(Iterable<? extends BlockElementAction> elements) {
    if (this.elementActions == elements) return this;
    List<BlockElementAction> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        newValue,
        this.type,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockActionsIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final BlockActions withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        this.elementActions,
        newValue,
        this.token,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockActionsIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final BlockActions withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        newValue,
        this.team,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockActionsIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final BlockActions withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        newValue,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlockActionsIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final BlockActions withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new BlockActions(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.view,
        this.elementActions,
        this.type,
        this.token,
        this.team,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code BlockActions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BlockActions
        && equalTo((BlockActions) another);
  }

  private boolean equalTo(BlockActions another) {
    return triggerId.equals(another.triggerId)
        && Objects.equals(responseUrl, another.responseUrl)
        && Objects.equals(message, another.message)
        && Objects.equals(view, another.view)
        && elementActions.equals(another.elementActions)
        && type.equals(another.type)
        && token.equals(another.token)
        && team.equals(another.team)
        && user.equals(another.user);
  }

  /**
   * Computes a hash code from attributes: {@code triggerId}, {@code responseUrl}, {@code message}, {@code view}, {@code elementActions}, {@code type}, {@code token}, {@code team}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + Objects.hashCode(responseUrl);
    h = h * 17 + Objects.hashCode(message);
    h = h * 17 + Objects.hashCode(view);
    h = h * 17 + elementActions.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + user.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlockActions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("BlockActions{");
    builder.append("triggerId=").append(triggerId);
    if (responseUrl != null) {
      builder.append(", ");
      builder.append("responseUrl=").append(responseUrl);
    }
    if (message != null) {
      builder.append(", ");
      builder.append("message=").append(message);
    }
    if (view != null) {
      builder.append(", ");
      builder.append("view=").append(view);
    }
    builder.append(", ");
    builder.append("elementActions=").append(elementActions);
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("token=").append(token);
    builder.append(", ");
    builder.append("team=").append(team);
    builder.append(", ");
    builder.append("user=").append(user);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlockActionsIF {
    @Nullable String triggerId;
    Optional<String> responseUrl = Optional.empty();
    Optional<LiteMessage> message = Optional.empty();
    Optional<ViewResponseBase> view = Optional.empty();
    List<BlockElementAction> elementActions = Collections.emptyList();
    @Nullable InteractiveCallbackType type;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackUserLite user;
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setResponseUrl(Optional<String> responseUrl) {
      this.responseUrl = responseUrl;
    }
    @JsonProperty
    public void setMessage(Optional<LiteMessage> message) {
      this.message = message;
    }
    @JsonProperty
    public void setView(Optional<ViewResponseBase> view) {
      this.view = view;
    }
    @JsonProperty("actions")
    public void setElementActions(List<BlockElementAction> elementActions) {
      this.elementActions = elementActions;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getResponseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<LiteMessage> getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ViewResponseBase> getView() { throw new UnsupportedOperationException(); }
    @Override
    public List<BlockElementAction> getElementActions() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BlockActions fromJson(Json json) {
    BlockActions.Builder builder = BlockActions.builder();
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.responseUrl != null) {
      builder.setResponseUrl(json.responseUrl);
    }
    if (json.message != null) {
      builder.setMessage(json.message);
    }
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.elementActions != null) {
      builder.addAllElementActions(json.elementActions);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlockActionsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlockActions instance
   */
  public static BlockActions copyOf(BlockActionsIF instance) {
    if (instance instanceof BlockActions) {
      return (BlockActions) instance;
    }
    return BlockActions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BlockActions BlockActions}.
   * @return A new BlockActions builder
   */
  public static BlockActions.Builder builder() {
    return new BlockActions.Builder();
  }

  /**
   * Builds instances of type {@link BlockActions BlockActions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRIGGER_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_TOKEN = 0x4L;
    private static final long INIT_BIT_TEAM = 0x8L;
    private static final long INIT_BIT_USER = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String triggerId;
    private @Nullable String responseUrl;
    private @Nullable LiteMessage message;
    private @Nullable ViewResponseBase view;
    private List<BlockElementAction> elementActions = new ArrayList<BlockElementAction>();
    private @Nullable InteractiveCallbackType type;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackUserLite user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.BlockActionsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BlockActionsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setTeam(instance.getTeam());
        setType(instance.getType());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
      if (object instanceof BlockActionsIF) {
        BlockActionsIF instance = (BlockActionsIF) object;
        Optional<String> responseUrlOptional = instance.getResponseUrl();
        if (responseUrlOptional.isPresent()) {
          setResponseUrl(responseUrlOptional);
        }
        addAllElementActions(instance.getElementActions());
        Optional<ViewResponseBase> viewOptional = instance.getView();
        if (viewOptional.isPresent()) {
          setView(viewOptional);
        }
        Optional<LiteMessage> messageOptional = instance.getMessage();
        if (messageOptional.isPresent()) {
          setMessage(messageOptional);
        }
        setTriggerId(instance.getTriggerId());
      }
    }

    /**
     * Initializes the value for the {@link BlockActionsIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getResponseUrl() responseUrl} to responseUrl.
     * @param responseUrl The value for responseUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseUrl(@Nullable String responseUrl) {
      this.responseUrl = responseUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getResponseUrl() responseUrl} to responseUrl.
     * @param responseUrl The value for responseUrl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseUrl(Optional<String> responseUrl) {
      this.responseUrl = responseUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getMessage() message} to message.
     * @param message The value for message, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMessage(@Nullable LiteMessage message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getMessage() message} to message.
     * @param message The value for message
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(Optional<LiteMessage> message) {
      this.message = message.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getView() view} to view.
     * @param view The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setView(@Nullable ViewResponseBase view) {
      this.view = view;
      return this;
    }

    /**
     * Initializes the optional value {@link BlockActionsIF#getView() view} to view.
     * @param view The value for view
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(Optional<ViewResponseBase> view) {
      this.view = view.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link BlockActionsIF#getElementActions() elementActions} list.
     * @param element A elementActions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElementActions(BlockElementAction element) {
      this.elementActions.add(Objects.requireNonNull(element, "elementActions element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockActionsIF#getElementActions() elementActions} list.
     * @param elements An array of elementActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElementActions(BlockElementAction... elements) {
      for (BlockElementAction element : elements) {
        this.elementActions.add(Objects.requireNonNull(element, "elementActions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link BlockActionsIF#getElementActions() elementActions} list.
     * @param elements An iterable of elementActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setElementActions(Iterable<? extends BlockElementAction> elements) {
      this.elementActions.clear();
      return addAllElementActions(elements);
    }

    /**
     * Adds elements to {@link BlockActionsIF#getElementActions() elementActions} list.
     * @param elements An iterable of elementActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllElementActions(Iterable<? extends BlockElementAction> elements) {
      for (BlockElementAction element : elements) {
        this.elementActions.add(Objects.requireNonNull(element, "elementActions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BlockActionsIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link BlockActionsIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link BlockActionsIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link BlockActionsIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Builds a new {@link BlockActions BlockActions}.
     * @return An immutable instance of BlockActions
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public BlockActions build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new BlockActions(
          triggerId,
          responseUrl,
          message,
          view,
          createUnmodifiableList(true, elementActions),
          type,
          token,
          team,
          user);
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!typeIsSet()) attributes.add("type");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!userIsSet()) attributes.add("user");
      return "Cannot build BlockActions, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
