package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackUnknownFiletypeIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackUnknownFiletype.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackUnknownFiletypeIF"})
@Immutable
public final class SlackUnknownFiletype
    implements SlackUnknownFiletypeIF {
  private final String id;
  private final long createdEpochSeconds;
  private final long timestampEpochSeconds;
  private final String name;
  private final String title;
  private final String mimetype;
  private final SlackFileType filetype;
  private final String prettyType;
  private final String userId;
  private final boolean editable;
  private final long size;
  private final String mode;
  private final boolean external;
  private final boolean isPublic;
  private final boolean publicUrlShared;
  private final boolean displayAsBot;
  private final String username;
  private final String urlPrivate;
  private final @Nullable String urlPrivateDownload;
  private final String permalink;
  private final @Nullable String permalinkPublic;
  private final int commentsCount;
  private final @Nullable Boolean starred;
  private final List<String> channelIds;
  private final List<String> groupIds;
  private final List<String> imIds;

  private SlackUnknownFiletype(SlackUnknownFiletype.Builder builder) {
    this.urlPrivateDownload = builder.urlPrivateDownload;
    this.permalinkPublic = builder.permalinkPublic;
    this.starred = builder.starred;
    this.channelIds = createUnmodifiableList(true, builder.channelIds);
    this.groupIds = createUnmodifiableList(true, builder.groupIds);
    this.imIds = createUnmodifiableList(true, builder.imIds);
    if (builder.id != null) {
      initShim.setId(builder.id);
    }
    if (builder.createdEpochSecondsIsSet()) {
      initShim.setCreatedEpochSeconds(builder.createdEpochSeconds);
    }
    if (builder.timestampEpochSecondsIsSet()) {
      initShim.setTimestampEpochSeconds(builder.timestampEpochSeconds);
    }
    if (builder.name != null) {
      initShim.setName(builder.name);
    }
    if (builder.title != null) {
      initShim.setTitle(builder.title);
    }
    if (builder.mimetype != null) {
      initShim.setMimetype(builder.mimetype);
    }
    if (builder.filetype != null) {
      initShim.setFiletype(builder.filetype);
    }
    if (builder.prettyType != null) {
      initShim.setPrettyType(builder.prettyType);
    }
    if (builder.userId != null) {
      initShim.setUserId(builder.userId);
    }
    if (builder.editableIsSet()) {
      initShim.setEditable(builder.editable);
    }
    if (builder.sizeIsSet()) {
      initShim.setSize(builder.size);
    }
    if (builder.mode != null) {
      initShim.setMode(builder.mode);
    }
    if (builder.externalIsSet()) {
      initShim.setExternal(builder.external);
    }
    if (builder.isPublicIsSet()) {
      initShim.setIsPublic(builder.isPublic);
    }
    if (builder.publicUrlSharedIsSet()) {
      initShim.setPublicUrlShared(builder.publicUrlShared);
    }
    if (builder.displayAsBotIsSet()) {
      initShim.setDisplayAsBot(builder.displayAsBot);
    }
    if (builder.username != null) {
      initShim.setUsername(builder.username);
    }
    if (builder.urlPrivate != null) {
      initShim.setUrlPrivate(builder.urlPrivate);
    }
    if (builder.permalink != null) {
      initShim.setPermalink(builder.permalink);
    }
    if (builder.commentsCountIsSet()) {
      initShim.setCommentsCount(builder.commentsCount);
    }
    this.id = initShim.getId();
    this.createdEpochSeconds = initShim.getCreatedEpochSeconds();
    this.timestampEpochSeconds = initShim.getTimestampEpochSeconds();
    this.name = initShim.getName();
    this.title = initShim.getTitle();
    this.mimetype = initShim.getMimetype();
    this.filetype = initShim.getFiletype();
    this.prettyType = initShim.getPrettyType();
    this.userId = initShim.getUserId();
    this.editable = initShim.isEditable();
    this.size = initShim.getSize();
    this.mode = initShim.getMode();
    this.external = initShim.isExternal();
    this.isPublic = initShim.isPublic();
    this.publicUrlShared = initShim.isPublicUrlShared();
    this.displayAsBot = initShim.getDisplayAsBot();
    this.username = initShim.getUsername();
    this.urlPrivate = initShim.getUrlPrivate();
    this.permalink = initShim.getPermalink();
    this.commentsCount = initShim.getCommentsCount();
    this.initShim = null;
  }

  private SlackUnknownFiletype(
      String id,
      long createdEpochSeconds,
      long timestampEpochSeconds,
      String name,
      String title,
      String mimetype,
      SlackFileType filetype,
      String prettyType,
      String userId,
      boolean editable,
      long size,
      String mode,
      boolean external,
      boolean isPublic,
      boolean publicUrlShared,
      boolean displayAsBot,
      String username,
      String urlPrivate,
      @Nullable String urlPrivateDownload,
      String permalink,
      @Nullable String permalinkPublic,
      int commentsCount,
      @Nullable Boolean starred,
      List<String> channelIds,
      List<String> groupIds,
      List<String> imIds) {
    this.id = id;
    this.createdEpochSeconds = createdEpochSeconds;
    this.timestampEpochSeconds = timestampEpochSeconds;
    this.name = name;
    this.title = title;
    this.mimetype = mimetype;
    this.filetype = filetype;
    this.prettyType = prettyType;
    this.userId = userId;
    this.editable = editable;
    this.size = size;
    this.mode = mode;
    this.external = external;
    this.isPublic = isPublic;
    this.publicUrlShared = publicUrlShared;
    this.displayAsBot = displayAsBot;
    this.username = username;
    this.urlPrivate = urlPrivate;
    this.urlPrivateDownload = urlPrivateDownload;
    this.permalink = permalink;
    this.permalinkPublic = permalinkPublic;
    this.commentsCount = commentsCount;
    this.starred = starred;
    this.channelIds = channelIds;
    this.groupIds = groupIds;
    this.imIds = imIds;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String id;
    private int idStage;

    String getId() {
      if (idStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (idStage == STAGE_UNINITIALIZED) {
        idStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void setId(String id) {
      this.id = id;
      idStage = STAGE_INITIALIZED;
    }
    private long createdEpochSeconds;
    private int createdEpochSecondsStage;

    long getCreatedEpochSeconds() {
      if (createdEpochSecondsStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (createdEpochSecondsStage == STAGE_UNINITIALIZED) {
        createdEpochSecondsStage = STAGE_INITIALIZING;
        this.createdEpochSeconds = getCreatedEpochSecondsInitialize();
        createdEpochSecondsStage = STAGE_INITIALIZED;
      }
      return this.createdEpochSeconds;
    }

    void setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      createdEpochSecondsStage = STAGE_INITIALIZED;
    }
    private long timestampEpochSeconds;
    private int timestampEpochSecondsStage;

    long getTimestampEpochSeconds() {
      if (timestampEpochSecondsStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (timestampEpochSecondsStage == STAGE_UNINITIALIZED) {
        timestampEpochSecondsStage = STAGE_INITIALIZING;
        this.timestampEpochSeconds = getTimestampEpochSecondsInitialize();
        timestampEpochSecondsStage = STAGE_INITIALIZED;
      }
      return this.timestampEpochSeconds;
    }

    void setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      timestampEpochSecondsStage = STAGE_INITIALIZED;
    }
    private String name;
    private int nameStage;

    String getName() {
      if (nameStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (nameStage == STAGE_UNINITIALIZED) {
        nameStage = STAGE_INITIALIZING;
        this.name = Objects.requireNonNull(getNameInitialize(), "name");
        nameStage = STAGE_INITIALIZED;
      }
      return this.name;
    }

    void setName(String name) {
      this.name = name;
      nameStage = STAGE_INITIALIZED;
    }
    private String title;
    private int titleStage;

    String getTitle() {
      if (titleStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (titleStage == STAGE_UNINITIALIZED) {
        titleStage = STAGE_INITIALIZING;
        this.title = Objects.requireNonNull(getTitleInitialize(), "title");
        titleStage = STAGE_INITIALIZED;
      }
      return this.title;
    }

    void setTitle(String title) {
      this.title = title;
      titleStage = STAGE_INITIALIZED;
    }
    private String mimetype;
    private int mimetypeStage;

    String getMimetype() {
      if (mimetypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (mimetypeStage == STAGE_UNINITIALIZED) {
        mimetypeStage = STAGE_INITIALIZING;
        this.mimetype = Objects.requireNonNull(getMimetypeInitialize(), "mimetype");
        mimetypeStage = STAGE_INITIALIZED;
      }
      return this.mimetype;
    }

    void setMimetype(String mimetype) {
      this.mimetype = mimetype;
      mimetypeStage = STAGE_INITIALIZED;
    }
    private SlackFileType filetype;
    private int filetypeStage;

    SlackFileType getFiletype() {
      if (filetypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (filetypeStage == STAGE_UNINITIALIZED) {
        filetypeStage = STAGE_INITIALIZING;
        this.filetype = Objects.requireNonNull(getFiletypeInitialize(), "filetype");
        filetypeStage = STAGE_INITIALIZED;
      }
      return this.filetype;
    }

    void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
      filetypeStage = STAGE_INITIALIZED;
    }
    private String prettyType;
    private int prettyTypeStage;

    String getPrettyType() {
      if (prettyTypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (prettyTypeStage == STAGE_UNINITIALIZED) {
        prettyTypeStage = STAGE_INITIALIZING;
        this.prettyType = Objects.requireNonNull(getPrettyTypeInitialize(), "prettyType");
        prettyTypeStage = STAGE_INITIALIZED;
      }
      return this.prettyType;
    }

    void setPrettyType(String prettyType) {
      this.prettyType = prettyType;
      prettyTypeStage = STAGE_INITIALIZED;
    }
    private String userId;
    private int userIdStage;

    String getUserId() {
      if (userIdStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (userIdStage == STAGE_UNINITIALIZED) {
        userIdStage = STAGE_INITIALIZING;
        this.userId = Objects.requireNonNull(getUserIdInitialize(), "userId");
        userIdStage = STAGE_INITIALIZED;
      }
      return this.userId;
    }

    void setUserId(String userId) {
      this.userId = userId;
      userIdStage = STAGE_INITIALIZED;
    }
    private boolean editable;
    private int editableStage;

    boolean isEditable() {
      if (editableStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (editableStage == STAGE_UNINITIALIZED) {
        editableStage = STAGE_INITIALIZING;
        this.editable = isEditableInitialize();
        editableStage = STAGE_INITIALIZED;
      }
      return this.editable;
    }

    void setEditable(boolean editable) {
      this.editable = editable;
      editableStage = STAGE_INITIALIZED;
    }
    private long size;
    private int sizeStage;

    long getSize() {
      if (sizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (sizeStage == STAGE_UNINITIALIZED) {
        sizeStage = STAGE_INITIALIZING;
        this.size = getSizeInitialize();
        sizeStage = STAGE_INITIALIZED;
      }
      return this.size;
    }

    void setSize(long size) {
      this.size = size;
      sizeStage = STAGE_INITIALIZED;
    }
    private String mode;
    private int modeStage;

    String getMode() {
      if (modeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (modeStage == STAGE_UNINITIALIZED) {
        modeStage = STAGE_INITIALIZING;
        this.mode = Objects.requireNonNull(getModeInitialize(), "mode");
        modeStage = STAGE_INITIALIZED;
      }
      return this.mode;
    }

    void setMode(String mode) {
      this.mode = mode;
      modeStage = STAGE_INITIALIZED;
    }
    private boolean external;
    private int externalStage;

    boolean isExternal() {
      if (externalStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (externalStage == STAGE_UNINITIALIZED) {
        externalStage = STAGE_INITIALIZING;
        this.external = isExternalInitialize();
        externalStage = STAGE_INITIALIZED;
      }
      return this.external;
    }

    void setExternal(boolean external) {
      this.external = external;
      externalStage = STAGE_INITIALIZED;
    }
    private boolean isPublic;
    private int isPublicStage;

    boolean isPublic() {
      if (isPublicStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (isPublicStage == STAGE_UNINITIALIZED) {
        isPublicStage = STAGE_INITIALIZING;
        this.isPublic = isPublicInitialize();
        isPublicStage = STAGE_INITIALIZED;
      }
      return this.isPublic;
    }

    void setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      isPublicStage = STAGE_INITIALIZED;
    }
    private boolean publicUrlShared;
    private int publicUrlSharedStage;

    boolean isPublicUrlShared() {
      if (publicUrlSharedStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (publicUrlSharedStage == STAGE_UNINITIALIZED) {
        publicUrlSharedStage = STAGE_INITIALIZING;
        this.publicUrlShared = isPublicUrlSharedInitialize();
        publicUrlSharedStage = STAGE_INITIALIZED;
      }
      return this.publicUrlShared;
    }

    void setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      publicUrlSharedStage = STAGE_INITIALIZED;
    }
    private boolean displayAsBot;
    private int displayAsBotStage;

    boolean getDisplayAsBot() {
      if (displayAsBotStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (displayAsBotStage == STAGE_UNINITIALIZED) {
        displayAsBotStage = STAGE_INITIALIZING;
        this.displayAsBot = getDisplayAsBotInitialize();
        displayAsBotStage = STAGE_INITIALIZED;
      }
      return this.displayAsBot;
    }

    void setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      displayAsBotStage = STAGE_INITIALIZED;
    }
    private String username;
    private int usernameStage;

    String getUsername() {
      if (usernameStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (usernameStage == STAGE_UNINITIALIZED) {
        usernameStage = STAGE_INITIALIZING;
        this.username = Objects.requireNonNull(getUsernameInitialize(), "username");
        usernameStage = STAGE_INITIALIZED;
      }
      return this.username;
    }

    void setUsername(String username) {
      this.username = username;
      usernameStage = STAGE_INITIALIZED;
    }
    private String urlPrivate;
    private int urlPrivateStage;

    String getUrlPrivate() {
      if (urlPrivateStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (urlPrivateStage == STAGE_UNINITIALIZED) {
        urlPrivateStage = STAGE_INITIALIZING;
        this.urlPrivate = Objects.requireNonNull(getUrlPrivateInitialize(), "urlPrivate");
        urlPrivateStage = STAGE_INITIALIZED;
      }
      return this.urlPrivate;
    }

    void setUrlPrivate(String urlPrivate) {
      this.urlPrivate = urlPrivate;
      urlPrivateStage = STAGE_INITIALIZED;
    }
    private String permalink;
    private int permalinkStage;

    String getPermalink() {
      if (permalinkStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (permalinkStage == STAGE_UNINITIALIZED) {
        permalinkStage = STAGE_INITIALIZING;
        this.permalink = Objects.requireNonNull(getPermalinkInitialize(), "permalink");
        permalinkStage = STAGE_INITIALIZED;
      }
      return this.permalink;
    }

    void setPermalink(String permalink) {
      this.permalink = permalink;
      permalinkStage = STAGE_INITIALIZED;
    }
    private int commentsCount;
    private int commentsCountStage;

    int getCommentsCount() {
      if (commentsCountStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (commentsCountStage == STAGE_UNINITIALIZED) {
        commentsCountStage = STAGE_INITIALIZING;
        this.commentsCount = getCommentsCountInitialize();
        commentsCountStage = STAGE_INITIALIZED;
      }
      return this.commentsCount;
    }

    void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      commentsCountStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (idStage == STAGE_INITIALIZING) attributes.add("id");
      if (createdEpochSecondsStage == STAGE_INITIALIZING) attributes.add("createdEpochSeconds");
      if (timestampEpochSecondsStage == STAGE_INITIALIZING) attributes.add("timestampEpochSeconds");
      if (nameStage == STAGE_INITIALIZING) attributes.add("name");
      if (titleStage == STAGE_INITIALIZING) attributes.add("title");
      if (mimetypeStage == STAGE_INITIALIZING) attributes.add("mimetype");
      if (filetypeStage == STAGE_INITIALIZING) attributes.add("filetype");
      if (prettyTypeStage == STAGE_INITIALIZING) attributes.add("prettyType");
      if (userIdStage == STAGE_INITIALIZING) attributes.add("userId");
      if (editableStage == STAGE_INITIALIZING) attributes.add("editable");
      if (sizeStage == STAGE_INITIALIZING) attributes.add("size");
      if (modeStage == STAGE_INITIALIZING) attributes.add("mode");
      if (externalStage == STAGE_INITIALIZING) attributes.add("external");
      if (isPublicStage == STAGE_INITIALIZING) attributes.add("isPublic");
      if (publicUrlSharedStage == STAGE_INITIALIZING) attributes.add("publicUrlShared");
      if (displayAsBotStage == STAGE_INITIALIZING) attributes.add("displayAsBot");
      if (usernameStage == STAGE_INITIALIZING) attributes.add("username");
      if (urlPrivateStage == STAGE_INITIALIZING) attributes.add("urlPrivate");
      if (permalinkStage == STAGE_INITIALIZING) attributes.add("permalink");
      if (commentsCountStage == STAGE_INITIALIZING) attributes.add("commentsCount");
      return "Cannot build SlackUnknownFiletype, attribute initializers form cycle" + attributes;
    }
  }

  private String getIdInitialize() {
    return SlackUnknownFiletypeIF.super.getId();
  }

  private long getCreatedEpochSecondsInitialize() {
    return SlackUnknownFiletypeIF.super.getCreatedEpochSeconds();
  }

  private long getTimestampEpochSecondsInitialize() {
    return SlackUnknownFiletypeIF.super.getTimestampEpochSeconds();
  }

  private String getNameInitialize() {
    return SlackUnknownFiletypeIF.super.getName();
  }

  private String getTitleInitialize() {
    return SlackUnknownFiletypeIF.super.getTitle();
  }

  private String getMimetypeInitialize() {
    return SlackUnknownFiletypeIF.super.getMimetype();
  }

  private SlackFileType getFiletypeInitialize() {
    return SlackUnknownFiletypeIF.super.getFiletype();
  }

  private String getPrettyTypeInitialize() {
    return SlackUnknownFiletypeIF.super.getPrettyType();
  }

  private String getUserIdInitialize() {
    return SlackUnknownFiletypeIF.super.getUserId();
  }

  private boolean isEditableInitialize() {
    return SlackUnknownFiletypeIF.super.isEditable();
  }

  private long getSizeInitialize() {
    return SlackUnknownFiletypeIF.super.getSize();
  }

  private String getModeInitialize() {
    return SlackUnknownFiletypeIF.super.getMode();
  }

  private boolean isExternalInitialize() {
    return SlackUnknownFiletypeIF.super.isExternal();
  }

  private boolean isPublicInitialize() {
    return SlackUnknownFiletypeIF.super.isPublic();
  }

  private boolean isPublicUrlSharedInitialize() {
    return SlackUnknownFiletypeIF.super.isPublicUrlShared();
  }

  private boolean getDisplayAsBotInitialize() {
    return SlackUnknownFiletypeIF.super.getDisplayAsBot();
  }

  private String getUsernameInitialize() {
    return SlackUnknownFiletypeIF.super.getUsername();
  }

  private String getUrlPrivateInitialize() {
    return SlackUnknownFiletypeIF.super.getUrlPrivate();
  }

  private String getPermalinkInitialize() {
    return SlackUnknownFiletypeIF.super.getPermalink();
  }

  private int getCommentsCountInitialize() {
    return SlackUnknownFiletypeIF.super.getCommentsCount();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code createdEpochSeconds} attribute
   */
  @JsonProperty
  @Override
  public long getCreatedEpochSeconds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreatedEpochSeconds()
        : this.createdEpochSeconds;
  }

  /**
   * @return The value of the {@code timestampEpochSeconds} attribute
   */
  @JsonProperty
  @Override
  public long getTimestampEpochSeconds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTimestampEpochSeconds()
        : this.timestampEpochSeconds;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getName()
        : this.name;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public String getTitle() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTitle()
        : this.title;
  }

  /**
   * @return The value of the {@code mimetype} attribute
   */
  @JsonProperty
  @Override
  public String getMimetype() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMimetype()
        : this.mimetype;
  }

  /**
   * @return The value of the {@code filetype} attribute
   */
  @JsonProperty
  @Override
  public SlackFileType getFiletype() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFiletype()
        : this.filetype;
  }

  /**
   * @return The value of the {@code prettyType} attribute
   */
  @JsonProperty
  @Override
  public String getPrettyType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPrettyType()
        : this.prettyType;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty
  @Override
  public String getUserId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUserId()
        : this.userId;
  }

  /**
   * @return The value of the {@code editable} attribute
   */
  @JsonProperty
  @Override
  public boolean isEditable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isEditable()
        : this.editable;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty
  @Override
  public long getSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSize()
        : this.size;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty
  @Override
  public String getMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMode()
        : this.mode;
  }

  /**
   * @return The value of the {@code external} attribute
   */
  @JsonProperty
  @Override
  public boolean isExternal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isExternal()
        : this.external;
  }

  /**
   * @return The value of the {@code isPublic} attribute
   */
  @JsonProperty
  @Override
  public boolean isPublic() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPublic()
        : this.isPublic;
  }

  /**
   * @return The value of the {@code publicUrlShared} attribute
   */
  @JsonProperty
  @Override
  public boolean isPublicUrlShared() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isPublicUrlShared()
        : this.publicUrlShared;
  }

  /**
   * @return The value of the {@code displayAsBot} attribute
   */
  @JsonProperty
  @Override
  public boolean getDisplayAsBot() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDisplayAsBot()
        : this.displayAsBot;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty
  @Override
  public String getUsername() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsername()
        : this.username;
  }

  /**
   * @return The value of the {@code urlPrivate} attribute
   */
  @JsonProperty
  @Override
  public String getUrlPrivate() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUrlPrivate()
        : this.urlPrivate;
  }

  /**
   * @return The value of the {@code urlPrivateDownload} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrlPrivateDownload() {
    return Optional.ofNullable(urlPrivateDownload);
  }

  /**
   * @return The value of the {@code permalink} attribute
   */
  @JsonProperty
  @Override
  public String getPermalink() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPermalink()
        : this.permalink;
  }

  /**
   * @return The value of the {@code permalinkPublic} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPermalinkPublic() {
    return Optional.ofNullable(permalinkPublic);
  }

  /**
   * @return The value of the {@code commentsCount} attribute
   */
  @JsonProperty
  @Override
  public int getCommentsCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCommentsCount()
        : this.commentsCount;
  }

  /**
   * @return The value of the {@code starred} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isStarred() {
    return Optional.ofNullable(starred);
  }

  /**
   * @return The value of the {@code channelIds} attribute
   */
  @JsonProperty
  @Override
  public List<String> getChannelIds() {
    return channelIds;
  }

  /**
   * @return The value of the {@code groupIds} attribute
   */
  @JsonProperty
  @Override
  public List<String> getGroupIds() {
    return groupIds;
  }

  /**
   * @return The value of the {@code imIds} attribute
   */
  @JsonProperty
  @Override
  public List<String> getImIds() {
    return imIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackUnknownFiletype(
        newValue,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param createdEpochSeconds A new value for createdEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withCreatedEpochSeconds(long createdEpochSeconds) {
    if (this.createdEpochSeconds == createdEpochSeconds) return this;
    return new SlackUnknownFiletype(
        this.id,
        createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param timestampEpochSeconds A new value for timestampEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withTimestampEpochSeconds(long timestampEpochSeconds) {
    if (this.timestampEpochSeconds == timestampEpochSeconds) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        newValue,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        newValue,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getMimetype() mimetype} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mimetype A new value for mimetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withMimetype(String mimetype) {
    if (this.mimetype.equals(mimetype)) return this;
    String newValue = Objects.requireNonNull(mimetype, "mimetype");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        newValue,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getFiletype() filetype} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param filetype A new value for filetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withFiletype(SlackFileType filetype) {
    if (this.filetype == filetype) return this;
    SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        newValue,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getPrettyType() prettyType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param prettyType A new value for prettyType
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withPrettyType(String prettyType) {
    if (this.prettyType.equals(prettyType)) return this;
    String newValue = Objects.requireNonNull(prettyType, "prettyType");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        newValue,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        newValue,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#isEditable() editable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param editable A new value for editable
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withEditable(boolean editable) {
    if (this.editable == editable) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getSize() size} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param size A new value for size
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withSize(long size) {
    if (this.size == size) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getMode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mode A new value for mode
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withMode(String mode) {
    if (this.mode.equals(mode)) return this;
    String newValue = Objects.requireNonNull(mode, "mode");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        newValue,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#isExternal() external} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param external A new value for external
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withExternal(boolean external) {
    if (this.external == external) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#isPublic() isPublic} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isPublic A new value for isPublic
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withIsPublic(boolean isPublic) {
    if (this.isPublic == isPublic) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#isPublicUrlShared() publicUrlShared} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param publicUrlShared A new value for publicUrlShared
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withPublicUrlShared(boolean publicUrlShared) {
    if (this.publicUrlShared == publicUrlShared) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getDisplayAsBot() displayAsBot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param displayAsBot A new value for displayAsBot
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withDisplayAsBot(boolean displayAsBot) {
    if (this.displayAsBot == displayAsBot) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getUsername() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param username A new value for username
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withUsername(String username) {
    if (this.username.equals(username)) return this;
    String newValue = Objects.requireNonNull(username, "username");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        newValue,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getUrlPrivate() urlPrivate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param urlPrivate A new value for urlPrivate
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withUrlPrivate(String urlPrivate) {
    if (this.urlPrivate.equals(urlPrivate)) return this;
    String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        newValue,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUnknownFiletypeIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * @param value The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withUrlPrivateDownload(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.urlPrivateDownload, newValue)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        newValue,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUnknownFiletypeIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for urlPrivateDownload
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withUrlPrivateDownload(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.urlPrivateDownload, value)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        value,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getPermalink() permalink} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param permalink A new value for permalink
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withPermalink(String permalink) {
    if (this.permalink.equals(permalink)) return this;
    String newValue = Objects.requireNonNull(permalink, "permalink");
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        newValue,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUnknownFiletypeIF#getPermalinkPublic() permalinkPublic} attribute.
   * @param value The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withPermalinkPublic(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.permalinkPublic, newValue)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        newValue,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUnknownFiletypeIF#getPermalinkPublic() permalinkPublic} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for permalinkPublic
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withPermalinkPublic(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.permalinkPublic, value)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        value,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUnknownFiletypeIF#getCommentsCount() commentsCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param commentsCount A new value for commentsCount
   * @return A modified copy of the {@code this} object
   */
  public final SlackUnknownFiletype withCommentsCount(int commentsCount) {
    if (this.commentsCount == commentsCount) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUnknownFiletypeIF#isStarred() starred} attribute.
   * @param value The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withStarred(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.starred, newValue)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        newValue,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUnknownFiletypeIF#isStarred() starred} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for starred
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withStarred(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.starred, value)) return this;
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        value,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getChannelIds() channelIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withChannelIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getChannelIds() channelIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channelIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withChannelIds(Iterable<String> elements) {
    if (this.channelIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getGroupIds() groupIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withGroupIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getGroupIds() groupIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withGroupIds(Iterable<String> elements) {
    if (this.groupIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getImIds() imIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withImIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackUnknownFiletypeIF#getImIds() imIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of imIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackUnknownFiletype withImIds(Iterable<String> elements) {
    if (this.imIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackUnknownFiletype(
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.filetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackUnknownFiletype} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackUnknownFiletype
        && equalTo((SlackUnknownFiletype) another);
  }

  private boolean equalTo(SlackUnknownFiletype another) {
    return id.equals(another.id)
        && createdEpochSeconds == another.createdEpochSeconds
        && timestampEpochSeconds == another.timestampEpochSeconds
        && name.equals(another.name)
        && title.equals(another.title)
        && mimetype.equals(another.mimetype)
        && filetype.equals(another.filetype)
        && prettyType.equals(another.prettyType)
        && userId.equals(another.userId)
        && editable == another.editable
        && size == another.size
        && mode.equals(another.mode)
        && external == another.external
        && isPublic == another.isPublic
        && publicUrlShared == another.publicUrlShared
        && displayAsBot == another.displayAsBot
        && username.equals(another.username)
        && urlPrivate.equals(another.urlPrivate)
        && Objects.equals(urlPrivateDownload, another.urlPrivateDownload)
        && permalink.equals(another.permalink)
        && Objects.equals(permalinkPublic, another.permalinkPublic)
        && commentsCount == another.commentsCount
        && Objects.equals(starred, another.starred)
        && channelIds.equals(another.channelIds)
        && groupIds.equals(another.groupIds)
        && imIds.equals(another.imIds);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code createdEpochSeconds}, {@code timestampEpochSeconds}, {@code name}, {@code title}, {@code mimetype}, {@code filetype}, {@code prettyType}, {@code userId}, {@code editable}, {@code size}, {@code mode}, {@code external}, {@code isPublic}, {@code publicUrlShared}, {@code displayAsBot}, {@code username}, {@code urlPrivate}, {@code urlPrivateDownload}, {@code permalink}, {@code permalinkPublic}, {@code commentsCount}, {@code starred}, {@code channelIds}, {@code groupIds}, {@code imIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + Long.hashCode(createdEpochSeconds);
    h = h * 17 + Long.hashCode(timestampEpochSeconds);
    h = h * 17 + name.hashCode();
    h = h * 17 + title.hashCode();
    h = h * 17 + mimetype.hashCode();
    h = h * 17 + filetype.hashCode();
    h = h * 17 + prettyType.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + Boolean.hashCode(editable);
    h = h * 17 + Long.hashCode(size);
    h = h * 17 + mode.hashCode();
    h = h * 17 + Boolean.hashCode(external);
    h = h * 17 + Boolean.hashCode(isPublic);
    h = h * 17 + Boolean.hashCode(publicUrlShared);
    h = h * 17 + Boolean.hashCode(displayAsBot);
    h = h * 17 + username.hashCode();
    h = h * 17 + urlPrivate.hashCode();
    h = h * 17 + Objects.hashCode(urlPrivateDownload);
    h = h * 17 + permalink.hashCode();
    h = h * 17 + Objects.hashCode(permalinkPublic);
    h = h * 17 + commentsCount;
    h = h * 17 + Objects.hashCode(starred);
    h = h * 17 + channelIds.hashCode();
    h = h * 17 + groupIds.hashCode();
    h = h * 17 + imIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackUnknownFiletype} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackUnknownFiletype{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("createdEpochSeconds=").append(createdEpochSeconds);
    builder.append(", ");
    builder.append("timestampEpochSeconds=").append(timestampEpochSeconds);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("title=").append(title);
    builder.append(", ");
    builder.append("mimetype=").append(mimetype);
    builder.append(", ");
    builder.append("filetype=").append(filetype);
    builder.append(", ");
    builder.append("prettyType=").append(prettyType);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("editable=").append(editable);
    builder.append(", ");
    builder.append("size=").append(size);
    builder.append(", ");
    builder.append("mode=").append(mode);
    builder.append(", ");
    builder.append("external=").append(external);
    builder.append(", ");
    builder.append("isPublic=").append(isPublic);
    builder.append(", ");
    builder.append("publicUrlShared=").append(publicUrlShared);
    builder.append(", ");
    builder.append("displayAsBot=").append(displayAsBot);
    builder.append(", ");
    builder.append("username=").append(username);
    builder.append(", ");
    builder.append("urlPrivate=").append(urlPrivate);
    if (urlPrivateDownload != null) {
      builder.append(", ");
      builder.append("urlPrivateDownload=").append(urlPrivateDownload);
    }
    builder.append(", ");
    builder.append("permalink=").append(permalink);
    if (permalinkPublic != null) {
      builder.append(", ");
      builder.append("permalinkPublic=").append(permalinkPublic);
    }
    builder.append(", ");
    builder.append("commentsCount=").append(commentsCount);
    if (starred != null) {
      builder.append(", ");
      builder.append("starred=").append(starred);
    }
    builder.append(", ");
    builder.append("channelIds=").append(channelIds);
    builder.append(", ");
    builder.append("groupIds=").append(groupIds);
    builder.append(", ");
    builder.append("imIds=").append(imIds);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackUnknownFiletypeIF {
    @Nullable String id;
    long createdEpochSeconds;
    boolean createdEpochSecondsIsSet;
    long timestampEpochSeconds;
    boolean timestampEpochSecondsIsSet;
    @Nullable String name;
    @Nullable String title;
    @Nullable String mimetype;
    @Nullable SlackFileType filetype;
    @Nullable String prettyType;
    @Nullable String userId;
    boolean editable;
    boolean editableIsSet;
    long size;
    boolean sizeIsSet;
    @Nullable String mode;
    boolean external;
    boolean externalIsSet;
    boolean isPublic;
    boolean isPublicIsSet;
    boolean publicUrlShared;
    boolean publicUrlSharedIsSet;
    boolean displayAsBot;
    boolean displayAsBotIsSet;
    @Nullable String username;
    @Nullable String urlPrivate;
    Optional<String> urlPrivateDownload = Optional.empty();
    @Nullable String permalink;
    Optional<String> permalinkPublic = Optional.empty();
    int commentsCount;
    boolean commentsCountIsSet;
    Optional<Boolean> starred = Optional.empty();
    List<String> channelIds = Collections.emptyList();
    List<String> groupIds = Collections.emptyList();
    List<String> imIds = Collections.emptyList();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      this.createdEpochSecondsIsSet = true;
    }
    @JsonProperty
    public void setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      this.timestampEpochSecondsIsSet = true;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty
    public void setMimetype(String mimetype) {
      this.mimetype = mimetype;
    }
    @JsonProperty
    public void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
    }
    @JsonProperty
    public void setPrettyType(String prettyType) {
      this.prettyType = prettyType;
    }
    @JsonProperty
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setEditable(boolean editable) {
      this.editable = editable;
      this.editableIsSet = true;
    }
    @JsonProperty
    public void setSize(long size) {
      this.size = size;
      this.sizeIsSet = true;
    }
    @JsonProperty
    public void setMode(String mode) {
      this.mode = mode;
    }
    @JsonProperty
    public void setExternal(boolean external) {
      this.external = external;
      this.externalIsSet = true;
    }
    @JsonProperty
    public void setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      this.isPublicIsSet = true;
    }
    @JsonProperty
    public void setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      this.publicUrlSharedIsSet = true;
    }
    @JsonProperty
    public void setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      this.displayAsBotIsSet = true;
    }
    @JsonProperty
    public void setUsername(String username) {
      this.username = username;
    }
    @JsonProperty
    public void setUrlPrivate(String urlPrivate) {
      this.urlPrivate = urlPrivate;
    }
    @JsonProperty
    public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
    }
    @JsonProperty
    public void setPermalink(String permalink) {
      this.permalink = permalink;
    }
    @JsonProperty
    public void setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
    }
    @JsonProperty
    public void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      this.commentsCountIsSet = true;
    }
    @JsonProperty
    public void setStarred(Optional<Boolean> starred) {
      this.starred = starred;
    }
    @JsonProperty
    public void setChannelIds(List<String> channelIds) {
      this.channelIds = channelIds;
    }
    @JsonProperty
    public void setGroupIds(List<String> groupIds) {
      this.groupIds = groupIds;
    }
    @JsonProperty
    public void setImIds(List<String> imIds) {
      this.imIds = imIds;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public long getCreatedEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public long getTimestampEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getMimetype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackFileType getFiletype() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrettyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isEditable() { throw new UnsupportedOperationException(); }
    @Override
    public long getSize() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isExternal() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublic() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublicUrlShared() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDisplayAsBot() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrlPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrlPrivateDownload() { throw new UnsupportedOperationException(); }
    @Override
    public String getPermalink() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPermalinkPublic() { throw new UnsupportedOperationException(); }
    @Override
    public int getCommentsCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isStarred() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChannelIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getImIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackUnknownFiletype fromJson(Json json) {
    SlackUnknownFiletype.Builder builder = SlackUnknownFiletype.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.createdEpochSecondsIsSet) {
      builder.setCreatedEpochSeconds(json.createdEpochSeconds);
    }
    if (json.timestampEpochSecondsIsSet) {
      builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.mimetype != null) {
      builder.setMimetype(json.mimetype);
    }
    if (json.filetype != null) {
      builder.setFiletype(json.filetype);
    }
    if (json.prettyType != null) {
      builder.setPrettyType(json.prettyType);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.editableIsSet) {
      builder.setEditable(json.editable);
    }
    if (json.sizeIsSet) {
      builder.setSize(json.size);
    }
    if (json.mode != null) {
      builder.setMode(json.mode);
    }
    if (json.externalIsSet) {
      builder.setExternal(json.external);
    }
    if (json.isPublicIsSet) {
      builder.setIsPublic(json.isPublic);
    }
    if (json.publicUrlSharedIsSet) {
      builder.setPublicUrlShared(json.publicUrlShared);
    }
    if (json.displayAsBotIsSet) {
      builder.setDisplayAsBot(json.displayAsBot);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.urlPrivate != null) {
      builder.setUrlPrivate(json.urlPrivate);
    }
    if (json.urlPrivateDownload != null) {
      builder.setUrlPrivateDownload(json.urlPrivateDownload);
    }
    if (json.permalink != null) {
      builder.setPermalink(json.permalink);
    }
    if (json.permalinkPublic != null) {
      builder.setPermalinkPublic(json.permalinkPublic);
    }
    if (json.commentsCountIsSet) {
      builder.setCommentsCount(json.commentsCount);
    }
    if (json.starred != null) {
      builder.setStarred(json.starred);
    }
    if (json.channelIds != null) {
      builder.addAllChannelIds(json.channelIds);
    }
    if (json.groupIds != null) {
      builder.addAllGroupIds(json.groupIds);
    }
    if (json.imIds != null) {
      builder.addAllImIds(json.imIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackUnknownFiletypeIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackUnknownFiletype instance
   */
  public static SlackUnknownFiletype copyOf(SlackUnknownFiletypeIF instance) {
    if (instance instanceof SlackUnknownFiletype) {
      return (SlackUnknownFiletype) instance;
    }
    return SlackUnknownFiletype.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackUnknownFiletype SlackUnknownFiletype}.
   * @return A new SlackUnknownFiletype builder
   */
  public static SlackUnknownFiletype.Builder builder() {
    return new SlackUnknownFiletype.Builder();
  }

  /**
   * Builds instances of type {@link SlackUnknownFiletype SlackUnknownFiletype}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_CREATED_EPOCH_SECONDS = 0x1L;
    private static final long OPT_BIT_TIMESTAMP_EPOCH_SECONDS = 0x2L;
    private static final long OPT_BIT_EDITABLE = 0x4L;
    private static final long OPT_BIT_SIZE = 0x8L;
    private static final long OPT_BIT_EXTERNAL = 0x10L;
    private static final long OPT_BIT_IS_PUBLIC = 0x20L;
    private static final long OPT_BIT_PUBLIC_URL_SHARED = 0x40L;
    private static final long OPT_BIT_DISPLAY_AS_BOT = 0x80L;
    private static final long OPT_BIT_COMMENTS_COUNT = 0x100L;
    private long optBits;

    private @Nullable String id;
    private long createdEpochSeconds;
    private long timestampEpochSeconds;
    private @Nullable String name;
    private @Nullable String title;
    private @Nullable String mimetype;
    private @Nullable SlackFileType filetype;
    private @Nullable String prettyType;
    private @Nullable String userId;
    private boolean editable;
    private long size;
    private @Nullable String mode;
    private boolean external;
    private boolean isPublic;
    private boolean publicUrlShared;
    private boolean displayAsBot;
    private @Nullable String username;
    private @Nullable String urlPrivate;
    private @Nullable String urlPrivateDownload;
    private @Nullable String permalink;
    private @Nullable String permalinkPublic;
    private int commentsCount;
    private @Nullable Boolean starred;
    private List<String> channelIds = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();
    private List<String> imIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackUnknownFiletypeIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUnknownFiletypeIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackFile} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackFile instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackUnknownFiletypeIF) {
        SlackUnknownFiletypeIF instance = (SlackUnknownFiletypeIF) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          setTitle(instance.getTitle());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          setDisplayAsBot(instance.getDisplayAsBot());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllImIds(instance.getImIds());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
          if (urlPrivateDownloadOptional.isPresent()) {
            setUrlPrivateDownload(urlPrivateDownloadOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          setMode(instance.getMode());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Optional<Boolean> starredOptional = instance.isStarred();
          if (starredOptional.isPresent()) {
            setStarred(starredOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          setUrlPrivate(instance.getUrlPrivate());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          setPrettyType(instance.getPrettyType());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          addAllGroupIds(instance.getGroupIds());
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          setPublicUrlShared(instance.isPublicUrlShared());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          setIsPublic(instance.isPublic());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          setId(instance.getId());
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          addAllChannelIds(instance.getChannelIds());
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
          bits |= 0x8000L;
        }
        if ((bits & 0x10000L) == 0) {
          setEditable(instance.isEditable());
          bits |= 0x10000L;
        }
        if ((bits & 0x20000L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x20000L;
        }
        if ((bits & 0x40000L) == 0) {
          setExternal(instance.isExternal());
          bits |= 0x40000L;
        }
        if ((bits & 0x80000L) == 0) {
          setSize(instance.getSize());
          bits |= 0x80000L;
        }
        if ((bits & 0x100000L) == 0) {
          setCommentsCount(instance.getCommentsCount());
          bits |= 0x100000L;
        }
        if ((bits & 0x200000L) == 0) {
          setName(instance.getName());
          bits |= 0x200000L;
        }
        if ((bits & 0x400000L) == 0) {
          setMimetype(instance.getMimetype());
          bits |= 0x400000L;
        }
        if ((bits & 0x800000L) == 0) {
          Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
          if (permalinkPublicOptional.isPresent()) {
            setPermalinkPublic(permalinkPublicOptional);
          }
          bits |= 0x800000L;
        }
        if ((bits & 0x1000000L) == 0) {
          setPermalink(instance.getPermalink());
          bits |= 0x1000000L;
        }
        if ((bits & 0x2000000L) == 0) {
          setUsername(instance.getUsername());
          bits |= 0x2000000L;
        }
      }
      if (object instanceof SlackFile) {
        SlackFile instance = (SlackFile) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          setTitle(instance.getTitle());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          setDisplayAsBot(instance.getDisplayAsBot());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllImIds(instance.getImIds());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
          if (urlPrivateDownloadOptional.isPresent()) {
            setUrlPrivateDownload(urlPrivateDownloadOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          setMode(instance.getMode());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Optional<Boolean> starredOptional = instance.isStarred();
          if (starredOptional.isPresent()) {
            setStarred(starredOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          setUrlPrivate(instance.getUrlPrivate());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          setPrettyType(instance.getPrettyType());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          addAllGroupIds(instance.getGroupIds());
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          setPublicUrlShared(instance.isPublicUrlShared());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          setIsPublic(instance.isPublic());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          setId(instance.getId());
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          addAllChannelIds(instance.getChannelIds());
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
          bits |= 0x8000L;
        }
        if ((bits & 0x10000L) == 0) {
          setEditable(instance.isEditable());
          bits |= 0x10000L;
        }
        if ((bits & 0x20000L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x20000L;
        }
        if ((bits & 0x40000L) == 0) {
          setExternal(instance.isExternal());
          bits |= 0x40000L;
        }
        if ((bits & 0x80000L) == 0) {
          setSize(instance.getSize());
          bits |= 0x80000L;
        }
        if ((bits & 0x100000L) == 0) {
          setCommentsCount(instance.getCommentsCount());
          bits |= 0x100000L;
        }
        if ((bits & 0x200000L) == 0) {
          setName(instance.getName());
          bits |= 0x200000L;
        }
        if ((bits & 0x400000L) == 0) {
          setMimetype(instance.getMimetype());
          bits |= 0x400000L;
        }
        if ((bits & 0x800000L) == 0) {
          Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
          if (permalinkPublicOptional.isPresent()) {
            setPermalinkPublic(permalinkPublicOptional);
          }
          bits |= 0x800000L;
        }
        if ((bits & 0x1000000L) == 0) {
          setPermalink(instance.getPermalink());
          bits |= 0x1000000L;
        }
        if ((bits & 0x2000000L) == 0) {
          setUsername(instance.getUsername());
          bits |= 0x2000000L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getCreatedEpochSeconds() createdEpochSeconds}.</em>
     * @param createdEpochSeconds The value for createdEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      optBits |= OPT_BIT_CREATED_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getTimestampEpochSeconds() timestampEpochSeconds}.</em>
     * @param timestampEpochSeconds The value for timestampEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      optBits |= OPT_BIT_TIMESTAMP_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getName() name} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getName() name}.</em>
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getTitle() title} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getTitle() title}.</em>
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getMimetype() mimetype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getMimetype() mimetype}.</em>
     * @param mimetype The value for mimetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMimetype(String mimetype) {
      this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getFiletype() filetype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getFiletype() filetype}.</em>
     * @param filetype The value for filetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFiletype(SlackFileType filetype) {
      this.filetype = Objects.requireNonNull(filetype, "filetype");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getPrettyType() prettyType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getPrettyType() prettyType}.</em>
     * @param prettyType The value for prettyType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrettyType(String prettyType) {
      this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getUserId() userId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getUserId() userId}.</em>
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#isEditable() editable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#isEditable() editable}.</em>
     * @param editable The value for editable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEditable(boolean editable) {
      this.editable = editable;
      optBits |= OPT_BIT_EDITABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getSize() size} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getSize() size}.</em>
     * @param size The value for size 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSize(long size) {
      this.size = size;
      optBits |= OPT_BIT_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getMode() mode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getMode() mode}.</em>
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMode(String mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#isExternal() external} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#isExternal() external}.</em>
     * @param external The value for external 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternal(boolean external) {
      this.external = external;
      optBits |= OPT_BIT_EXTERNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#isPublic() isPublic} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#isPublic() isPublic}.</em>
     * @param isPublic The value for isPublic 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      optBits |= OPT_BIT_IS_PUBLIC;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#isPublicUrlShared() publicUrlShared} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#isPublicUrlShared() publicUrlShared}.</em>
     * @param publicUrlShared The value for publicUrlShared 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      optBits |= OPT_BIT_PUBLIC_URL_SHARED;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getDisplayAsBot() displayAsBot} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getDisplayAsBot() displayAsBot}.</em>
     * @param displayAsBot The value for displayAsBot 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      optBits |= OPT_BIT_DISPLAY_AS_BOT;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getUsername() username} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getUsername() username}.</em>
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(String username) {
      this.username = Objects.requireNonNull(username, "username");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getUrlPrivate() urlPrivate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getUrlPrivate() urlPrivate}.</em>
     * @param urlPrivate The value for urlPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivate(String urlPrivate) {
      this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getPermalink() permalink} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getPermalink() permalink}.</em>
     * @param permalink The value for permalink 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalink(String permalink) {
      this.permalink = Objects.requireNonNull(permalink, "permalink");
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUnknownFiletypeIF#getCommentsCount() commentsCount} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackUnknownFiletypeIF#getCommentsCount() commentsCount}.</em>
     * @param commentsCount The value for commentsCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      optBits |= OPT_BIT_COMMENTS_COUNT;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#isStarred() starred} to starred.
     * @param starred The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStarred(@Nullable Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUnknownFiletypeIF#isStarred() starred} to starred.
     * @param starred The value for starred
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStarred(Optional<Boolean> starred) {
      this.starred = starred.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link SlackUnknownFiletypeIF#getChannelIds() channelIds} list.
     * @param element A channelIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String element) {
      this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getChannelIds() channelIds} list.
     * @param elements An array of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String... elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackUnknownFiletypeIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelIds(Iterable<String> elements) {
      this.channelIds.clear();
      return addAllChannelIds(elements);
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChannelIds(Iterable<String> elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackUnknownFiletypeIF#getGroupIds() groupIds} list.
     * @param element A groupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String element) {
      this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getGroupIds() groupIds} list.
     * @param elements An array of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String... elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackUnknownFiletypeIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGroupIds(Iterable<String> elements) {
      this.groupIds.clear();
      return addAllGroupIds(elements);
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroupIds(Iterable<String> elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackUnknownFiletypeIF#getImIds() imIds} list.
     * @param element A imIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String element) {
      this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getImIds() imIds} list.
     * @param elements An array of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String... elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackUnknownFiletypeIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImIds(Iterable<String> elements) {
      this.imIds.clear();
      return addAllImIds(elements);
    }

    /**
     * Adds elements to {@link SlackUnknownFiletypeIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllImIds(Iterable<String> elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SlackUnknownFiletype SlackUnknownFiletype}.
     * @return An immutable instance of SlackUnknownFiletype
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackUnknownFiletype build() throws InvalidImmutableStateException {
      return new SlackUnknownFiletype(this);
    }

    private boolean createdEpochSecondsIsSet() {
      return (optBits & OPT_BIT_CREATED_EPOCH_SECONDS) != 0;
    }

    private boolean timestampEpochSecondsIsSet() {
      return (optBits & OPT_BIT_TIMESTAMP_EPOCH_SECONDS) != 0;
    }

    private boolean editableIsSet() {
      return (optBits & OPT_BIT_EDITABLE) != 0;
    }

    private boolean sizeIsSet() {
      return (optBits & OPT_BIT_SIZE) != 0;
    }

    private boolean externalIsSet() {
      return (optBits & OPT_BIT_EXTERNAL) != 0;
    }

    private boolean isPublicIsSet() {
      return (optBits & OPT_BIT_IS_PUBLIC) != 0;
    }

    private boolean publicUrlSharedIsSet() {
      return (optBits & OPT_BIT_PUBLIC_URL_SHARED) != 0;
    }

    private boolean displayAsBotIsSet() {
      return (optBits & OPT_BIT_DISPLAY_AS_BOT) != 0;
    }

    private boolean commentsCountIsSet() {
      return (optBits & OPT_BIT_COMMENTS_COUNT) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
