package com.hubspot.slack.client.models.events.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ReplyIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Reply.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ReplyIF"})
@Immutable
public final class Reply implements ReplyIF {
  private final String user;
  private final String ts;

  private Reply(String user, String ts) {
    this.user = user;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public String getUser() {
    return user;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplyIF#getUser() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final Reply withUser(String user) {
    if (this.user.equals(user)) return this;
    String newValue = Objects.requireNonNull(user, "user");
    return new Reply(newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplyIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final Reply withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new Reply(this.user, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Reply} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Reply
        && equalTo((Reply) another);
  }

  private boolean equalTo(Reply another) {
    return user.equals(another.user)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code user}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + user.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Reply} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Reply{"
        + "user=" + user
        + ", ts=" + ts
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReplyIF {
    @Nullable String user;
    @Nullable String ts;
    @JsonProperty
    public void setUser(String user) {
      this.user = user;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getUser() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Reply fromJson(Json json) {
    Reply.Builder builder = Reply.builder();
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReplyIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Reply instance
   */
  public static Reply copyOf(ReplyIF instance) {
    if (instance instanceof Reply) {
      return (Reply) instance;
    }
    return Reply.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Reply Reply}.
   * @return A new Reply builder
   */
  public static Reply.Builder builder() {
    return new Reply.Builder();
  }

  /**
   * Builds instances of type {@link Reply Reply}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private static final long INIT_BIT_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String user;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReplyIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReplyIF instance) {
      Objects.requireNonNull(instance, "instance");
      setUser(instance.getUser());
      setTs(instance.getTs());
      return this;
    }

    /**
     * Initializes the value for the {@link ReplyIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(String user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link ReplyIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link Reply Reply}.
     * @return An immutable instance of Reply
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Reply build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Reply(user, ts);
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIsSet()) attributes.add("user");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build Reply, some of required attributes are not set " + attributes;
    }
  }
}
