package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.users.SlackUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackUserChangeEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackUserChangeEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackUserChangeEventIF"})
@Immutable
public final class SlackUserChangeEvent
    implements SlackUserChangeEventIF {
  private final SlackUser user;
  private final SlackEventType type;

  private SlackUserChangeEvent(
      SlackUser user,
      SlackEventType type) {
    this.user = user;
    this.type = type;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUser getUser() {
    return user;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUserChangeEventIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final SlackUserChangeEvent withUser(SlackUser user) {
    if (this.user == user) return this;
    SlackUser newValue = Objects.requireNonNull(user, "user");
    return new SlackUserChangeEvent(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUserChangeEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackUserChangeEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackUserChangeEvent(this.user, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackUserChangeEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackUserChangeEvent
        && equalTo((SlackUserChangeEvent) another);
  }

  private boolean equalTo(SlackUserChangeEvent another) {
    return user.equals(another.user)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code user}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + user.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackUserChangeEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackUserChangeEvent{"
        + "user=" + user
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackUserChangeEventIF {
    @Nullable SlackUser user;
    @Nullable SlackEventType type;
    @JsonProperty
    public void setUser(SlackUser user) {
      this.user = user;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public SlackUser getUser() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackUserChangeEvent fromJson(Json json) {
    SlackUserChangeEvent.Builder builder = SlackUserChangeEvent.builder();
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackUserChangeEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackUserChangeEvent instance
   */
  public static SlackUserChangeEvent copyOf(SlackUserChangeEventIF instance) {
    if (instance instanceof SlackUserChangeEvent) {
      return (SlackUserChangeEvent) instance;
    }
    return SlackUserChangeEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackUserChangeEvent SlackUserChangeEvent}.
   * @return A new SlackUserChangeEvent builder
   */
  public static SlackUserChangeEvent.Builder builder() {
    return new SlackUserChangeEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackUserChangeEvent SlackUserChangeEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable SlackUser user;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.user.SlackUserChangeEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUserChangeEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackUserChangeEventIF) {
        SlackUserChangeEventIF instance = (SlackUserChangeEventIF) object;
        setUser(instance.getUser());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackUserChangeEventIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUser user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackUserChangeEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackUserChangeEvent SlackUserChangeEvent}.
     * @return An immutable instance of SlackUserChangeEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackUserChangeEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackUserChangeEvent(user, type);
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIsSet()) attributes.add("user");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackUserChangeEvent, some of required attributes are not set " + attributes;
    }
  }
}
