package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackMemberLeftChannelEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackMemberLeftChannelEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackMemberLeftChannelEventIF"})
@Immutable
public final class SlackMemberLeftChannelEvent
    implements SlackMemberLeftChannelEventIF {
  private final String userId;
  private final String channelId;
  private final ChannelType channelType;
  private final String team;
  private final SlackEventType type;

  private SlackMemberLeftChannelEvent(
      String userId,
      String channelId,
      ChannelType channelType,
      String team,
      SlackEventType type) {
    this.userId = userId;
    this.channelId = channelId;
    this.channelType = channelType;
    this.team = team;
    this.type = type;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code channelType} attribute
   */
  @JsonProperty
  @Override
  public ChannelType getChannelType() {
    return channelType;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public String getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberLeftChannelEventIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberLeftChannelEvent withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackMemberLeftChannelEvent(newValue, this.channelId, this.channelType, this.team, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberLeftChannelEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberLeftChannelEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackMemberLeftChannelEvent(this.userId, newValue, this.channelType, this.team, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberLeftChannelEventIF#getChannelType() channelType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channelType A new value for channelType
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberLeftChannelEvent withChannelType(ChannelType channelType) {
    if (this.channelType == channelType) return this;
    ChannelType newValue = Objects.requireNonNull(channelType, "channelType");
    return new SlackMemberLeftChannelEvent(this.userId, this.channelId, newValue, this.team, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberLeftChannelEventIF#getTeam() team} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberLeftChannelEvent withTeam(String team) {
    if (this.team.equals(team)) return this;
    String newValue = Objects.requireNonNull(team, "team");
    return new SlackMemberLeftChannelEvent(this.userId, this.channelId, this.channelType, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberLeftChannelEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberLeftChannelEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackMemberLeftChannelEvent(this.userId, this.channelId, this.channelType, this.team, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackMemberLeftChannelEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackMemberLeftChannelEvent
        && equalTo((SlackMemberLeftChannelEvent) another);
  }

  private boolean equalTo(SlackMemberLeftChannelEvent another) {
    return userId.equals(another.userId)
        && channelId.equals(another.channelId)
        && channelType.equals(another.channelType)
        && team.equals(another.team)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code channelId}, {@code channelType}, {@code team}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + channelType.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackMemberLeftChannelEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackMemberLeftChannelEvent{"
        + "userId=" + userId
        + ", channelId=" + channelId
        + ", channelType=" + channelType
        + ", team=" + team
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackMemberLeftChannelEventIF {
    @Nullable String userId;
    @Nullable String channelId;
    @Nullable ChannelType channelType;
    @Nullable String team;
    @Nullable SlackEventType type;
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setChannelType(ChannelType channelType) {
      this.channelType = channelType;
    }
    @JsonProperty
    public void setTeam(String team) {
      this.team = team;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelType getChannelType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackMemberLeftChannelEvent fromJson(Json json) {
    SlackMemberLeftChannelEvent.Builder builder = SlackMemberLeftChannelEvent.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.channelType != null) {
      builder.setChannelType(json.channelType);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackMemberLeftChannelEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackMemberLeftChannelEvent instance
   */
  public static SlackMemberLeftChannelEvent copyOf(SlackMemberLeftChannelEventIF instance) {
    if (instance instanceof SlackMemberLeftChannelEvent) {
      return (SlackMemberLeftChannelEvent) instance;
    }
    return SlackMemberLeftChannelEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackMemberLeftChannelEvent SlackMemberLeftChannelEvent}.
   * @return A new SlackMemberLeftChannelEvent builder
   */
  public static SlackMemberLeftChannelEvent.Builder builder() {
    return new SlackMemberLeftChannelEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackMemberLeftChannelEvent SlackMemberLeftChannelEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private static final long INIT_BIT_CHANNEL_TYPE = 0x4L;
    private static final long INIT_BIT_TEAM = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String userId;
    private @Nullable String channelId;
    private @Nullable ChannelType channelType;
    private @Nullable String team;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.user.SlackMemberLeftChannelEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackMemberLeftChannelEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
      if (object instanceof SlackMemberLeftChannelEventIF) {
        SlackMemberLeftChannelEventIF instance = (SlackMemberLeftChannelEventIF) object;
        setChannelType(instance.getChannelType());
        setTeam(instance.getTeam());
        setUserId(instance.getUserId());
        setChannelId(instance.getChannelId());
      }
    }

    /**
     * Initializes the value for the {@link SlackMemberLeftChannelEventIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberLeftChannelEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberLeftChannelEventIF#getChannelType() channelType} attribute.
     * @param channelType The value for channelType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelType(ChannelType channelType) {
      this.channelType = Objects.requireNonNull(channelType, "channelType");
      initBits &= ~INIT_BIT_CHANNEL_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberLeftChannelEventIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(String team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberLeftChannelEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackMemberLeftChannelEvent SlackMemberLeftChannelEvent}.
     * @return An immutable instance of SlackMemberLeftChannelEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackMemberLeftChannelEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackMemberLeftChannelEvent(userId, channelId, channelType, team, type);
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean channelTypeIsSet() {
      return (initBits & INIT_BIT_CHANNEL_TYPE) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!channelTypeIsSet()) attributes.add("channelType");
      if (!teamIsSet()) attributes.add("team");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackMemberLeftChannelEvent, some of required attributes are not set " + attributes;
    }
  }
}
