package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackMemberJoinedChannelEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackMemberJoinedChannelEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackMemberJoinedChannelEventIF"})
@Immutable
public final class SlackMemberJoinedChannelEvent
    implements SlackMemberJoinedChannelEventIF {
  private final String userId;
  private final String channelId;
  private final ChannelType channelType;
  private final String team;
  private final @Nullable String inviterId;
  private final SlackEventType type;

  private SlackMemberJoinedChannelEvent(
      String userId,
      String channelId,
      ChannelType channelType,
      String team,
      @Nullable String inviterId,
      SlackEventType type) {
    this.userId = userId;
    this.channelId = channelId;
    this.channelType = channelType;
    this.team = team;
    this.inviterId = inviterId;
    this.type = type;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code channelType} attribute
   */
  @JsonProperty
  @Override
  public ChannelType getChannelType() {
    return channelType;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public String getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code inviterId} attribute
   */
  @JsonProperty("inviter")
  @Override
  public Optional<String> getInviterId() {
    return Optional.ofNullable(inviterId);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberJoinedChannelEventIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackMemberJoinedChannelEvent(newValue, this.channelId, this.channelType, this.team, this.inviterId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberJoinedChannelEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackMemberJoinedChannelEvent(this.userId, newValue, this.channelType, this.team, this.inviterId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberJoinedChannelEventIF#getChannelType() channelType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channelType A new value for channelType
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withChannelType(ChannelType channelType) {
    if (this.channelType == channelType) return this;
    ChannelType newValue = Objects.requireNonNull(channelType, "channelType");
    return new SlackMemberJoinedChannelEvent(this.userId, this.channelId, newValue, this.team, this.inviterId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberJoinedChannelEventIF#getTeam() team} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withTeam(String team) {
    if (this.team.equals(team)) return this;
    String newValue = Objects.requireNonNull(team, "team");
    return new SlackMemberJoinedChannelEvent(this.userId, this.channelId, this.channelType, newValue, this.inviterId, this.type);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackMemberJoinedChannelEventIF#getInviterId() inviterId} attribute.
   * @param value The value for inviterId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withInviterId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.inviterId, newValue)) return this;
    return new SlackMemberJoinedChannelEvent(this.userId, this.channelId, this.channelType, this.team, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackMemberJoinedChannelEventIF#getInviterId() inviterId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for inviterId
   * @return A modified copy of {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withInviterId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.inviterId, value)) return this;
    return new SlackMemberJoinedChannelEvent(this.userId, this.channelId, this.channelType, this.team, value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackMemberJoinedChannelEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackMemberJoinedChannelEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackMemberJoinedChannelEvent(this.userId, this.channelId, this.channelType, this.team, this.inviterId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackMemberJoinedChannelEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackMemberJoinedChannelEvent
        && equalTo((SlackMemberJoinedChannelEvent) another);
  }

  private boolean equalTo(SlackMemberJoinedChannelEvent another) {
    return userId.equals(another.userId)
        && channelId.equals(another.channelId)
        && channelType.equals(another.channelType)
        && team.equals(another.team)
        && Objects.equals(inviterId, another.inviterId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code channelId}, {@code channelType}, {@code team}, {@code inviterId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + channelType.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + Objects.hashCode(inviterId);
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackMemberJoinedChannelEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackMemberJoinedChannelEvent{");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("channelType=").append(channelType);
    builder.append(", ");
    builder.append("team=").append(team);
    if (inviterId != null) {
      builder.append(", ");
      builder.append("inviterId=").append(inviterId);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements SlackMemberJoinedChannelEventIF {
    @Nullable String userId;
    @Nullable String channelId;
    @Nullable ChannelType channelType;
    @Nullable String team;
    Optional<String> inviterId = Optional.empty();
    @Nullable SlackEventType type;
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setChannelType(ChannelType channelType) {
      this.channelType = channelType;
    }
    @JsonProperty
    public void setTeam(String team) {
      this.team = team;
    }
    @JsonProperty("inviter")
    public void setInviterId(Optional<String> inviterId) {
      this.inviterId = inviterId;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelType getChannelType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInviterId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackMemberJoinedChannelEvent fromJson(Json json) {
    SlackMemberJoinedChannelEvent.Builder builder = SlackMemberJoinedChannelEvent.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.channelType != null) {
      builder.setChannelType(json.channelType);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.inviterId != null) {
      builder.setInviterId(json.inviterId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackMemberJoinedChannelEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackMemberJoinedChannelEvent instance
   */
  public static SlackMemberJoinedChannelEvent copyOf(SlackMemberJoinedChannelEventIF instance) {
    if (instance instanceof SlackMemberJoinedChannelEvent) {
      return (SlackMemberJoinedChannelEvent) instance;
    }
    return SlackMemberJoinedChannelEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackMemberJoinedChannelEvent SlackMemberJoinedChannelEvent}.
   * @return A new SlackMemberJoinedChannelEvent builder
   */
  public static SlackMemberJoinedChannelEvent.Builder builder() {
    return new SlackMemberJoinedChannelEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackMemberJoinedChannelEvent SlackMemberJoinedChannelEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private static final long INIT_BIT_CHANNEL_TYPE = 0x4L;
    private static final long INIT_BIT_TEAM = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String userId;
    private @Nullable String channelId;
    private @Nullable ChannelType channelType;
    private @Nullable String team;
    private @Nullable String inviterId;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.user.SlackMemberJoinedChannelEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackMemberJoinedChannelEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackMemberJoinedChannelEventIF) {
        SlackMemberJoinedChannelEventIF instance = (SlackMemberJoinedChannelEventIF) object;
        setChannelType(instance.getChannelType());
        setTeam(instance.getTeam());
        Optional<String> inviterIdOptional = instance.getInviterId();
        if (inviterIdOptional.isPresent()) {
          setInviterId(inviterIdOptional);
        }
        setUserId(instance.getUserId());
        setChannelId(instance.getChannelId());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackMemberJoinedChannelEventIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberJoinedChannelEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberJoinedChannelEventIF#getChannelType() channelType} attribute.
     * @param channelType The value for channelType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelType(ChannelType channelType) {
      this.channelType = Objects.requireNonNull(channelType, "channelType");
      initBits &= ~INIT_BIT_CHANNEL_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberJoinedChannelEventIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(String team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackMemberJoinedChannelEventIF#getInviterId() inviterId} to inviterId.
     * @param inviterId The value for inviterId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInviterId(@Nullable String inviterId) {
      this.inviterId = inviterId;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackMemberJoinedChannelEventIF#getInviterId() inviterId} to inviterId.
     * @param inviterId The value for inviterId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInviterId(Optional<String> inviterId) {
      this.inviterId = inviterId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackMemberJoinedChannelEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackMemberJoinedChannelEvent SlackMemberJoinedChannelEvent}.
     * @return An immutable instance of SlackMemberJoinedChannelEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackMemberJoinedChannelEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackMemberJoinedChannelEvent(userId, channelId, channelType, team, inviterId, type);
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean channelTypeIsSet() {
      return (initBits & INIT_BIT_CHANNEL_TYPE) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!channelTypeIsSet()) attributes.add("channelType");
      if (!teamIsSet()) attributes.add("team");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackMemberJoinedChannelEvent, some of required attributes are not set " + attributes;
    }
  }
}
