package com.hubspot.slack.client.models.events.links;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackLinkSharedEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackLinkSharedEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackLinkSharedEventIF"})
@Immutable
public final class SlackLinkSharedEvent
    implements SlackLinkSharedEventIF {
  private final String channelId;
  private final String userId;
  private final String messageTs;
  private final @Nullable String threadTs;
  private final List<Link> links;
  private final SlackEventType type;

  private SlackLinkSharedEvent(
      String channelId,
      String userId,
      String messageTs,
      @Nullable String threadTs,
      List<Link> links,
      SlackEventType type) {
    this.channelId = channelId;
    this.userId = userId;
    this.messageTs = messageTs;
    this.threadTs = threadTs;
    this.links = links;
    this.type = type;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code messageTs} attribute
   */
  @JsonProperty
  @Override
  public String getMessageTs() {
    return messageTs;
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getThreadTs() {
    return Optional.ofNullable(threadTs);
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @JsonProperty
  @Override
  public List<Link> getLinks() {
    return links;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackLinkSharedEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackLinkSharedEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackLinkSharedEvent(newValue, this.userId, this.messageTs, this.threadTs, this.links, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackLinkSharedEventIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackLinkSharedEvent withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackLinkSharedEvent(this.channelId, newValue, this.messageTs, this.threadTs, this.links, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackLinkSharedEventIF#getMessageTs() messageTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param messageTs A new value for messageTs
   * @return A modified copy of the {@code this} object
   */
  public final SlackLinkSharedEvent withMessageTs(String messageTs) {
    if (this.messageTs.equals(messageTs)) return this;
    String newValue = Objects.requireNonNull(messageTs, "messageTs");
    return new SlackLinkSharedEvent(this.channelId, this.userId, newValue, this.threadTs, this.links, this.type);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackLinkSharedEventIF#getThreadTs() threadTs} attribute.
   * @param value The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackLinkSharedEvent withThreadTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTs, newValue)) return this;
    return new SlackLinkSharedEvent(this.channelId, this.userId, this.messageTs, newValue, this.links, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackLinkSharedEventIF#getThreadTs() threadTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTs
   * @return A modified copy of {@code this} object
   */
  public final SlackLinkSharedEvent withThreadTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTs, value)) return this;
    return new SlackLinkSharedEvent(this.channelId, this.userId, this.messageTs, value, this.links, this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackLinkSharedEventIF#getLinks() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackLinkSharedEvent withLinks(Link... elements) {
    List<Link> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackLinkSharedEvent(this.channelId, this.userId, this.messageTs, this.threadTs, newValue, this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackLinkSharedEventIF#getLinks() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackLinkSharedEvent withLinks(Iterable<? extends Link> elements) {
    if (this.links == elements) return this;
    List<Link> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackLinkSharedEvent(this.channelId, this.userId, this.messageTs, this.threadTs, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackLinkSharedEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackLinkSharedEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackLinkSharedEvent(this.channelId, this.userId, this.messageTs, this.threadTs, this.links, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackLinkSharedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackLinkSharedEvent
        && equalTo((SlackLinkSharedEvent) another);
  }

  private boolean equalTo(SlackLinkSharedEvent another) {
    return channelId.equals(another.channelId)
        && userId.equals(another.userId)
        && messageTs.equals(another.messageTs)
        && Objects.equals(threadTs, another.threadTs)
        && links.equals(another.links)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code userId}, {@code messageTs}, {@code threadTs}, {@code links}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + messageTs.hashCode();
    h = h * 17 + Objects.hashCode(threadTs);
    h = h * 17 + links.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackLinkSharedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackLinkSharedEvent{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("messageTs=").append(messageTs);
    if (threadTs != null) {
      builder.append(", ");
      builder.append("threadTs=").append(threadTs);
    }
    builder.append(", ");
    builder.append("links=").append(links);
    builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackLinkSharedEventIF {
    @Nullable String channelId;
    @Nullable String userId;
    @Nullable String messageTs;
    Optional<String> threadTs = Optional.empty();
    List<Link> links = Collections.emptyList();
    @Nullable SlackEventType type;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setMessageTs(String messageTs) {
      this.messageTs = messageTs;
    }
    @JsonProperty
    public void setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty
    public void setLinks(List<Link> links) {
      this.links = links;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessageTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public List<Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackLinkSharedEvent fromJson(Json json) {
    SlackLinkSharedEvent.Builder builder = SlackLinkSharedEvent.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.messageTs != null) {
      builder.setMessageTs(json.messageTs);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.links != null) {
      builder.addAllLinks(json.links);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackLinkSharedEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackLinkSharedEvent instance
   */
  public static SlackLinkSharedEvent copyOf(SlackLinkSharedEventIF instance) {
    if (instance instanceof SlackLinkSharedEvent) {
      return (SlackLinkSharedEvent) instance;
    }
    return SlackLinkSharedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackLinkSharedEvent SlackLinkSharedEvent}.
   * @return A new SlackLinkSharedEvent builder
   */
  public static SlackLinkSharedEvent.Builder builder() {
    return new SlackLinkSharedEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackLinkSharedEvent SlackLinkSharedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private static final long INIT_BIT_MESSAGE_TS = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String channelId;
    private @Nullable String userId;
    private @Nullable String messageTs;
    private @Nullable String threadTs;
    private List<Link> links = new ArrayList<Link>();
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.links.SlackLinkSharedEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackLinkSharedEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackLinkSharedEventIF) {
        SlackLinkSharedEventIF instance = (SlackLinkSharedEventIF) object;
        addAllLinks(instance.getLinks());
        Optional<String> threadTsOptional = instance.getThreadTs();
        if (threadTsOptional.isPresent()) {
          setThreadTs(threadTsOptional);
        }
        setUserId(instance.getUserId());
        setMessageTs(instance.getMessageTs());
        setChannelId(instance.getChannelId());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackLinkSharedEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackLinkSharedEventIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackLinkSharedEventIF#getMessageTs() messageTs} attribute.
     * @param messageTs The value for messageTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageTs(String messageTs) {
      this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
      initBits &= ~INIT_BIT_MESSAGE_TS;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackLinkSharedEventIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTs(@Nullable String threadTs) {
      this.threadTs = threadTs;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackLinkSharedEventIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link SlackLinkSharedEventIF#getLinks() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLinks(Link element) {
      this.links.add(Objects.requireNonNull(element, "links element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackLinkSharedEventIF#getLinks() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addLinks(Link... elements) {
      for (Link element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackLinkSharedEventIF#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLinks(Iterable<? extends Link> elements) {
      this.links.clear();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link SlackLinkSharedEventIF#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLinks(Iterable<? extends Link> elements) {
      for (Link element : elements) {
        this.links.add(Objects.requireNonNull(element, "links element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackLinkSharedEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackLinkSharedEvent SlackLinkSharedEvent}.
     * @return An immutable instance of SlackLinkSharedEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackLinkSharedEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackLinkSharedEvent(channelId, userId, messageTs, threadTs, createUnmodifiableList(true, links), type);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean messageTsIsSet() {
      return (initBits & INIT_BIT_MESSAGE_TS) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!userIdIsSet()) attributes.add("userId");
      if (!messageTsIsSet()) attributes.add("messageTs");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackLinkSharedEvent, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
