package com.hubspot.slack.client.models.events.links;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link LinkIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Link.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "LinkIF"})
@Immutable
public final class Link implements LinkIF {
  private final String domain;
  private final String url;

  private Link(String domain, String url) {
    this.domain = domain;
    this.url = url;
  }

  /**
   * @return The value of the {@code domain} attribute
   */
  @JsonProperty
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LinkIF#getDomain() domain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param domain A new value for domain
   * @return A modified copy of the {@code this} object
   */
  public final Link withDomain(String domain) {
    if (this.domain.equals(domain)) return this;
    String newValue = Objects.requireNonNull(domain, "domain");
    return new Link(newValue, this.url);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LinkIF#getUrl() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param url A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final Link withUrl(String url) {
    if (this.url.equals(url)) return this;
    String newValue = Objects.requireNonNull(url, "url");
    return new Link(this.domain, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Link} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Link
        && equalTo((Link) another);
  }

  private boolean equalTo(Link another) {
    return domain.equals(another.domain)
        && url.equals(another.url);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + domain.hashCode();
    h = h * 17 + url.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Link} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Link{"
        + "domain=" + domain
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LinkIF {
    @Nullable String domain;
    @Nullable String url;
    @JsonProperty
    public void setDomain(String domain) {
      this.domain = domain;
    }
    @JsonProperty
    public void setUrl(String url) {
      this.url = url;
    }
    @Override
    public String getDomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Link fromJson(Json json) {
    Link.Builder builder = Link.builder();
    if (json.domain != null) {
      builder.setDomain(json.domain);
    }
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LinkIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Link instance
   */
  public static Link copyOf(LinkIF instance) {
    if (instance instanceof Link) {
      return (Link) instance;
    }
    return Link.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Link Link}.
   * @return A new Link builder
   */
  public static Link.Builder builder() {
    return new Link.Builder();
  }

  /**
   * Builds instances of type {@link Link Link}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_URL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String domain;
    private @Nullable String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LinkIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LinkIF instance) {
      Objects.requireNonNull(instance, "instance");
      setDomain(instance.getDomain());
      setUrl(instance.getUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link LinkIF#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDomain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link LinkIF#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Builds a new {@link Link Link}.
     * @return An immutable instance of Link
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Link build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Link(domain, url);
    }

    private boolean domainIsSet() {
      return (initBits & INIT_BIT_DOMAIN) == 0;
    }

    private boolean urlIsSet() {
      return (initBits & INIT_BIT_URL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!domainIsSet()) attributes.add("domain");
      if (!urlIsSet()) attributes.add("url");
      return "Cannot build Link, some of required attributes are not set " + attributes;
    }
  }
}
