package com.hubspot.slack.client.models.events.bot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.response.views.HomeTabViewResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackAppHomeOpenedEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackAppHomeOpenedEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackAppHomeOpenedEventIF"})
@Immutable
public final class SlackAppHomeOpenedEvent
    implements SlackAppHomeOpenedEventIF {
  private final @Nullable String tab;
  private final @Nullable HomeTabViewResponse view;
  private final String userId;
  private final String channelId;
  private final SlackEventType type;

  private SlackAppHomeOpenedEvent(
      @Nullable String tab,
      @Nullable HomeTabViewResponse view,
      String userId,
      String channelId,
      SlackEventType type) {
    this.tab = tab;
    this.view = view;
    this.userId = userId;
    this.channelId = channelId;
    this.type = type;
  }

  /**
   * @return The value of the {@code tab} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTab() {
    return Optional.ofNullable(tab);
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public Optional<HomeTabViewResponse> getView() {
    return Optional.ofNullable(view);
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackAppHomeOpenedEventIF#getTab() tab} attribute.
   * @param value The value for tab, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackAppHomeOpenedEvent withTab(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.tab, newValue)) return this;
    return new SlackAppHomeOpenedEvent(newValue, this.view, this.userId, this.channelId, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackAppHomeOpenedEventIF#getTab() tab} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tab
   * @return A modified copy of {@code this} object
   */
  public final SlackAppHomeOpenedEvent withTab(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tab, value)) return this;
    return new SlackAppHomeOpenedEvent(value, this.view, this.userId, this.channelId, this.type);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackAppHomeOpenedEventIF#getView() view} attribute.
   * @param value The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackAppHomeOpenedEvent withView(@Nullable HomeTabViewResponse value) {
    @Nullable HomeTabViewResponse newValue = value;
    if (this.view == newValue) return this;
    return new SlackAppHomeOpenedEvent(this.tab, newValue, this.userId, this.channelId, this.type);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackAppHomeOpenedEventIF#getView() view} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for view
   * @return A modified copy of {@code this} object
   */
  public final SlackAppHomeOpenedEvent withView(Optional<HomeTabViewResponse> optional) {
    @Nullable HomeTabViewResponse value = optional.orElse(null);
    if (this.view == value) return this;
    return new SlackAppHomeOpenedEvent(this.tab, value, this.userId, this.channelId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackAppHomeOpenedEventIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackAppHomeOpenedEvent withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackAppHomeOpenedEvent(this.tab, this.view, newValue, this.channelId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackAppHomeOpenedEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackAppHomeOpenedEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackAppHomeOpenedEvent(this.tab, this.view, this.userId, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackAppHomeOpenedEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackAppHomeOpenedEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackAppHomeOpenedEvent(this.tab, this.view, this.userId, this.channelId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackAppHomeOpenedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackAppHomeOpenedEvent
        && equalTo((SlackAppHomeOpenedEvent) another);
  }

  private boolean equalTo(SlackAppHomeOpenedEvent another) {
    return Objects.equals(tab, another.tab)
        && Objects.equals(view, another.view)
        && userId.equals(another.userId)
        && channelId.equals(another.channelId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code tab}, {@code view}, {@code userId}, {@code channelId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(tab);
    h = h * 17 + Objects.hashCode(view);
    h = h * 17 + userId.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackAppHomeOpenedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackAppHomeOpenedEvent{");
    if (tab != null) {
      builder.append("tab=").append(tab);
    }
    if (view != null) {
      if (builder.length() > 24) builder.append(", ");
      builder.append("view=").append(view);
    }
    if (builder.length() > 24) builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("type=").append(type);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackAppHomeOpenedEventIF {
    Optional<String> tab = Optional.empty();
    Optional<HomeTabViewResponse> view = Optional.empty();
    @Nullable String userId;
    @Nullable String channelId;
    @Nullable SlackEventType type;
    @JsonProperty
    public void setTab(Optional<String> tab) {
      this.tab = tab;
    }
    @JsonProperty
    public void setView(Optional<HomeTabViewResponse> view) {
      this.view = view;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public Optional<String> getTab() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<HomeTabViewResponse> getView() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackAppHomeOpenedEvent fromJson(Json json) {
    SlackAppHomeOpenedEvent.Builder builder = SlackAppHomeOpenedEvent.builder();
    if (json.tab != null) {
      builder.setTab(json.tab);
    }
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackAppHomeOpenedEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackAppHomeOpenedEvent instance
   */
  public static SlackAppHomeOpenedEvent copyOf(SlackAppHomeOpenedEventIF instance) {
    if (instance instanceof SlackAppHomeOpenedEvent) {
      return (SlackAppHomeOpenedEvent) instance;
    }
    return SlackAppHomeOpenedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackAppHomeOpenedEvent SlackAppHomeOpenedEvent}.
   * @return A new SlackAppHomeOpenedEvent builder
   */
  public static SlackAppHomeOpenedEvent.Builder builder() {
    return new SlackAppHomeOpenedEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackAppHomeOpenedEvent SlackAppHomeOpenedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String tab;
    private @Nullable HomeTabViewResponse view;
    private @Nullable String userId;
    private @Nullable String channelId;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.bot.SlackAppHomeOpenedEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackAppHomeOpenedEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackAppHomeOpenedEventIF) {
        SlackAppHomeOpenedEventIF instance = (SlackAppHomeOpenedEventIF) object;
        Optional<HomeTabViewResponse> viewOptional = instance.getView();
        if (viewOptional.isPresent()) {
          setView(viewOptional);
        }
        Optional<String> tabOptional = instance.getTab();
        if (tabOptional.isPresent()) {
          setTab(tabOptional);
        }
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
        setChannelId(instance.getChannelId());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
      if (object instanceof HasUser) {
        HasUser instance = (HasUser) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the optional value {@link SlackAppHomeOpenedEventIF#getTab() tab} to tab.
     * @param tab The value for tab, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTab(@Nullable String tab) {
      this.tab = tab;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackAppHomeOpenedEventIF#getTab() tab} to tab.
     * @param tab The value for tab
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTab(Optional<String> tab) {
      this.tab = tab.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackAppHomeOpenedEventIF#getView() view} to view.
     * @param view The value for view, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setView(@Nullable HomeTabViewResponse view) {
      this.view = view;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackAppHomeOpenedEventIF#getView() view} to view.
     * @param view The value for view
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(Optional<HomeTabViewResponse> view) {
      this.view = view.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackAppHomeOpenedEventIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackAppHomeOpenedEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackAppHomeOpenedEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackAppHomeOpenedEvent SlackAppHomeOpenedEvent}.
     * @return An immutable instance of SlackAppHomeOpenedEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackAppHomeOpenedEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackAppHomeOpenedEvent(tab, view, userId, channelId, type);
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackAppHomeOpenedEvent, some of required attributes are not set " + attributes;
    }
  }
}
